# Аврора SDK

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

**Примечание.**
Модуль следует рассказывать после модуля про [Qt Creator](../qt_creator).

## Состав Аврора SDK

Аврора SDK основана на Qt Creator. Qt Creator — кроссплатформенная среда разработки, используемая
при работе с фреймворком Qt.
Эта IDE включает в себя все компоненты, присущие любой интегрированной среде разработки:
редактор кода, компилятор, отладчик.
Также она поддерживает интеграцию с системами контроля версий, валидацию и подпись пакетов.

Помимо IDE, в состав SDK входят:

*	Aurora OS Emulator (эмулятор) — виртуальная машина, которая позволяет выполнять приложения
	в окружении ОС Аврора аналогично работе на реальном устройстве.
*	Aurora OS Build Engine (среда сборки) — окружение, поставляемое как виртуальная машина
	или Docker-контейнер, которое обеспечивает среду для сборки приложений,
	не зависящую от домашней операционной системы.
*	Документация по архитектуре и API.
*	Примеры и шаблоны приложений.

Система сборки и эмулятор поставляются в виде образов виртуальных машин для VirtualBox.
Однако, сам VirtualBox в состав SDK не входит.
Поэтому перед установкой SDK, необходимо сначала установить VirtualBox версии не ниже чем 4.1.18.
Альтернативно, начиная с версии ОС Аврора 4, можно использовать Docker.
Аврора SDK доступен для Linux, Windows и macOS.
SDK поставляется в виде графического инсталлятора, поэтому установка не должна вызывать трудностей.

## Варианты поставок Аврора SDK

Аврора SDK имеет следующие варианты поставки:

| Вариант | Аврора SDK (mb2) | Аврора SDK (BT) |
|:---|:---|:---|
| Среда сборки | Aurora OS Build Engine — окружение, поставляемое как виртуальная машина или Docker-образ, которое обеспечивает среду для сборки приложений, не зависящую от хостовой операционной системы | Аврора Build Tools — инструменты для кросс-компиляции |
| Инструмент сборки | mb2 | apptool |
| Процесс сборки | Сборка происходит кросс-компилятором `gcc` в окружении таргета. Для каждой архитектуры (x86_64, armv7hl, aarch64) эмулируется окружение сборки, таким образом инструменты сборки выполняют сборку так, как бы выполняли её нативно. | Сборка происходит кросс-компилятором `gcc` в окружении x86_64. Для сборки под архитектуры armv7hl и aarch64 в поставке имеется sysroot с библиотеками и исходными файлами для сборки. |
| Добавление пакетов | Предусмотрена возможность доустановки пакетов из официального репозитория, в том числе тех, которые не разрешены валидатором. | Нет возможности доустановить пакет из репозитория. Все библиотеки, разрешённые валидатором, поставляются в комплекте. Если нужных зависимостей нет, их требуется собирать самостоятельно.                    |
| Технология виртуализации для среды сборки | VirtualBox или Docker | Docker |

Таргет — это цель сборки; набор файлов, необходимых для сборки.

BT будет развиваться в будущих версиях ОС, MB2 - нет.

## Подключение внешнего устройства

Аврора SDK также может развернуть приложение на устройстве.
Для этой функции требуется, чтобы устройство было настроено с подключением USB или WLAN
к компьютеру и на нём был установлен пароль для работы через SSH.
Пароль задаётся на устройстве Настройки→Средства разработчика.
Для запуска приложения на устройстве в SDK необходимо выбрать подходящие параметры сборки.

Установка устройства осуществляется с помощью настроек IDE.
Это можно найти в меню «Инструменты» → «Параметры» → «Устройства».
В этом окне настроек нажмите «Добавить ...», чтобы начать создание настроек устройства.
Далее вы сможете дополнительно настроить конфигурацию соединения либо оставить конфигурацию по умолчанию.

## Aurora Debug Tool

Aurora Debug Tool (ADT) — это консольная утилита для отладки, управления и взаимодействия с ОС Аврора.

Не зависит от Аврора SDK.
Поддерживает Linux, MacOS, Windows.
Управляет устройствами и эмуляторами.
Управляет жизненным циклом приложения при разработке - загрузка, установка и отладка.
Получение логов системы и приложений.
Выполнение удаленных команд на устройстве или эмуляторе.

## Дополнительные возможности SDK

О дополнительных возможностях SDK можно узнать в документации по ссылкам на слайде.
