# Aurora Controls

Copyright&nbsp;©&nbsp;2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## QML-модуль Aurora Controls

Набор компонентов под названием Aurora Controls используется для отображения или служат контейнером для других элементов.

*	AppBar — Стилизованный контейнер для организации навигации в приложениях.
*	PopupMenu — Контейнер для создания всплывающих меню в приложении.
*	PopupToolMenu — Контейнер для создания всплывающих меню со встроенной нижней панелью инструментов.
*	SplitView — Компонент на основе стека с настраиваемым количеством отображаемых страниц.

Компоненты, реализующие жесты.

*	PullToRefresh — Предоставляет жест Pull-to-refresh для элементов.

## SplitView — отображаемые страницы

SplitView реализует модель навигации на основе стека, которая отображает один или несколько элементов,
расположенных горизонтально слева направо.

Стековая модель навигации упрощает иерархическую навигацию внутри приложения.
Когда приложению необходимо отобразить страницу с содержимым, новая страница может быть добавлена
в контейнер SplitView.
Если пользователь запросит возврат к предыдущей странице, то текущая страница может быть удалена
из стека, либо другая страница может быть добавлена в SplitView, чтобы глубже погрузиться
в иерархию интерфейса пользователя и т.д.

SplitView можно настроить для отображения одного или нескольких элементов с вершины стека.
Это, например, можно использовать для отображения одной самой верхней страницы в портретной ориентации
и нескольких самых верхних страниц в альбомной ориентации.

Текущий режим SplitView определяется свойствами firstActiveItem и lastActiveItem.
Первое содержит первый активный элемент, отображаемый в левой части SplitView, второе содержит
последний активный элемент, отображаемый в правой части SplitView.

SplitView поддерживает операции навигации push() и pop().
SplitView поддерживает жесты пользовательского интерфейса и стандартные кнопки, которые позволяют
пользователю легко вернуться назад.

## Пример SplitView

На слайде представлен пример представления SplitView.

## Жест PullToRefresh

Pull-to-refresh — это жест, позволяющий обновить содержимое графического элемента путём нажатия
на него и смещения точки касания вниз в область срабатывания жеста.
При достижении зоны срабатывания и отпуске пальца запускается обновление.

Граница срабатывания жеста находится на 30 миллиметров ниже от точки начала жеста.
Отпускание точки касания на этой границе или ниже неё запускает процесс обновления, о чём
информирует специальный элемент индикатора обновления.
После завершения процесса обновления пользователю может быть отображён статус обновления, например,
завершилось ли оно успешно или нет.

Базовые позиционирующие элементы (Column, Row, Flow и Grid) и все остальные визуальные элементы
поддерживают жест pull-to-refresh с помощью прикреплённого свойства PullToRefresh.
Чтобы добавить поддержку жестов к элементу, необходимо указать функцию обратного вызова
refreshHandler.
Чтобы скрыть индикатор обновления после завершения обновления и, по желанию, отобразить
статус обновления, необходимо вызвать refreshCompleted или refreshCompletedCustom.

## AppBar — контейнер для навигации

AppBar — это стилизованный контейнер для организации навигации в приложениях.
AppBar состоит из блока заголовка, блока компонентов и контекстной подсказки.
Блок заголовка не является обязательным.
Блок заголовка состоит из iconContainer, заголовка (headerText) и подзаголовка (subHeaderText).

Блок компонентов используется для размещения элементов AppBar.
Контекстная подсказка используется, когда соответствующие компоненты сфокусированы жестом вытягивания.

## Элементы AppBar

Компоненты управления, которые можно использовать внутри компонента AppBar.

*	AppBarButton — Компонент кнопки для использования в AppBar.
	*	text — Текст метки, отображаемой на кнопке.
	*	icon — Значок, показанный внутри кнопки.
	*	context — текст, который будет отображаться в блоке контекстной подсказки AppBar, когда компонент находится в фокусе.
*	AppBarSearchField — Текстовое поле для ввода поискового запроса.
	*	context — текст, который будет отображаться в блоке контекстной подсказки AppBar, когда компонент находится в фокусе.
	*	placeholderText — текст, который будет отображаться, когда text пуст.
	*	text — отображаемый текст.
*	AppBarSpacer — Заполняет пространство.

## Пример AppBar

На слайде представлен пример панели AppBar.

## PopupMenu — всплывающее меню

PopupMenu служит для создания всплывающего меню.
PopupMenu имеет постраничную вёрстку, каждая страница может содержать список PopupMenuItem
и производных от PopupMenuItem компонентов.

Позиционирование PopupMenu полностью автоматизировано.
Для показа PopupMenu необходимо передать в метод open(baseItem) базовый элемент baseItem,
от которого будет рассчитываться позиционирование PopupMenu на экране.
Если метод open(baseItem) вызвать без аргументов, то расчёт позиции будет происходить от родительского элемента.

## Элементы PopupMenu

Компоненты управления, которые можно использовать внутри компонента PopupMenu.

*	PopupMenuItem — Стандартный элемент для PopupMenu.
	*	text — основной текст.
	*	hint — дополнительный текст. Отображается под основным текстом.
	*	icon — иконка слева от текста. Иконка должна быть размером Theme.iconSizeSmallPlus.
	*	clicked() испускается при выборе пункта меню пользователем.
*	PopupMenuCheckableItem — Элемент меню с переключателем.
	*	checked  — состояние переключателя.
		При нажатии на элемент сначала испускается сигнал clicked(), а затем меняется состояние checked.
*	PopupMenuDividerItem — Элемент-разделитель для PopupMenu.
*	PopupSubMenuItem — Вложенное меню для PopupMenu.
*	PopupToolMenuButton — Кнопка для панели инструментов PopupToolMenu.

## Пример PopupMenu

На слайде представлен пример меню PopupMenu.
