# Тесты по теме «Анимации, состояния, переходы»

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Multiple choice

Какие данные необходимо получить от сервиса, чтобы подключиться к нему с помощью DBus?

---

*	**Название сервиса.**
*	**Название интерфейса.**
*	**Название определенной функции, которую хотим использовать.**
*	**Путь к сервису.**

## Single choice

Что такое сервис в контексте работы с DBus?

---

*	**Адрес приложения на шине.**
*	Набор функций.
*	Набор методов.
*	Группа методов и сигналов объекта.

## Single choice

В чём различие методов QDBusInterface call и typedCall?

---

*	call предназначен для вызова методов интерфейса с массивом в качестве аргумента, а typedCall - для вызова методов интерфейса с массивом объектов в качестве аргумента.
*	**call предназначен для вызова методов интерфейса с массивом в качестве аргумента, а typedCall - для вызова методов интерфейса с объектом в качестве аргумента.**

## Single choice

```qml
DBusInterface {
	id: dbusList
	service: 'org.freedesktop.DBus'
	path: '/org/freedesktop/DBus'
	iface: 'org.freedesktop.DBus'
	bus: DBus.SessionBus
}
```

Как правильно вызвать метод без аргументов через DBusInterface, предоставленный qml-плагином nemo?

---

*	**dbusList.call("getList", undefined)**
*	dbusList.call("getList")

## Single choice

```qml
DBusInterface {
	id: browser
	service: 'org.sailfishos.browser'
	path: '/'
	iface: 'org.sailfishos.browser'
	function open(url) {
	typedCall('openUrl',{'type': 'as', 'value': [url]},
		function() { console.log('success')},
		function(){console.log('fail') });
	}
}
```

Какой тип данных в качестве аргумента передаётся функции openUrl?

---

*	строка
*	**массив строк**
*	массив символов

## Multiple choice

Для чего нужен тип Notification?

---

*	**создание уведомлений**
*	**отправка уведомлений пользователю**
*	отправка уведомлений другим приложениям

## Single choice

Через какую службу Notification взаимодействует с Lipstick?

---

*	**DBus**
*	зависит от операционной системы

## Single choice

Можно ли изменить уведомление после отправки?

---

*	**да, можно заменить отправленное уведомление**
*	нет, можно только удалить и отправить уведомление заново

## Single choice

Можно ли включать изображения в уведомления?

---

*	да, в лобую часть уведомления
*	**да, но только в виде иконки приложения или значка уведомления**
*	нет

## Single choice

Можно ли создать уведомление, которое не будет закрываться автоматически?

---

*	**да**
*	нет

## Single choice

Как реализовать возможность пользователя взаимодействовать с приложением при помощи уведомлений?

---

*	Notification не предоставляет подобной функциональности
*	**В свойстве remoteActions можно задать список возможных действий пользователя и реакций на них**
*	Можно добавить в уведомление несколько стандартных кнопок, предоставляемых Notification

## Single choice

Когда будет опубликовано уведомление после его отправки?

---

*	немедленно после отправки
*	**через промежуток времени в зависимости от срочности уведомления и занятости дистпетчера**
*	задержку уведомления можно регулировать в приложении

## Single choice

```qml
Notification {
	id: notification
	summary: "Notification summary"
	body: "Notification body"
	onClicked: console.log("Clicked")
}
```

Будет ли опубликовано уведомление после выполнения данного кода?

---

*	да
*	**нет, так как в коде нет вызова метода публикации уведомления**

## Single choice

Что нужно знать для удаления конкретного уведомления?

---

*	**идентификатор replacesId**
*	уникальный заголовок
*	нужно иметь ссылку на конкретный объект уведомления

## Multiple choice

Для чего можно использовать плагин KeepAlive?

---

*	**управление блокировкой экрана**
*	управление включением и выключением устройства
*	**пробуждение системы**

## Single choice

Какие параметры у компонента KeepAlive можно задать для управления активностью?

---

*	**включить/выключить предотвращение приостановки**
*	не приостанавливать в течение заданного времени

## Single choice

Чем отличаются KeepAlive и DisplayBlanking?

---

*	**KeepAlive отвечает за управлением активностью системы, DisplayBlanking - за автоматическое включение/отключение экрана**
*	DisplayBlanking отвечает за управлением активностью системы, KeepAlive  - за автоматическое включение/отключение экрана

## Single choice

Можно ли управлять яркостью экрана при помощи DisplayBlanking?

---

*	да
*	нет, DisplayBlanking не содержит свойств, связанных с яркостью экрана
*	**можно отследить статус яркости экрана**

## Single choice

Для чего можно использовать BackgroundJob?

---

*	**управление пробуждениями системы**
*	управление статусом экрана

## Single choice

Что из данного списка можно использовать для запуска работы компонента BackgroundJob?

---

*	**свойство enabled**
*	метод start()

## Single choice

Какую частоту запуска по умолчанию имеет BackgroundJob?

---

*	секунда
*	минута
*	пять минут
*	**час**
*	24 часа

## Single choice

Будет ли BackgroundJob автоматически запущена после создания компонента?

---

*	да
*	**нет**

## Order

Расположите в правильном порядке действия, которые позволяют настроить и использовать push-уведомления:

---

*	Зарегистрировать приложение в push-демоне
*	Получить registrationId от push-демона
*	Передать registrationId собственному серверу
*	Отправить push-сообщение с сервера клиенту

## Single choice

Откуда можно получить applicationId клиентского приложения?

---

*	от push-демона
*	**от поддержки ОМП**
*	можно сгенерировать самостоятельно

## Single choice

Для чего можно использовать Push-плагин в Аврора IDE?

---

*	**как сервер, с которого отправляются уведомления**
*	как клиент, который получает уведомления
*	как плагин с настройками push-демона

## Text

Укажите название поля в секции [X-Application], в котором нужно описать команду
для запуска приложения через D-Bus.

---

ExecDBus
