# Жизненный цикл приложения в ОС Аврора

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Межпроцессное взаимодействие

Межпроцессное взаимодействие (Inter-Process communication, IPC) — обмен данными между потоками
одного или разных процессов.
Оно реализуется посредством механизмов, предоставляемых ядром ОС или процессом, использующим
механизмы ОС и реализующим новые возможности IPC.

Также встречаются термины Inter-Thread Communication и Inter-Application Communication.

Межпроцессное взаимодействие является основой для разграничения адресного пространства.
Оно позволяет осуществлять обмен данными между приложениями, которые работают
в различных адресных пространствах.
Общение между приложениями организуется в формате клиент-сервер.
Клиент запрашивает данные.
Сервер предоставляет данные.

## Методы взаимодействия

Распространённые механизмы взаимодействия:

*	файловая система - приложения могут пользоваться одними и теми же файлами;
*	сигналы о произошедших событиях;
*	сокеты TCP - приложения могут обмениваться сообщениями по сети;
*	очередь сообщений и обмен сообщениями между приложениями.

POSIX — набор стандартов, описывающих интерфейсы между операционной системой
и прикладной программой (системный API).
Стандарт создан для обеспечения совместимости различных UNIX-подобных операционных систем
и переносимости прикладных программ на уровне исходного кода.

Механизмы взаимодействия, которые декларируются POSIX:

*	сокеты UNIX domain;
*	каналы (PIPE);
*	иименованные каналы;
*	неименованные каналы;
*	семафоры;
*	разделяемая память;
*	утилита nmap.

## D-Bus (Desktop Bus)

Dbus или Desktop Bus — это система, предназначенная для взаимодействия процессов.
Она реализована на уровне операционной системы и предлагает стандартный API для дистрибутивов Linux.

Каждое приложение в системе DBus состоит из набора объектов, а сообщения пересылаются
не между приложениями, а между объектами этих самых приложений.

## Сущности D-Bus

Каждый объект имеет группу методов и сигналов.
Каждая такая группа — это отдельный интерфейс объекта.

В DBus используются специальные каналы или пути для передачи данных — шины.

*	Системная шина — для взаимодействия демонов
	(приложения без графического интерфейса — системные процессы).
*	Сессионная шина — для приложений с интерфейсом, с которыми взаимодействует пользователь..

При запуске приложение может зарегистрировать набор сервисов, которыми будет владеть, пока не освободит.

Сервис — это адрес приложения на шине, по которому оно может быть доступно для других процессов.

Сервисы, зарегистрированные одним приложением, не будут доступны для регистрации другими,
пока приложение их не освободит.

После подключения к шине приложение должно указать, какие сообщения оно желает получать,
путём добавления масок совпадений (matchers).
Маски представляют собой наборы правил для сообщений, которые будут доставляться приложению.
Фильтрация может основываться на интерфейсах, путях объектов и методах.

Сообщения в D-Bus бывают четырёх видов: вызовы методов, результаты вызовов методов,
сигналы (широковещательные сообщения) и ошибки.

В D-Bus у каждого объекта своё, уникальное имя, которое выглядит как путь в файловой системе.

Каждый объект может иметь свои методы, параметры, сигналы и слоты.

## Работа с D-Bus из консоли

На слайде приведена сигнатура утилиты dbus-send и пример получения списка доступных dbus-интерфейсов.

## Типы аргументов методов D-Bus

Сигнатура методов D-Bus.

Также как и методы в языках программирования, методы в D-Bus имеют аргументы и возвращаемое значение.

Их тип обозначается специальными сигнатурами, состоящими из символов юникода.
Примитивные типы:
*	y/q/u/t — восьми/шестнадцати/тридцати двух/шестидесяти четырех битный беззнаковый integer соответственно;
*	b — boolean, логический тип;
*	n/i/x — шестнадцати/тридцати двух/шестидесяти четырех битный integer соответственно;
*	d — double, s — string, o — путь объекта D-Bus, a — массив.

Символы могут комбинироваться между собой, например, as — массив строк.

## Интерфейсы D-Bus в ОС Аврора

В ОС Аврора представлены несколько системных программ, предоставляющих DBus-сервисы.
Их список периодически расширяется.

BlueZ обеспечивает поддержку Bluetooth.
Device Info API предоставляет информацию о параметрах устройства.
IUDID интерфейс для работы с идентификаторами устройств.
Уведомления Lipstick.
NFCD — драйвер устройств NFC.
Reports API генерирует отчёт с логами и информацией о системе.
sstore позволяет приложению хранить информацию в защищённом виде.

## Пример Device Info

На слайде приведён пример обращения к Device Info через консоль.

## Библиотеки для работы D-Bus

В ОС Аврора предусмотрено два варианта взаимодействия с D-Bus.

*	Nemo QML Plugin D-Bus, который позволяет взаимодействовать с D-Bus напрямую из QML кода.
*	Qt D-Bus— стандартный механизм Qt, предоставляющий С++ классы для взаимодействия с D-Bus.

Разница между ними в том, что первый достаточно легок в использовании, а второй предоставляет
больше возможностей.

## DBusInterface — доступ к службам

QDBusInterface имеет свойства:

*	bus — шина, на которой зарегистрирован сервис — системная или сессионная.
	Может принимать значения: DBus.SessionBus, Dbus.SystemBus
*	iface — содержит название интерфейса.
	*	path — содержит путь интерфейса.
	*	service — содержит название сервиса.
	*	signalsEnabled — определяет, будет ли объект обрабатывать сигналы интерфейса.

Методы:

*	call — вызвать метод интерфейса.
	Принимает аргументы: method — название вызываемого метода, arguments — массив аргументов,
	передаваемых в вызываемый метод.
	Для функции без аргументов вторым параметром передается undefined.
*	typedCall — вызвать метод интерфейса с объектом в качестве аргумента.
	Принимает аргументы: method — название вызываемого метода, arguments — объект, передаваемый
	в вызываемый метод.
	Объекты задаются вида { ‘type’: ‘тип’, ‘value’: ‘значение’ }.
	callback — функция, выполняемая при успешном вызове.
	Ее параметр содержит значение, возвращаемое вызываемым методом.
	errorCallback — функция, выполняемая при неудавшемся вызове.

## Получение списка служб D-Bus

Создадим приложение для получения списка доступных сервисов.

Приложение должно позволять просматривать список сервисов, зарегистрированных в D-Bus
(как сессионных, так и системных), для каждого такого сервиса просматривать список возможных путей,
для каждого пути — список интерфейсов, а для каждого интерфейса показывать списки методов,
свойств и сигналов.

Для получения списка сервисов, зарегистрированных в D-Bus, используется элемент DBusInterface.
И вызывается метод ListNames описанного интерфейса.

При успешном вызове метода заполняется список сервисов.
При этом происходит фильтрация, чтобы избежать вывода сервисов с именами вида ":1.44" и т.п.

## Пример получения и передачи данных по D-Bus

С помощью dbus можно взаимодействовать с системными сервисами.
На слайде представлен пример обращения к сервису "com.nokia.profiled", отвечающему за звуковой профиль.

Методы `get_profiles` и `get_profile` позволяют получить список профилей и текущий звуковой профиль.
А метод `set_profile` позволяет профиль указать.
Тип профиля указывается в списке аргументов для `set_profile` в методе `call`.

## Пример обработки сигналов D-Bus

Чтобы обрабатывать сигналы от сервиса, у компонента DBusInterface нужно включить эту возможность:
установить signalsEnabled как true.
Затем можно обрабатывать событие изменения профиля с помощью функции, совпадающей по имени
с сигналом, например, `profile_changed`.

## Пример использования D-Bus на С++

На слайде приведён пример обращения к dbus-службе через C++.

## Для чего нужна своя служба D-Bus

Можно завести собственную службу D-Bus, чтобы реализовывать следующую фукциональность:

*	реакция на действия из уведомлений, например, открытие приложения по нажатию на уведомление;
	*	в том числе обработка Push-сообщений;
*	управление настройками приложения извне.
*	Выполнение особенных функций приложений:
	*	отображение карт и маршрутов;
	*	предоставление данных периферийным устройствам.
*	Открытие файлов или ссылок по запросу извне.

## Собственная служба D-Bus

Провайдер службы декларирует собственную службу D-Bus в Desktop-файле.
Ее имя указывается в ExportDBusInterfaces.
Имя должно совпадать с названием службы, которое регистрируется в C++ или QML-коде.

Клиент декларирует её использование в разрешениях.
Название разрешения составляется из имени службы и имени приложения, предоставляющего её.

## Запуск приложения по D-Bus

Для запуска приложения по D-Bus используется атрибут ExecDBus.
В нём следует указать команду для запуска приложения.

У команды могут быть опции запуска, которые следует обработать в C++-части приложения.
Например, можно не создавать UI при активации по D-Bus.
Имена для опций можно придумать самостоятельно.

## DBusAdaptor — регистрация службы

Объект типа DBusAdaptor используется для создания службы D-Bus на системной или сессионной шине.
Пока служба активна, её можно вызвать из другого приложения.

Тип DBusAdaptor является удобным способом предоставления доступа к объектам через D-Bus.
Значения свойств и аргументы методов автоматически конвертируются между QML/JS и D-Bus.
Управление данным процессом ограничено.
Для более сложных сценариев рекомендуется использовать C++ и модуль Qt DBus.

## Пример службы D-Bus на QML

В примере на слайде продемонстрировано предоставление доступа к объекту по сессионной шине.

Все свойства и методы DBusAdaptor будут доступны через D-Bus.
При этом обнаруживаться через интроспекцию D-Bus будут только те свойства и методы,
которые описаны в свойстве xml.

## Пример службы D-Bus на С++

В примере на слайде продемонстрировано объявление аналогичной службы на C++.

## Внедрение D-Bus сервиса на C++

Продолжение примера: объявление и использование службы.

## Защита от dbus-monitor

Команда dbus-monitor используется для мониторинга сообщений, проходящих через шину сообщений D-Bus.
Чтобы защититься от мониторинга через dbus-monitor, следует выполнить действия:

1.	Передать дескриптор на pipe по D-Bus.
	(Нельзя перехватить такое действие через dbus-monitor)
2.	Общаться через pipe.

## Контроль подключений клиентов D-Bus

Чтобы контролировать клиентов, подключающихся в приложению по D-Bus, следует
воспользоваться службой ru.omp.am.Identify.

С её помощью можно идентифицировать клиента по уникальному D-Bus имени (начинается с “:”)
с помощью вызова Identify.
В ответ будет получен путь до вызывающего приложения и keyid.
keyid хранится в подписи исполняемого файла (security.ima xattr).

## QML-плагин Notifications

QML-плагин Notifications предоставляет классы C++/QML для публикации уведомлений в среде Lipstick.

Тип Notification - это удобный тип для использования уведомлений на основе спецификации уведомлений
рабочего стола.
Этот тип позволяет клиентам создавать экземпляры уведомлений, которые можно использовать для связи
с диспетчером уведомлений Lipstick через D-Bus.
Это упрощает процесс создания, перечисления и закрытия уведомлений, поскольку необходимые сообщения
обрабатываются по типу.
Содержимое уведомлений можно указать, задав различные свойства в экземпляре типа Notification,
или обработать, указав категорию, свойства которой автоматически применяются диспетчером
уведомлений Lipstick для соответствующих уведомлений.
Свойства, установленные в экземпляре уведомления, не будут перезаписаны значениями, указанными в категории.

## Notification — уведомление

Основные свойства уведомления.

*	body : string - дополнительный подробный основной текст.
*	replacesId : int - идентификатор, который следует использовать для замены или удаления этого уведомления.
	Если уведомление опубликовано с ненулевым идентификатором, оно заменит любое существующее
	уведомление с этим идентификатором, не предупреждая пользователя о каких-либо изменениях.
	Неопубликованное уведомление имеет нулевой идентификатор.
	Идентификатор автоматически обновляется и содержит опубликованный идентификатор после публикации
	уведомления диспетчером уведомлений.
*	summary : string - краткий текст с описанием уведомления.
	Резюме должно содержать краткое однострочное описание уведомления.
*	previewBody : string  - основной текст для отображения в баннере предварительного просмотра для уведомления.
*	previewSummary : string - короткий текст для отображения в баннере предварительного просмотра для уведомления.
	Если указаны previewSummary или previewBody, Lipstick при публикации будет генерировать
	предварительный просмотр уведомления (если менеджер уведомлений не решит подавить предварительный просмотр).
*	icon : string - значок уведомления.
	Значением может быть URI, абсолютный путь к файловой системе или токен, который должен интерпретироваться
	поставщиком изображения темы.
	Он может иметь приоритет над appIcon в зависимости от реализации платформы.
*	timestamp : date - временная метка обычно связана с событием, к которому относится уведомление,
	а не с созданием самого уведомления.
	Если не указано, отметка времени уведомления станет временем публикации.

## Пример отправки уведомления

Минимальный пример использования этого типа в приложении QML представлен на слайде.
 
При нажатии кнопки новое уведомление публикуется в диспетчере уведомлений, свойства которого
указаны в определении объекта уведомления.
Любые свойства, указанные в файле определения для назначенной категории, будут автоматически
применены менеджером уведомлений во время публикации.
Менеджер выделяет идентификатор для уведомления, а экземпляр обновляется, чтобы этот идентификатор
отражался в свойстве replacesId.
Приложение может получить этот идентификатор по одноимённому свойству.

## Управление отображением уведомления

*	appName : string - имя приложения, связанное с этим уведомлением, для целей отображения.
	Имя приложения должно быть формальным именем, локализованным, если необходимо.
*	appIcon : string - иконка приложения, с которым связано это уведомление.
	Значением может быть URI, абсолютный путь к файловой системе или токен, который должен
	интерпретироваться поставщиком изображения темы.
*	category : string - категория, свойства которой должны применяться к уведомлению диспетчером уведомлений.
	Свойства, определенные в файле определения категории, будут применяться к уведомлению, если только
	эти свойства уже не установлены в уведомлении.
*	itemCount : int - количество элементов, представленных в уведомлении.
	Например, одно уведомление может представлять четыре пропущенных вызова, если установить счетчик на 4.
	По умолчанию 1.
*	expireTimeout : int - количество миллисекунд после отображения, при котором уведомление должно автоматически закрываться.
	Нулевое значение указывает, что уведомление не должно закрываться автоматически, в то время как -1 указывает,
	что диспетчер уведомлений должен принять решение об истечении времени ожидания.
	По умолчанию -1.
*	isTransient : int - свойство, предполагающее, что уведомление должно показываться только кратко.
*	maxContentLines : int - свойство, предлагающее максимальный объем контента для отображения в уведомлении.
	Строки содержимого включают в себя итоговую строку, поэтому в однострочном уведомлении не отображается основной текст.
*	urgency : enumeration - уровень срочности уведомления.
	Уровень срочности интерпретируется менеджером уведомлений при публикации.
	Он может принять решение об отображении или подавлении отображения уведомления в зависимости
	от текущей пользовательской активности или состояния устройства, где с большей вероятностью будут
	отображаться уведомления с критической срочностью.
	По умолчанию срочность Normal.

## Выполнение действий по уведомлениям

*	remoteActions : list<variant> - удаленные действия зарегистрированы для потенциального вызова этим уведомлением.
	Удаленные действия указываются в виде списка объектов, имеющих свойства 'name', 'service', 'path', 'iface'
	и 'method', и, опционально, свойства 'displayName', 'icon' и 'arguments'.

Текущая реализация Lipstick будет вызывать действие с именем «default», когда пользователь
активирует отдельное уведомление.
Если пользователь активирует группу уведомлений, будет вызвано действие с именем «app», если это действие
является общим для всех членов группы.

## Пример описания действий уведомления

На слайде приведён пример, как описать одно действие для уведомления.

## QML-плагин KeepAlive

Плагин KeepAlive содержит следующие QML-компоненты для предотвращения блокировки дисплея,
предотвращения приостановки системы и планирования пробуждений из приостановленного состояния:

*	KeepAlive - предотвращение приостановки системы;
*	DisplayBlanking - предотвращение блокировки дисплея;
*	BackgroundJob — планирование пробуждений

## KeepAlive — предотвращение приостановки системы

Свойство enabled устанавливает желаемый режим предотвращения приостановки.
Когда установлено значение true, система не приостанавливается. По умолчанию false.

## DisplayBlanking — предотвращение блокировки дисплея

QML-тип DisplayBlanking предоставляет средства для предотвращения гашения дисплея.

Пока DisplayBlanking.preventBlanking == true, это удерживает систему от автоматического отключения экрана.
Приложение должно установить DisplayBlanking.preventBlanking = false, чтобы снова разрешить гашение экрана.

Текущая видимость отображения задается DisplayBlanking.status.
Это может использоваться, например, для отключения обновлений, когда дисплей выключен. 

## Пример работы

Пример использования: видеоплеер

*	дисплей включен из-за активности пользователя;
*	воспроизведение видео начато;
*	видеоплеер устанавливает DisplayBlanking.preventBlanking = true;
*	воспроизведение видео приостановлено / остановлено;
*	видеоплеер устанавливает DisplayBlanking.preventBlanking = false.

## BackgroundJob — планирование пробуждений

Предоставляет средства для пробуждения / предотвращения приостановки.

Предоставляет абстракцию для планирования задач, которые могут вывести систему из приостановленного
состояния и предотвратить приостановку системы при обработке пробуждения.

*	bool triggeredOnEnable – запуск процесса сразу после включения.
	Это свойство выполняет те же функции, что и triggeredOnStart в стандартных объектах таймера QML:
	установка значения triggeredOnEnable в значение true вызывает срабатывание сразу после включения,
	что может быть полезно, например, для установления исходного состояния.
	По умолчанию имеет значение false.
*	enabled – если значение изменено с false на true, запускается таймер.
	При изменении с true на false остановка таймера / прекращение предотвращения приостановки.
	По умолчанию false.
*	running  - возвращает true, когда таймер сработал (и устройство не может приостановить работу).
*	frequency – частота запуска процесса.
	Устанавливает желаемую частоту пробуждения и запускает таймер.
	Обратите внимание, что пробуждения выровнены общесистемным образом, так что каждый таймер,
	запланированный на одну и ту же частоту, запускается одновременно.
	Фактически это означает, что первое пробуждение, скорее всего, произойдет раньше,
	чем предложенная запрошенная частота.

Диапазон пробуждения:

*	int minimumWait - Устанавливает желаемую минимальную задержку ожидания в секундах и запускает таймер.
*	int maximumWait  - Устанавливает желаемую максимальную задержку ожидания в секундах и запускает таймер.

Обратите внимание, что определение частоты пробуждения является взаимоисключающим с использованием диапазона пробуждения.

Сигнал triggered испускается, когда происходит активация таймера и система не может приостановить работу.

Чтобы снова разрешить приостановку, приложение должно определить обработчик onTriggered и убедиться,
что после обработки задач, связанных с пробуждением, выполняется одно из следующих действий:

*	установить свойство BackgroundJob::enabled в false, чтобы остановить таймер;
*	вызвать метод BackgroundJob::finished() - чтобы запланировать следующее пробуждение.

Методы

*	begin(); 
	Если свойство enabled имеет значение true, переключает BackgroundJob в рабочее состояние
	и испускает сигнал BackgroundJob::triggered().
*	void finished();
	Если свойство enabled имеет значение true, перепланирует таймер пробуждения и прекращает
	предотвращение приостановки.

## Пример BackgroundJob

Пример BackgroundJob, запускающей таймер через 30 секунд.
Таймер перезапускает работу BackgroundJob после окончания своей активности.

## Push-сообщения

Сервис уведомлений предназначен для оперативной доставки информации
в виде текстовых Push-сообщений на мобильные устройства.

Если Push-сообщение отправлено, а мобильное устройство в данный момент недоступно,
мобильное приложение получит Push-сообщения после подключения к сети,
обеспечивающей доступ к Push-серверу.

Для использования Push-сообщений в своих системах разработчикам необходимо расширить
функциональность мобильного приложения и сервера, отправляющего Push-сообщения.

Протокол общения устройств с сервером Push-сообщений
не подразумевает передачу конфиденциальной информации.
Поэтому не рекомендуется передавать с помощью уведомлений
конфиденциальную и чувствительную информацию в незащищённых сетях.

При разработке приложения функциональность Push-сообщений можно тестировать двумя способами:

*	подключившись к тестовому серверу;
*	при помощи плагина для эмуляции Push-сервера.

## Работа с сервером Push-сообщений

Для того, чтобы протестировать автоматизированную систему (серверное приложение),
которая отправляет push-сообщения, и приложение-клиент, которое эти сообщения обрабатывает,
необходимо работать с тестовым сервером.

Чтобы использовать тестовый сервер в разработке, необходимо выполнить следующие шаги:

1.	Получить доступ к тестовому серверу:
	1.	обратиться с запросом на dev-support@omp.ru;
	2.	получить ключи для доступа;
	3.	использовать ключи в приложении-клиенте и автоматизированной системе.
2.	Создать и установить приложение-клиент на устройство:
	1.	установить зависимости;
	2.	передать в приложение `applicationId`, полученный от поддержки ОМП;
	3.	зарегистрироваться в push-демоне с помощью `applicationId`,
	получив в ответ `registrationId` для тестового сервера.
3.	Организовать передачу Push-сообщений от автоматизированной системы через тестовый сервер.
	1.	Передать `registrationId` автоматизированной системе
	доверенным способом от приложения-клиента.
	Это позволит автоматизированной системе отправлять таргетированные push-сообщения
	к своим мобильным приложениям на конкретном устройстве.
	2.	Получить токен доступа на тестовом сервере через автоматизированную систему.
	3.	Передавать через автоматизированную систему push-сообщения,
	используя токен доступа и идентификатор приложения `registrationId`.

Процесс регистрации мобильного приложения изображён на схеме на слайде.

Запрос на регистрацию мобильного приложения должен происходить при каждом его запуске.

## Настройки приложения и сервера

Настройки серверного приложения выдаются одни на компанию,
мобильных приложений и их настроек может быть несколько.

Настройки необходимо указать в конфигурации автоматизированной системы,
которая будет проходить аутентификацию и получать токен доступа на тестовом сервере,
а затем отправлять push-сообщения через тестовый сервер.

Список настроек серверного приложения/автоматизированной системы:

`project_id`
: Уникальный идентификатор проекта.

`push_public_address`
: Адрес тестового сервера, на который будут отправляться запросы.

`api_url`
: Адрес API тестового сервера.

`client_id`
: Аккаунт учётной записи клиента в подсистеме безопасности,
в большинстве случаев совпадает с ID проекта.

`scopes`
: Настройки области видимости (для OAuth 2).

`audience`
: Настройки аудитории для токена доступа (для OAuth 2).

`token_url`
: Адрес API тестового сервера, используемого для авторизации через токен.

`key_id`
: Идентификатор приватного ключа RSA для передачи сообщений между сервером приложений
и тестовым сервером.

`private_key`
: Приватный ключ RSA для передачи сообщений между сервером приложений и тестовым сервером.

Настройки мобильных приложений:

`application_id`
: Уникальный идентификатор приложения-клиента;

`project_id`
: Уникальный идентификатор проекта.

`application_id` необходимо использовать для регистрации в push-демоне на мобильном устройстве.
Каждому `application_id` может соответствовать только одно приложение.

## Настройка push-демона

После установки push-демона необходимо его настроить,
чтобы он связывался с нужным сервером.

Для указания адреса и порта сервера, который будет использован push-демоном для соединения,
необходимо выполнить команду от суперпользователя.

В полях `address` и `port` нужно указать адрес и порт push-сервера.
В поле `address` нужно указывать URL без протокола.

После обновления конфигурации необходимо перезагрузить push-демон.

После перезапуска push-демона можно проверить текущие настройки push-демона.

Они будут содержать указанные ранее адрес, порт, а также статус валидации соединения с сервером.
True означает, что демон будет учитывать ssl-ошибки.

## PushNotifications — API для работы с Push-сообщениями

Для разработки приложения клиента нужно использовать библиотеку libpushclient.
В ней имеется пространство имён PushNotifications.
Это пространство имён предоставляет API для работы с системой push-уведомлений.

Классы

Client - клиент для системы push-уведомлений.
Push - структура push-уведомления.
PushList - синоним для QList<Aurora::PushNotifications::Push>

## Приложение-клиент

В начале работы приложения необходимо выполнить следующие действия:

1.	Установить `applicationId` с помощью метода `Aurora::PushNotifications::Client::setApplicationId()`.
2.	Вызвать метод `Aurora::PushNotifications::Client::startHandler()`.

Этот идентификатор можно вынести в конфигурацию мобильного приложения
или программно запрашивать у своей автоматизированной системы до начала процесса регистрации.

Каждому `applicationId` может соответствовать только одно приложение.

На основе `applicationId` push-демон определяет соответствующий ему `deviceID`.
После этого при вызове метода `registrate()` эта пара отправляется на сервер.
На сервере производится проверка, существует ли такая пара.
Если нет, то генерируется `registrationId`, который возвращается приложению через push-демон.
Если же пара уже была зарегистрирована, то возвращается уже существующий `registrationId`.
Поэтому `registrationId` является постоянным для связки приложения и устройства.

Если пользователь не был активен в течение длительного времени,
то будет отправлен сигнал `clientInactive`.
При этом, если приложение работает в фоновом режиме и не выполняется никаких активных процессов,
то оно должно завершить работу, чтобы экономить заряд аккумулятора батареи.
В дальнейшем, чтобы возобновить работу приложения, его будет необходимо запустить заново.

## Собственный сервер

После того, как мобильное приложение на устройстве сможет зарегистрироваться в push-демоне,
оно сможет отправить уникальный `registrationId` своей автоматизированной системе.

Для этого в автоматизированной системе необходим процесс,
который способен получать и сохранять `registrationId`,
чтобы в дальнейшем была возможна таргетированная отправка push-сообщений.

Push-сообщения отправляются через API сервера push-сообщений,
который защищён протоколом
OAUTH2 OpenID Connect согласно JSON Web Token (JWT) Profile для OAuth 2.0 Client Authentication.
При этом используется метод аутентификации
`private_key_jwt`.

Этапы отправки push-cообщений:

1.	Получение токена, позволяющего в течение времени его жизни отправлять push-сообщения.
2.	Непосредственно отправка push-сообщения.

Для получения токена необходимо на основании адреса для запроса токена Рush-сервера `token_url`
из настроек сделать неавторизованный запрос.

В параметрах запроса необходимо указать данные:

*	тип авторизации "client_credentials";
*	`audience` из файла настроек сервера;
*	`scope` из файла настроек сервера;
*	`client_assertion_type` как строку "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
*	`client_assertion` как сформированный самостоятельно токен jwt.

Из ответа следует считать атрибуты `access_token` и `expires_in`,
которые возвращают токен и время его действия.

## Отправка push-сообщений

Для отправки push-сообщения необходимо сформировать запрос на сервер,
указанный в `api_url`.
К адресу сервера необходимо добавить фрагмент `projects/<project_id>/messages`,
содержащий идентификатор проекта из настроек.

Заголовок `Accept` должен иметь значение `application/json`.

Обязательные параметры тела запроса:

`target` - `registrationId`, полученный из приложения после его регистрации на push-сервере
`type` - поддерживается значение `device`
`ttl` - время жизни push-уведомления. Можно задавать только в следующих единицах: `s` — секунды, `h` — часы, `m` — минуты.
`notification` - содержание push-уведомления

## Структура push-сообщения

Каждое push-сообщение содержит поля для заголовка, тело сообщения и объект с данными,
который представляет собой набор пар ключ-значение.
Мобильному приложению доступны только три атрибута:

*	`title`;
*	`message`;
*	`data`.

Следует обратить внимание, что `data` является сериализованным в строку JSON-объектом.
Формат JSON-объекта в `data` может быть произвольным.
Атрибут `data`, в частности, можно использовать для указания типа push-сообщения — `text`,
`command` и т.&#8201;д., например `"{"type": "command", "text": "value"}"`.

Список этих структур `Aurora::PushNotifications::PushList`
возвращается с сигналом `Aurora::PushNotifications::Client::notifications`.
Каждое push-собщение, полученное таким образом,
в дальнейшем может быть выведено как уведомление.

## Push-плагин в Аврора IDE

В Аврора SDK на эмуляторе можно тестировать работу приложения-клиента с push-сообщениями.

Для настройки плагина Push-уведомлений необходимо выполнить следующие действия:

1.	Сгенерировать сертификат **cert.pem** и ключ **key.pem**.
	Для этого необходимо выполнить команду `openssl` в терминале в системе разработчика.
	Поля в опции `-subj` можно заполнить собственными значениями вместо многоточий или опустить.
	Ограничений на данные значения нет.
2.	В Аврора IDE запустить машину сборки Build Engine — нажать кнопку запуска,
	расположенную в нижнем левом углу IDE.
3.	Создать файл настроек для службы push-уведомлений:
	**«Параметры» -> «Push-уведомления» -> вкладка «Push-сервер» -> «Создать»**.
4.	На той же вкладке **«Push-сервер»** в разделе **«Настройки»** указать ключи из шага 1 в полях
	**«Файл сертификата»** и **«Файл ключа»**.
5.	При необходимости можно добавить значение по умолчанию для полей **«Данные»**
	и **«Заголовок»** на вкладке **«Значения по умолчанию для уведомлений»**.
6.	Нажать кнопку **«Применить»**.
	Плагин должен внести устройство в список и выдать ему уникальный идентификатор.
7.	Открыть приложение-клиент push-сообщений на эмуляторе.
8.	В Аврора IDE открыть нижнюю вкладку **«Push-уведомления»**
	или нажать сочетание клавиш `Alt`+`9`.
	На вкладке должно появиться сообщение о регистрации приложения-клиента,
	содержащее его `applicationId`.
9.	Выбрать идентификатор устройства.
10.	Ввести идентификатор приложения `applicationId` в поле справа от идентификатора устройства.
11.	Ввести текст уведомления и нажать кнопку **«Отправить push-уведомление»**.

## Запуск приложения без GUI

Для полноценной работы push-демона и мобильного приложения приложение должно поддерживать работу
в фоновом режиме, т.&#8201;е. процесс должен выполняться и при закрытии графического интерфейса.
В сервисе уведомлений поддерживается работа с приложениями,
в которых этот режим реализован с помощью сервиса DBus.

Название сервиса, путь и интерфейс можно задать как константы в pro-файле.

Название интерфейса состоит из названий организации и приложения.
Такой способ именования интерфейса рекомендуется, но не является обязательным.

Эти константы экспортируются в С++-код.
Кроме того, в списке констант содержатся названия методов, которые можно вызвать
через API D-Bus.

## Создание сервиса

Для управления приложением, которое может как работать в фоновом режиме,
так и запускать графический интерфейс, создаётся класс `ApplicationService`.
Он наследуется от `QDBusAbstractAdaptor`.

В конструкторе регистрируется D-Bus-сервис.

## Аргументы командной строки

Метод `updateApplicationArgs(const QStringList &arguments)` использует этот сервис,
чтобы применить для приложения аргументы командной строки,
вызвав `handleArguments(const QStringList &arguments)` через константу `dbusMethodAppArgs`.

Метод `handleArguments(const QStringList &arguments)` отправляет сигнал о том,
что нужно открыть графический интерфейс, если в аргументах командной строки имеется `--gui`.

## Запуск приложения

`ApplicationService` создаётся и запускается в главной функции.

Сначала проверяется, не был ли сервис уже запущен.
В этом случае у него только обновляются аргументы командной строки.
Иначе создаётся и запускается новый сервис `ApplicationService`,
а также клиент `ApplicationController`,
который получает аргументы командной строки приложения.

## Пример desktop-файла

Для приложения аргументы командной строки можно задать, например, в desktop-файле,
в поле `Exec` в основном разделе `[Desktop Entry]`,
или для запуска через D-Bus в поле `ExecDBus` раздела `[X-Application]`.

В данном случае `/usr/bin/ru.auroraos.PushReceiver` — это путь к исполняемому файлу приложения,
который может быть запущен через D-Bus для обработки запроса.
`ru.auroraos.PushReceiver` — это название D-Bus интерфейса, к которому может обращаться
другое приложение и отправлять запросы.

## Приложение-отправитель запросов

Для того, чтобы приложение могло взаимодействовать с конкретной D-Bus-службой,
оно должно содержать в .desktop-файле соответствующее разрешение в формате `<название_интерфейса_1>@<название_организации>.<название_приложения>`.

Названия интерфейсов, организации и приложения должны точно соответствовать данным 
приложения, экспортирующего D-Bus службу.

В конце строки точка с запятой не ставится.
