# Анимации

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Анимации — изменения свойств

Анимация — это плавный переход объекта из одного состояния в другое.
Например, это постепенная смена цвета кнопки при нажатии или движение
прямоугольника по горизонтали при смене его x-координаты.

Анимации применяются к изменениям свойств.
Анимация определяет кривую интерполяции, когда для изменения значения свойства создаются
плавные переходы от одного значения к другому.
Анимация определяется серией целевых свойств для анимации, кривой ослабления для кривой
интерполяции и в большинстве случаев длительностью, которая определяет время изменения свойства.
Все анимации в Qt Quick контролируются одним и тем же таймером и поэтому синхронизируются.
Это улучшает производительность и визуальное качество анимации.

Основные методы и свойства анимаций:

*	loops : int — сколько раз проигрывать анимацию
*	paused : bool — на паузе ли анимация
*	running : bool — воспроизводится ли анимация
*	alwaysRunToEnd : bool — всегда завершать анимацию полностью, даже если был сигнал остановки
*	started() — сигнал начала анимации
*	stopped() — сигнал завершения анимации
*	complete() — завершить анимацию полностью
*	pause(), resume() — пауза, продолжение
*	restart() — сброс к началу
*	start(), stop() — начать, остановить

## Способы использования анимаций

Анимация может применяться несколькими способами:

*	анимация по свойствам выполняется автоматически после полной загрузки элемента;
*	поведение по свойствам выполняется автоматически при изменении значения свойства;
*	автономная анимация запускается, когда анимация явно запускается с использованием функции
	start() или свойству running устанавливается значение true.

## Анимации и переходы

Существует несколько типов анимационных элементов, каждый из которых оптимизирован
для конкретного варианта использования:

*	Transition — анимируется переход между состояниями;
*	SequentialAnimation — последовательные анимации;
*	ParallelAnimation — параллельные анимации;
*	Behavior — анимация изменения свойств;
*	PauseAnimation — пауза в анимации;
*	SmoothedAnimation — сглаживание анимации перехода;
*	SpringAnimation — пружинная анимация.

При работе над более сложными анимациями возникает необходимость изменить свойство
или запустить скрипт во время текущей анимации.
Для этого Qt Quick предлагает элементы действия, которые можно использовать везде,
где могут использоваться другие элементы анимации:

*	PropertyAction — определяет немедленные изменения свойств во время анимации;
*	ScriptAction — определяет скрипты, которые будут выполняться во время анимации.

## Анимации на основе типов данных

На слайде представлен список компонентов, которые умеют анимировать изменение
свойств объекта заданных типов.

*	AnchorAnimation — изменения якорей;
*	ParentAnimation — изменение родителя;
*	PathAnimation — перемещать элемент вдоль пути;
*	ColorAnimation — изменение цвета;
*	NumberAnimation — изменения числовых свойств;
*	RotationAnimation — повороты;
*	Vector3dAnimation — изменения значений QVector3d;
*	PropertyAnimation — изменения любых свойств.

## Анимация изменения свойства

На слайде предствален пример анимации изменения свойства:

Анимация начинатеся по нажатию на экран.

В PropertyAnimation прописаны детали анимации:
она назначается прямоугольнику и меняет его цвет за 2 секунды.

## Пример анимации Behavior

Такую же анимацию можно задать альтернативным образом с помощью Behavior.

## Управление анимациями

*	PropertyAction — немедленные изменения свойств во время анимации
*	ScriptAction — скрипты, которые будут выполняться во время анимации

## Выполнение набора анимаций

Часто анимация бывает более сложной, чем просто анимация одного свойства.
Возможно, вы захотите запустить несколько анимаций одновременно или последовательно
или даже выполнить сценарий между двумя анимациями.
Для этого можно группировать анимации.
Группировка может выполняться двумя способами: параллельным или последовательным.
Вы можете использовать элемент SequentialAnimation или ParallelAnimation, которые действуют
как контейнеры анимации для других элементов анимации.

Все прямые дочерние анимации параллельной анимации будут запускаться параллельно при запуске.
Это позволяет одновременно анимировать разные свойства.
Следующая анимация запускает две числовые анимации параллельно.
Прямоугольник перемещается в (50,50), одновременно анимируя свои свойства x и y.

Как и любой другой тип анимации, ParallelAnimation может применяться несколькими способами,
включая переходы, поведение и источники значений свойств.

Последовательная анимация сначала запускает первую дочернюю анимацию, а после её окончания – следующую.

В следующем примере выполняется две анимации чисел в последовательности.
Прямоугольник анимируется в положение x в 50, затем в y в 50.

Анимации, определенные в рамках перехода, автоматически запускаются параллельно,
поэтому SequentialAnimation может использоваться для включения анимаций в переход,
если это предпочтительное поведение.

Как и любой другой тип анимации, SequentialAnimation можно применять несколькими способами,
включая переходы, поведение и источники значений свойств.

После того, как анимация была сгруппирована в SequentialAnimation или ParallelAnimation, она не может
быть индивидуально запущена и остановлена.
Последовательность SequentialAnimation или ParallelAnimation должна быть запущена и остановлена как группа.
