module Gitlab
  module GithubImport
    class BranchFormatter < BaseFormatter
      delegate :repo, :sha, :ref, to: :raw_data

      def exists?
        branch_exists? && commit_exists?
      end

      def valid?
        sha.present? && ref.present?
      end

      private

      def branch_exists?
        project.repository.branch_exists?(ref)
      end

      def commit_exists?
        project.repository.branch_names_contains(sha).include?(ref)
      end

      def short_id
        sha.to_s[0..7]
      end
    end
  end
end
