#### Configuration changes for repository storages

This version introduces a new configuration structure for repository storages.
Update your current configuration as follows, replacing with your storages names and paths:

**For installations from source**

1. Update your `gitlab.yml`, from

  ```yaml
  repositories:
    storages: # You must have at least a 'default' storage path.
      default: /home/git/repositories
      nfs: /mnt/nfs/repositories
      cephfs: /mnt/cephfs/repositories
  ```

  to

  ```yaml
  repositories:
    storages: # You must have at least a 'default' storage path.
      default:
        path: /home/git/repositories
      nfs:
        path: /mnt/nfs/repositories
      cephfs:
        path: /mnt/cephfs/repositories
  ```

**For Omnibus installations**

1. Upate your `/etc/gitlab/gitlab.rb`, from

  ```ruby
  git_data_dirs({
    "default" => "/var/opt/gitlab/git-data",
    "nfs" => "/mnt/nfs/git-data",
    "cephfs" => "/mnt/cephfs/git-data"
  })
  ```

  to

  ```ruby
  git_data_dirs({
    "default" => { "path" => "/var/opt/gitlab/git-data" },
    "nfs" => { "path" => "/mnt/nfs/git-data" },
    "cephfs" => { "path" => "/mnt/cephfs/git-data" }
  })
  ```

#### Git configuration

Configure Git to generate packfile bitmaps (introduced in Git 2.0) on
the GitLab server during `git gc`.

```sh
cd /home/git/gitlab

sudo -u git -H git config --global repack.writeBitmaps true
```

#### Nginx configuration

Ensure you're still up-to-date with the latest NGINX configuration changes:

```sh
cd /home/git/gitlab

# For HTTPS configurations
git diff origin/8-17-stable:lib/support/nginx/gitlab-ssl origin/9-0-stable:lib/support/nginx/gitlab-ssl

# For HTTP configurations
git diff origin/8-17-stable:lib/support/nginx/gitlab origin/9-0-stable:lib/support/nginx/gitlab
```

If you are using Strict-Transport-Security in your installation to continue using it you must enable it in your Nginx
configuration as GitLab application no longer handles setting it.

If you are using Apache instead of NGINX please see the updated [Apache templates].
Also note that because Apache does not support upstreams behind Unix sockets you
will need to let gitlab-workhorse listen on a TCP port. You can do this
via [/etc/default/gitlab].

[Apache templates]: https://gitlab.com/gitlab-org/gitlab-recipes/tree/master/web-server/apache
[/etc/default/gitlab]: https://gitlab.com/gitlab-org/gitlab-ce/blob/9-0-stable/lib/support/init.d/gitlab.default.example#L38
