export const mockApiEndpoint = `${gl.TEST_HOST}/monitoring/mock`;

export const metricsGroupsAPIResponse = {
  success: true,
  data: [
    {
      group: 'Kubernetes',
      priority: 1,
      metrics: [
        {
          id: 5,
          title: 'Memory usage',
          weight: 1,
          queries: [
            {
              query_range: 'avg(container_memory_usage_bytes{%{environment_filter}}) / 2^20',
              label: 'Memory',
              unit: 'MiB',
              result: [
                {
                  metric: {},
                  values: [
                    [1495700554.925, '8.0390625'],
                    [1495700614.925, '8.0390625'],
                    [1495700674.925, '8.0390625'],
                    [1495700734.925, '8.0390625'],
                    [1495700794.925, '8.0390625'],
                    [1495700854.925, '8.0390625'],
                    [1495700914.925, '8.0390625'],
                    [1495700974.925, '8.0390625'],
                    [1495701034.925, '8.0390625'],
                    [1495701094.925, '8.0390625'],
                    [1495701154.925, '8.0390625'],
                    [1495701214.925, '8.0390625'],
                    [1495701274.925, '8.0390625'],
                    [1495701334.925, '8.0390625'],
                    [1495701394.925, '8.0390625'],
                    [1495701454.925, '8.0390625'],
                    [1495701514.925, '8.0390625'],
                    [1495701574.925, '8.0390625'],
                    [1495701634.925, '8.0390625'],
                    [1495701694.925, '8.0390625'],
                    [1495701754.925, '8.0390625'],
                    [1495701814.925, '8.0390625'],
                    [1495701874.925, '8.0390625'],
                    [1495701934.925, '8.0390625'],
                    [1495701994.925, '8.0390625'],
                    [1495702054.925, '8.0390625'],
                    [1495702114.925, '8.0390625'],
                    [1495702174.925, '8.0390625'],
                    [1495702234.925, '8.0390625'],
                    [1495702294.925, '8.0390625'],
                    [1495702354.925, '8.0390625'],
                    [1495702414.925, '8.0390625'],
                    [1495702474.925, '8.0390625'],
                    [1495702534.925, '8.0390625'],
                    [1495702594.925, '8.0390625'],
                    [1495702654.925, '8.0390625'],
                    [1495702714.925, '8.0390625'],
                    [1495702774.925, '8.0390625'],
                    [1495702834.925, '8.0390625'],
                    [1495702894.925, '8.0390625'],
                    [1495702954.925, '8.0390625'],
                    [1495703014.925, '8.0390625'],
                    [1495703074.925, '8.0390625'],
                    [1495703134.925, '8.0390625'],
                    [1495703194.925, '8.0390625'],
                    [1495703254.925, '8.03515625'],
                    [1495703314.925, '8.03515625'],
                    [1495703374.925, '8.03515625'],
                    [1495703434.925, '8.03515625'],
                    [1495703494.925, '8.03515625'],
                    [1495703554.925, '8.03515625'],
                    [1495703614.925, '8.03515625'],
                    [1495703674.925, '8.03515625'],
                    [1495703734.925, '8.03515625'],
                    [1495703794.925, '8.03515625'],
                    [1495703854.925, '8.03515625'],
                    [1495703914.925, '8.03515625'],
                    [1495703974.925, '8.03515625'],
                    [1495704034.925, '8.03515625'],
                    [1495704094.925, '8.03515625'],
                    [1495704154.925, '8.03515625'],
                    [1495704214.925, '7.9296875'],
                    [1495704274.925, '7.9296875'],
                    [1495704334.925, '7.9296875'],
                    [1495704394.925, '7.9296875'],
                    [1495704454.925, '7.9296875'],
                    [1495704514.925, '7.9296875'],
                    [1495704574.925, '7.9296875'],
                    [1495704634.925, '7.9296875'],
                    [1495704694.925, '7.9296875'],
                    [1495704754.925, '7.9296875'],
                    [1495704814.925, '7.9296875'],
                    [1495704874.925, '7.9296875'],
                    [1495704934.925, '7.9296875'],
                    [1495704994.925, '7.9296875'],
                    [1495705054.925, '7.9296875'],
                    [1495705114.925, '7.9296875'],
                    [1495705174.925, '7.9296875'],
                    [1495705234.925, '7.9296875'],
                    [1495705294.925, '7.9296875'],
                    [1495705354.925, '7.9296875'],
                    [1495705414.925, '7.9296875'],
                    [1495705474.925, '7.9296875'],
                    [1495705534.925, '7.9296875'],
                    [1495705594.925, '7.9296875'],
                    [1495705654.925, '7.9296875'],
                    [1495705714.925, '7.9296875'],
                    [1495705774.925, '7.9296875'],
                    [1495705834.925, '7.9296875'],
                    [1495705894.925, '7.9296875'],
                    [1495705954.925, '7.9296875'],
                    [1495706014.925, '7.9296875'],
                    [1495706074.925, '7.9296875'],
                    [1495706134.925, '7.9296875'],
                    [1495706194.925, '7.9296875'],
                    [1495706254.925, '7.9296875'],
                    [1495706314.925, '7.9296875'],
                    [1495706374.925, '7.9296875'],
                    [1495706434.925, '7.9296875'],
                    [1495706494.925, '7.9296875'],
                    [1495706554.925, '7.9296875'],
                    [1495706614.925, '7.9296875'],
                    [1495706674.925, '7.9296875'],
                    [1495706734.925, '7.9296875'],
                    [1495706794.925, '7.9296875'],
                    [1495706854.925, '7.9296875'],
                    [1495706914.925, '7.9296875'],
                    [1495706974.925, '7.9296875'],
                    [1495707034.925, '7.9296875'],
                    [1495707094.925, '7.9296875'],
                    [1495707154.925, '7.9296875'],
                    [1495707214.925, '7.9296875'],
                    [1495707274.925, '7.9296875'],
                    [1495707334.925, '7.9296875'],
                    [1495707394.925, '7.9296875'],
                    [1495707454.925, '7.9296875'],
                    [1495707514.925, '7.9296875'],
                    [1495707574.925, '7.9296875'],
                    [1495707634.925, '7.9296875'],
                    [1495707694.925, '7.9296875'],
                    [1495707754.925, '7.9296875'],
                    [1495707814.925, '7.9296875'],
                    [1495707874.925, '7.9296875'],
                    [1495707934.925, '7.9296875'],
                    [1495707994.925, '7.9296875'],
                    [1495708054.925, '7.9296875'],
                    [1495708114.925, '7.9296875'],
                    [1495708174.925, '7.9296875'],
                    [1495708234.925, '7.9296875'],
                    [1495708294.925, '7.9296875'],
                    [1495708354.925, '7.9296875'],
                    [1495708414.925, '7.9296875'],
                    [1495708474.925, '7.9296875'],
                    [1495708534.925, '7.9296875'],
                    [1495708594.925, '7.9296875'],
                    [1495708654.925, '7.9296875'],
                    [1495708714.925, '7.9296875'],
                    [1495708774.925, '7.9296875'],
                    [1495708834.925, '7.9296875'],
                    [1495708894.925, '7.9296875'],
                    [1495708954.925, '7.8984375'],
                    [1495709014.925, '7.8984375'],
                    [1495709074.925, '7.8984375'],
                    [1495709134.925, '7.8984375'],
                    [1495709194.925, '7.8984375'],
                    [1495709254.925, '7.89453125'],
                    [1495709314.925, '7.89453125'],
                    [1495709374.925, '7.89453125'],
                    [1495709434.925, '7.89453125'],
                    [1495709494.925, '7.89453125'],
                    [1495709554.925, '7.89453125'],
                    [1495709614.925, '7.89453125'],
                    [1495709674.925, '7.89453125'],
                    [1495709734.925, '7.89453125'],
                    [1495709794.925, '7.89453125'],
                    [1495709854.925, '7.89453125'],
                    [1495709914.925, '7.89453125'],
                    [1495709974.925, '7.89453125'],
                    [1495710034.925, '7.89453125'],
                    [1495710094.925, '7.89453125'],
                    [1495710154.925, '7.89453125'],
                    [1495710214.925, '7.89453125'],
                    [1495710274.925, '7.89453125'],
                    [1495710334.925, '7.89453125'],
                    [1495710394.925, '7.89453125'],
                    [1495710454.925, '7.89453125'],
                    [1495710514.925, '7.89453125'],
                    [1495710574.925, '7.89453125'],
                    [1495710634.925, '7.89453125'],
                    [1495710694.925, '7.89453125'],
                    [1495710754.925, '7.89453125'],
                    [1495710814.925, '7.89453125'],
                    [1495710874.925, '7.89453125'],
                    [1495710934.925, '7.89453125'],
                    [1495710994.925, '7.89453125'],
                    [1495711054.925, '7.89453125'],
                    [1495711114.925, '7.89453125'],
                    [1495711174.925, '7.8515625'],
                    [1495711234.925, '7.8515625'],
                    [1495711294.925, '7.8515625'],
                    [1495711354.925, '7.8515625'],
                    [1495711414.925, '7.8515625'],
                    [1495711474.925, '7.8515625'],
                    [1495711534.925, '7.8515625'],
                    [1495711594.925, '7.8515625'],
                    [1495711654.925, '7.8515625'],
                    [1495711714.925, '7.8515625'],
                    [1495711774.925, '7.8515625'],
                    [1495711834.925, '7.8515625'],
                    [1495711894.925, '7.8515625'],
                    [1495711954.925, '7.8515625'],
                    [1495712014.925, '7.8515625'],
                    [1495712074.925, '7.8515625'],
                    [1495712134.925, '7.8515625'],
                    [1495712194.925, '7.8515625'],
                    [1495712254.925, '7.8515625'],
                    [1495712314.925, '7.8515625'],
                    [1495712374.925, '7.8515625'],
                    [1495712434.925, '7.83203125'],
                    [1495712494.925, '7.83203125'],
                    [1495712554.925, '7.83203125'],
                    [1495712614.925, '7.83203125'],
                    [1495712674.925, '7.83203125'],
                    [1495712734.925, '7.83203125'],
                    [1495712794.925, '7.83203125'],
                    [1495712854.925, '7.83203125'],
                    [1495712914.925, '7.83203125'],
                    [1495712974.925, '7.83203125'],
                    [1495713034.925, '7.83203125'],
                    [1495713094.925, '7.83203125'],
                    [1495713154.925, '7.83203125'],
                    [1495713214.925, '7.83203125'],
                    [1495713274.925, '7.83203125'],
                    [1495713334.925, '7.83203125'],
                    [1495713394.925, '7.8125'],
                    [1495713454.925, '7.8125'],
                    [1495713514.925, '7.8125'],
                    [1495713574.925, '7.8125'],
                    [1495713634.925, '7.8125'],
                    [1495713694.925, '7.8125'],
                    [1495713754.925, '7.8125'],
                    [1495713814.925, '7.8125'],
                    [1495713874.925, '7.8125'],
                    [1495713934.925, '7.8125'],
                    [1495713994.925, '7.8125'],
                    [1495714054.925, '7.8125'],
                    [1495714114.925, '7.8125'],
                    [1495714174.925, '7.8125'],
                    [1495714234.925, '7.8125'],
                    [1495714294.925, '7.8125'],
                    [1495714354.925, '7.80859375'],
                    [1495714414.925, '7.80859375'],
                    [1495714474.925, '7.80859375'],
                    [1495714534.925, '7.80859375'],
                    [1495714594.925, '7.80859375'],
                    [1495714654.925, '7.80859375'],
                    [1495714714.925, '7.80859375'],
                    [1495714774.925, '7.80859375'],
                    [1495714834.925, '7.80859375'],
                    [1495714894.925, '7.80859375'],
                    [1495714954.925, '7.80859375'],
                    [1495715014.925, '7.80859375'],
                    [1495715074.925, '7.80859375'],
                    [1495715134.925, '7.80859375'],
                    [1495715194.925, '7.80859375'],
                    [1495715254.925, '7.80859375'],
                    [1495715314.925, '7.80859375'],
                    [1495715374.925, '7.80859375'],
                    [1495715434.925, '7.80859375'],
                    [1495715494.925, '7.80859375'],
                    [1495715554.925, '7.80859375'],
                    [1495715614.925, '7.80859375'],
                    [1495715674.925, '7.80859375'],
                    [1495715734.925, '7.80859375'],
                    [1495715794.925, '7.80859375'],
                    [1495715854.925, '7.80859375'],
                    [1495715914.925, '7.80078125'],
                    [1495715974.925, '7.80078125'],
                    [1495716034.925, '7.80078125'],
                    [1495716094.925, '7.80078125'],
                    [1495716154.925, '7.80078125'],
                    [1495716214.925, '7.796875'],
                    [1495716274.925, '7.796875'],
                    [1495716334.925, '7.796875'],
                    [1495716394.925, '7.796875'],
                    [1495716454.925, '7.796875'],
                    [1495716514.925, '7.796875'],
                    [1495716574.925, '7.796875'],
                    [1495716634.925, '7.796875'],
                    [1495716694.925, '7.796875'],
                    [1495716754.925, '7.796875'],
                    [1495716814.925, '7.796875'],
                    [1495716874.925, '7.79296875'],
                    [1495716934.925, '7.79296875'],
                    [1495716994.925, '7.79296875'],
                    [1495717054.925, '7.79296875'],
                    [1495717114.925, '7.79296875'],
                    [1495717174.925, '7.7890625'],
                    [1495717234.925, '7.7890625'],
                    [1495717294.925, '7.7890625'],
                    [1495717354.925, '7.7890625'],
                    [1495717414.925, '7.7890625'],
                    [1495717474.925, '7.7890625'],
                    [1495717534.925, '7.7890625'],
                    [1495717594.925, '7.7890625'],
                    [1495717654.925, '7.7890625'],
                    [1495717714.925, '7.7890625'],
                    [1495717774.925, '7.7890625'],
                    [1495717834.925, '7.77734375'],
                    [1495717894.925, '7.77734375'],
                    [1495717954.925, '7.77734375'],
                    [1495718014.925, '7.77734375'],
                    [1495718074.925, '7.77734375'],
                    [1495718134.925, '7.7421875'],
                    [1495718194.925, '7.7421875'],
                    [1495718254.925, '7.7421875'],
                    [1495718314.925, '7.7421875'],
                  ],
                },
              ],
            },
          ],
        },
        {
          id: 6,
          title: 'CPU usage',
          y_label: 'CPU',
          weight: 1,
          queries: [
            {
              appearance: {
                line: {
                  width: 2,
                },
              },
              query_range:
                'avg(rate(container_cpu_usage_seconds_total{%{environment_filter}}[2m])) * 100',
              label: 'Core Usage',
              unit: 'Cores',
              result: [
                {
                  metric: {},
                  values: [
                    [1495700554.925, '0.0010794445585559514'],
                    [1495700614.925, '0.003927214935433527'],
                    [1495700674.925, '0.0053045219047619975'],
                    [1495700734.925, '0.0048892095238097155'],
                    [1495700794.925, '0.005827140952381137'],
                    [1495700854.925, '0.00569846906219937'],
                    [1495700914.925, '0.004972616802849382'],
                    [1495700974.925, '0.005117509523809902'],
                    [1495701034.925, '0.00512389061919564'],
                    [1495701094.925, '0.005199100501890691'],
                    [1495701154.925, '0.005415746394885837'],
                    [1495701214.925, '0.005607682788146286'],
                    [1495701274.925, '0.005641300000000118'],
                    [1495701334.925, '0.0071166279368766495'],
                    [1495701394.925, '0.0063242138095234044'],
                    [1495701454.925, '0.005793314698235304'],
                    [1495701514.925, '0.00703934942237556'],
                    [1495701574.925, '0.006357007076123191'],
                    [1495701634.925, '0.003753167300126738'],
                    [1495701694.925, '0.005018469678430698'],
                    [1495701754.925, '0.0045217153371887'],
                    [1495701814.925, '0.006140104285714119'],
                    [1495701874.925, '0.004818684285714102'],
                    [1495701934.925, '0.005079509718955242'],
                    [1495701994.925, '0.005059981142498263'],
                    [1495702054.925, '0.005269098389538773'],
                    [1495702114.925, '0.005269954285714175'],
                    [1495702174.925, '0.014199241435795856'],
                    [1495702234.925, '0.01511936843111017'],
                    [1495702294.925, '0.0060933692920682875'],
                    [1495702354.925, '0.004945682380952493'],
                    [1495702414.925, '0.005641266666666565'],
                    [1495702474.925, '0.005223752857142996'],
                    [1495702534.925, '0.005743098505699831'],
                    [1495702594.925, '0.00538493380952391'],
                    [1495702654.925, '0.005507793883751339'],
                    [1495702714.925, '0.005666705714285466'],
                    [1495702774.925, '0.006231530000000112'],
                    [1495702834.925, '0.006570768635394899'],
                    [1495702894.925, '0.005551146666666895'],
                    [1495702954.925, '0.005602604737098058'],
                    [1495703014.925, '0.00613993580402159'],
                    [1495703074.925, '0.004770258764368832'],
                    [1495703134.925, '0.005512376671364914'],
                    [1495703194.925, '0.005254436666666674'],
                    [1495703254.925, '0.0050109839141320505'],
                    [1495703314.925, '0.0049478019256960016'],
                    [1495703374.925, '0.0037666860965123463'],
                    [1495703434.925, '0.004813526061656314'],
                    [1495703494.925, '0.005047748095238278'],
                    [1495703554.925, '0.00386494081008772'],
                    [1495703614.925, '0.004304037408111405'],
                    [1495703674.925, '0.004999466661587168'],
                    [1495703734.925, '0.004689140476190834'],
                    [1495703794.925, '0.004746126153582475'],
                    [1495703854.925, '0.004482706382572302'],
                    [1495703914.925, '0.004032808931864524'],
                    [1495703974.925, '0.005728319047618988'],
                    [1495704034.925, '0.004436139179627006'],
                    [1495704094.925, '0.004553455714285617'],
                    [1495704154.925, '0.003455244285714341'],
                    [1495704214.925, '0.004742244761904621'],
                    [1495704274.925, '0.005366978571428422'],
                    [1495704334.925, '0.004257954837665058'],
                    [1495704394.925, '0.005431603259831257'],
                    [1495704454.925, '0.0052009214498621986'],
                    [1495704514.925, '0.004317201904761618'],
                    [1495704574.925, '0.004307384285714157'],
                    [1495704634.925, '0.004789801146644822'],
                    [1495704694.925, '0.0051429795906706485'],
                    [1495704754.925, '0.005322495714285479'],
                    [1495704814.925, '0.004512809333244233'],
                    [1495704874.925, '0.004953843582568726'],
                    [1495704934.925, '0.005812690120858119'],
                    [1495704994.925, '0.004997024285714838'],
                    [1495705054.925, '0.005246216154439592'],
                    [1495705114.925, '0.0063494966618726795'],
                    [1495705174.925, '0.005306004342898225'],
                    [1495705234.925, '0.005081412857142978'],
                    [1495705294.925, '0.00511409523809522'],
                    [1495705354.925, '0.0047861001481192'],
                    [1495705414.925, '0.005107688228042962'],
                    [1495705474.925, '0.005271929582294012'],
                    [1495705534.925, '0.004453254502681249'],
                    [1495705594.925, '0.005799134293959226'],
                    [1495705654.925, '0.005340865929502478'],
                    [1495705714.925, '0.004911654761904942'],
                    [1495705774.925, '0.005888234873953261'],
                    [1495705834.925, '0.005565283333332954'],
                    [1495705894.925, '0.005522869047618869'],
                    [1495705954.925, '0.005177549737621646'],
                    [1495706014.925, '0.0053145810232096465'],
                    [1495706074.925, '0.004751095238095275'],
                    [1495706134.925, '0.006242077142856976'],
                    [1495706194.925, '0.00621034406957871'],
                    [1495706254.925, '0.006887592738978596'],
                    [1495706314.925, '0.006328128779726213'],
                    [1495706374.925, '0.007488363809523927'],
                    [1495706434.925, '0.006193758571428157'],
                    [1495706494.925, '0.0068798371839706935'],
                    [1495706554.925, '0.005757034340423128'],
                    [1495706614.925, '0.004571388497294698'],
                    [1495706674.925, '0.00620283044923395'],
                    [1495706734.925, '0.005607562380952455'],
                    [1495706794.925, '0.005506969933620308'],
                    [1495706854.925, '0.005621118095238131'],
                    [1495706914.925, '0.004876606098698849'],
                    [1495706974.925, '0.0047871205988517206'],
                    [1495707034.925, '0.00526405939458784'],
                    [1495707094.925, '0.005716323800605852'],
                    [1495707154.925, '0.005301459523809575'],
                    [1495707214.925, '0.0051613042857144905'],
                    [1495707274.925, '0.005384792857142714'],
                    [1495707334.925, '0.005259719047619222'],
                    [1495707394.925, '0.00584101142857182'],
                    [1495707454.925, '0.0060066121920326326'],
                    [1495707514.925, '0.006359978571428453'],
                    [1495707574.925, '0.006315876322151109'],
                    [1495707634.925, '0.005590012517198831'],
                    [1495707694.925, '0.005517419877137072'],
                    [1495707754.925, '0.006089813430348506'],
                    [1495707814.925, '0.00466754476190479'],
                    [1495707874.925, '0.006059954380517721'],
                    [1495707934.925, '0.005085657142856972'],
                    [1495707994.925, '0.005897665238095296'],
                    [1495708054.925, '0.0062282023199555885'],
                    [1495708114.925, '0.00526214553236979'],
                    [1495708174.925, '0.0044803300000000644'],
                    [1495708234.925, '0.005421443333333592'],
                    [1495708294.925, '0.005694326244512144'],
                    [1495708354.925, '0.005527721904761457'],
                    [1495708414.925, '0.005988819523809819'],
                    [1495708474.925, '0.005484704285714448'],
                    [1495708534.925, '0.005041123649230085'],
                    [1495708594.925, '0.005717767639612059'],
                    [1495708654.925, '0.005412954417342863'],
                    [1495708714.925, '0.005833343333333254'],
                    [1495708774.925, '0.005448135238094969'],
                    [1495708834.925, '0.005117341428571432'],
                    [1495708894.925, '0.005888345825277833'],
                    [1495708954.925, '0.005398543809524135'],
                    [1495709014.925, '0.005325611428571416'],
                    [1495709074.925, '0.005848668571428527'],
                    [1495709134.925, '0.005135003105145044'],
                    [1495709194.925, '0.0054551400000003'],
                    [1495709254.925, '0.005319472937322171'],
                    [1495709314.925, '0.00585677857142792'],
                    [1495709374.925, '0.0062146261904759215'],
                    [1495709434.925, '0.0067105060904182265'],
                    [1495709494.925, '0.005829691904762108'],
                    [1495709554.925, '0.005719280952381261'],
                    [1495709614.925, '0.005682603793416407'],
                    [1495709674.925, '0.0055272846277326934'],
                    [1495709734.925, '0.0057123680952386735'],
                    [1495709794.925, '0.00520597958075818'],
                    [1495709854.925, '0.005584358957263837'],
                    [1495709914.925, '0.005601104275197466'],
                    [1495709974.925, '0.005991657142857066'],
                    [1495710034.925, '0.00553722238095218'],
                    [1495710094.925, '0.005127883122696293'],
                    [1495710154.925, '0.005498111927534584'],
                    [1495710214.925, '0.005609934069084202'],
                    [1495710274.925, '0.00459206285714307'],
                    [1495710334.925, '0.0047910828571428084'],
                    [1495710394.925, '0.0056014671288845685'],
                    [1495710454.925, '0.005686936791078528'],
                    [1495710514.925, '0.00444480476190448'],
                    [1495710574.925, '0.005780394696738921'],
                    [1495710634.925, '0.0053107227550210365'],
                    [1495710694.925, '0.005096031495761817'],
                    [1495710754.925, '0.005451377979091524'],
                    [1495710814.925, '0.005328136666667083'],
                    [1495710874.925, '0.006020612857143043'],
                    [1495710934.925, '0.0061063585714285365'],
                    [1495710994.925, '0.006018346015752312'],
                    [1495711054.925, '0.005069130952381193'],
                    [1495711114.925, '0.005458406190476052'],
                    [1495711174.925, '0.00577219190476179'],
                    [1495711234.925, '0.005760814645658314'],
                    [1495711294.925, '0.005371875716579101'],
                    [1495711354.925, '0.0064232666666665834'],
                    [1495711414.925, '0.009369806836906667'],
                    [1495711474.925, '0.008956864761904692'],
                    [1495711534.925, '0.005266849368559271'],
                    [1495711594.925, '0.005335111364934262'],
                    [1495711654.925, '0.006461778319586945'],
                    [1495711714.925, '0.004687939890762393'],
                    [1495711774.925, '0.004438831245760684'],
                    [1495711834.925, '0.005142786666666613'],
                    [1495711894.925, '0.007257734212054963'],
                    [1495711954.925, '0.005621991904761494'],
                    [1495712014.925, '0.007868689999999862'],
                    [1495712074.925, '0.00910970215275738'],
                    [1495712134.925, '0.006151004285714278'],
                    [1495712194.925, '0.005447120924961522'],
                    [1495712254.925, '0.005150705153929503'],
                    [1495712314.925, '0.006358108714969314'],
                    [1495712374.925, '0.0057725354795696475'],
                    [1495712434.925, '0.005232139047619015'],
                    [1495712494.925, '0.004932809617949037'],
                    [1495712554.925, '0.004511607508499662'],
                    [1495712614.925, '0.00440487701522666'],
                    [1495712674.925, '0.005479113333333174'],
                    [1495712734.925, '0.004726317619047547'],
                    [1495712794.925, '0.005582041102958029'],
                    [1495712854.925, '0.006381481216082099'],
                    [1495712914.925, '0.005474260014095208'],
                    [1495712974.925, '0.00567597142857188'],
                    [1495713034.925, '0.0064741233333332985'],
                    [1495713094.925, '0.005467475714285271'],
                    [1495713154.925, '0.004868648393824457'],
                    [1495713214.925, '0.005254923286444893'],
                    [1495713274.925, '0.005599217150312865'],
                    [1495713334.925, '0.005105413720618919'],
                    [1495713394.925, '0.007246073333333279'],
                    [1495713454.925, '0.005990312380952272'],
                    [1495713514.925, '0.005594601853351101'],
                    [1495713574.925, '0.004739258673727054'],
                    [1495713634.925, '0.003932121428571783'],
                    [1495713694.925, '0.005018188268459395'],
                    [1495713754.925, '0.004538238095237985'],
                    [1495713814.925, '0.00561816643265435'],
                    [1495713874.925, '0.0063132584495033586'],
                    [1495713934.925, '0.00442385238095213'],
                    [1495713994.925, '0.004181795887658453'],
                    [1495714054.925, '0.004437759047619037'],
                    [1495714114.925, '0.006421748157178241'],
                    [1495714174.925, '0.006525143809523842'],
                    [1495714234.925, '0.004715904935144247'],
                    [1495714294.925, '0.005966040152763461'],
                    [1495714354.925, '0.005614535466921674'],
                    [1495714414.925, '0.004934375119415906'],
                    [1495714474.925, '0.0054122933333327385'],
                    [1495714534.925, '0.004926540699612279'],
                    [1495714594.925, '0.006124649517134237'],
                    [1495714654.925, '0.004629427092013995'],
                    [1495714714.925, '0.005117951257607005'],
                    [1495714774.925, '0.004868774512685422'],
                    [1495714834.925, '0.005310093333333399'],
                    [1495714894.925, '0.0054907752286127345'],
                    [1495714954.925, '0.004597678117351089'],
                    [1495715014.925, '0.0059622552380952'],
                    [1495715074.925, '0.005352457072655368'],
                    [1495715134.925, '0.005491630952381143'],
                    [1495715194.925, '0.006391770078379791'],
                    [1495715254.925, '0.005933472857142518'],
                    [1495715314.925, '0.005301314285714163'],
                    [1495715374.925, '0.0058352959724814165'],
                    [1495715434.925, '0.006154755147867044'],
                    [1495715494.925, '0.009391935637482038'],
                    [1495715554.925, '0.007846462857142592'],
                    [1495715614.925, '0.00477608215316353'],
                    [1495715674.925, '0.006132865238094998'],
                    [1495715734.925, '0.006159762457649516'],
                    [1495715794.925, '0.005957307073265968'],
                    [1495715854.925, '0.006652319091792501'],
                    [1495715914.925, '0.005493557402895287'],
                    [1495715974.925, '0.0058652434829145166'],
                    [1495716034.925, '0.005627400430468021'],
                    [1495716094.925, '0.006240656190475609'],
                    [1495716154.925, '0.006305997676168624'],
                    [1495716214.925, '0.005388057732783248'],
                    [1495716274.925, '0.0052814916048421244'],
                    [1495716334.925, '0.00699498614272497'],
                    [1495716394.925, '0.00627768693035141'],
                    [1495716454.925, '0.0042411487048161145'],
                    [1495716514.925, '0.005348647473627653'],
                    [1495716574.925, '0.0047176657142853975'],
                    [1495716634.925, '0.004437898571428686'],
                    [1495716694.925, '0.004923527366927261'],
                    [1495716754.925, '0.005131935066048421'],
                    [1495716814.925, '0.005046949523809611'],
                    [1495716874.925, '0.00547184095238092'],
                    [1495716934.925, '0.005224140016380444'],
                    [1495716994.925, '0.005297991171665292'],
                    [1495717054.925, '0.005492965995623498'],
                    [1495717114.925, '0.005754660000000403'],
                    [1495717174.925, '0.005949557138639285'],
                    [1495717234.925, '0.006091816112534666'],
                    [1495717294.925, '0.005554210080192063'],
                    [1495717354.925, '0.006411504395279871'],
                    [1495717414.925, '0.006319643996609606'],
                    [1495717474.925, '0.005539174405717675'],
                    [1495717534.925, '0.0053157078842772255'],
                    [1495717594.925, '0.005247480952381066'],
                    [1495717654.925, '0.004820141620396252'],
                    [1495717714.925, '0.005906173868322844'],
                    [1495717774.925, '0.006173117219570961'],
                    [1495717834.925, '0.005963340952380661'],
                    [1495717894.925, '0.005698976627681527'],
                    [1495717954.925, '0.004751279096346378'],
                    [1495718014.925, '0.005733142379359711'],
                    [1495718074.925, '0.004831689010348035'],
                    [1495718134.925, '0.005188370476191092'],
                    [1495718194.925, '0.004793227554547938'],
                    [1495718254.925, '0.003997442857142731'],
                    [1495718314.925, '0.004386040132951264'],
                  ],
                },
              ],
            },
          ],
        },
      ],
    },
    {
      group: 'NGINX',
      priority: 2,
      metrics: [
        {
          id: 100,
          title: 'Http Error Rate',
          weight: 100,
          queries: [
            {
              query_range:
                'sum(rate(nginx_upstream_responses_total{status_code="5xx", upstream=~"nginx-test-8691397-production-.*"}[2m])) / sum(rate(nginx_upstream_responses_total{upstream=~"nginx-test-8691397-production-.*"}[2m])) * 100',
              label: '5xx errors',
              unit: '%',
              result: [
                {
                  metric: {},
                  values: [
                    [1495700554.925, NaN],
                    [1495700614.925, NaN],
                    [1495700674.925, NaN],
                    [1495700734.925, NaN],
                    [1495700794.925, NaN],
                    [1495700854.925, NaN],
                    [1495700914.925, NaN],
                  ],
                },
              ],
            },
          ],
        },
      ],
    },
  ],
  last_update: '2017-05-25T13:18:34.949Z',
};

export const singleGroupResponse = [
  {
    group: 'System metrics (Kubernetes)',
    priority: 5,
    metrics: [
      {
        title: 'Memory Usage (Total)',
        weight: 0,
        y_label: 'Total Memory Used',
        queries: [
          {
            query_range:
              'avg(sum(container_memory_usage_bytes{container_name!="POD",pod_name=~"^production-(.*)",namespace="autodevops-deploy-33"}) by (job)) without (job)  /1024/1024/1024',
            unit: 'GB',
            label: 'Total',
            result: [
              {
                metric: {},
                values: [
                  [1558453960.079, '0.0357666015625'],
                  [1558454020.079, '0.035675048828125'],
                  [1558454080.079, '0.035152435302734375'],
                  [1558454140.079, '0.035221099853515625'],
                  [1558454200.079, '0.0352325439453125'],
                  [1558454260.079, '0.03479766845703125'],
                  [1558454320.079, '0.034793853759765625'],
                  [1558454380.079, '0.034931182861328125'],
                  [1558454440.079, '0.034816741943359375'],
                  [1558454500.079, '0.034816741943359375'],
                  [1558454560.079, '0.034816741943359375'],
                ],
              },
            ],
          },
        ],
        id: 15,
      },
    ],
  },
];

export default metricsGroupsAPIResponse;

export const deploymentData = [
  {
    id: 111,
    iid: 3,
    sha: 'f5bcd1d9dac6fa4137e2510b9ccd134ef2e84187',
    commitUrl:
      'http://test.host/frontend-fixtures/environments-project/commit/f5bcd1d9dac6fa4137e2510b9ccd134ef2e84187',
    ref: {
      name: 'master',
    },
    created_at: '2017-05-31T21:23:37.881Z',
    tag: false,
    tagUrl: 'http://test.host/frontend-fixtures/environments-project/tags/false',
    'last?': true,
  },
  {
    id: 110,
    iid: 2,
    sha: 'f5bcd1d9dac6fa4137e2510b9ccd134ef2e84187',
    commitUrl:
      'http://test.host/frontend-fixtures/environments-project/commit/f5bcd1d9dac6fa4137e2510b9ccd134ef2e84187',
    ref: {
      name: 'master',
    },
    created_at: '2017-05-30T20:08:04.629Z',
    tag: false,
    tagUrl: 'http://test.host/frontend-fixtures/environments-project/tags/false',
    'last?': false,
  },
  {
    id: 109,
    iid: 1,
    sha: '6511e58faafaa7ad2228990ec57f19d66f7db7c2',
    commitUrl:
      'http://test.host/frontend-fixtures/environments-project/commit/6511e58faafaa7ad2228990ec57f19d66f7db7c2',
    ref: {
      name: 'update2-readme',
    },
    created_at: '2017-05-30T17:42:38.409Z',
    tag: false,
    tagUrl: 'http://test.host/frontend-fixtures/environments-project/tags/false',
    'last?': false,
  },
];

export const statePaths = {
  settingsPath: '/root/hello-prometheus/services/prometheus/edit',
  clustersPath: '/root/hello-prometheus/clusters',
  documentationPath: '/help/administration/monitoring/prometheus/index.md',
};

export const queryWithoutData = {
  title: 'HTTP Error rate',
  weight: 10,
  y_label: 'Http Error Rate',
  queries: [
    {
      query_range:
        'sum(rate(nginx_upstream_responses_total{status_code="5xx", upstream=~"nginx-test-8691397-production-.*"}[2m])) / sum(rate(nginx_upstream_responses_total{upstream=~"nginx-test-8691397-production-.*"}[2m])) * 100',
      label: '5xx errors',
      unit: '%',
      result: [],
    },
  ],
};

export function convertDatesMultipleSeries(multipleSeries) {
  const convertedMultiple = multipleSeries;
  multipleSeries.forEach((column, index) => {
    let convertedResult = [];
    convertedResult = column.queries[0].result.map(resultObj => {
      const convertedMetrics = {};
      convertedMetrics.values = resultObj.values.map(val => ({
        time: new Date(val.time),
        value: val.value,
      }));
      convertedMetrics.metric = resultObj.metric;
      return convertedMetrics;
    });
    convertedMultiple[index].queries[0].result = convertedResult;
  });
  return convertedMultiple;
}

export const environmentData = [
  {
    id: 34,
    name: 'production',
    state: 'available',
    external_url: 'http://root-autodevops-deploy.my-fake-domain.com',
    environment_type: null,
    stop_action: false,
    metrics_path: '/root/hello-prometheus/environments/34/metrics',
    environment_path: '/root/hello-prometheus/environments/34',
    stop_path: '/root/hello-prometheus/environments/34/stop',
    terminal_path: '/root/hello-prometheus/environments/34/terminal',
    folder_path: '/root/hello-prometheus/environments/folders/production',
    created_at: '2018-06-29T16:53:38.301Z',
    updated_at: '2018-06-29T16:57:09.825Z',
    last_deployment: {
      id: 127,
    },
  },
  {
    id: 35,
    name: 'review/noop-branch',
    state: 'available',
    external_url: 'http://root-autodevops-deploy-review-noop-branc-die93w.my-fake-domain.com',
    environment_type: 'review',
    stop_action: true,
    metrics_path: '/root/hello-prometheus/environments/35/metrics',
    environment_path: '/root/hello-prometheus/environments/35',
    stop_path: '/root/hello-prometheus/environments/35/stop',
    terminal_path: '/root/hello-prometheus/environments/35/terminal',
    folder_path: '/root/hello-prometheus/environments/folders/review',
    created_at: '2018-07-03T18:39:41.702Z',
    updated_at: '2018-07-03T18:44:54.010Z',
    last_deployment: {
      id: 128,
    },
  },
  {
    id: 36,
    name: 'no-deployment/noop-branch',
    state: 'available',
    created_at: '2018-07-04T18:39:41.702Z',
    updated_at: '2018-07-04T18:44:54.010Z',
  },
];

export const metricsDashboardResponse = {
  dashboard: {
    dashboard: 'Environment metrics',
    priority: 1,
    panel_groups: [
      {
        group: 'System metrics (Kubernetes)',
        priority: 5,
        panels: [
          {
            title: 'Memory Usage (Total)',
            type: 'area-chart',
            y_label: 'Total Memory Used',
            weight: 4,
            metrics: [
              {
                id: 'system_metrics_kubernetes_container_memory_total',
                query_range:
                  'avg(sum(container_memory_usage_bytes{container_name!="POD",pod_name=~"^%{ci_environment_slug}-(.*)",namespace="%{kube_namespace}"}) by (job)) without (job)  /1024/1024/1024',
                label: 'Total',
                unit: 'GB',
                metric_id: 12,
                prometheus_endpoint_path: 'http://test',
              },
            ],
          },
          {
            title: 'Core Usage (Total)',
            type: 'area-chart',
            y_label: 'Total Cores',
            weight: 3,
            metrics: [
              {
                id: 'system_metrics_kubernetes_container_cores_total',
                query_range:
                  'avg(sum(rate(container_cpu_usage_seconds_total{container_name!="POD",pod_name=~"^%{ci_environment_slug}-(.*)",namespace="%{kube_namespace}"}[15m])) by (job)) without (job)',
                label: 'Total',
                unit: 'cores',
                metric_id: 13,
              },
            ],
          },
          {
            title: 'Memory Usage (Pod average)',
            type: 'area-chart',
            y_label: 'Memory Used per Pod',
            weight: 2,
            metrics: [
              {
                id: 'system_metrics_kubernetes_container_memory_average',
                query_range:
                  'avg(sum(container_memory_usage_bytes{container_name!="POD",pod_name=~"^%{ci_environment_slug}-(.*)",namespace="%{kube_namespace}"}) by (job)) without (job) / count(avg(container_memory_usage_bytes{container_name!="POD",pod_name=~"^%{ci_environment_slug}-(.*)",namespace="%{kube_namespace}"}) without (job)) /1024/1024',
                label: 'Pod average',
                unit: 'MB',
                metric_id: 14,
              },
            ],
          },
        ],
      },
    ],
  },
  status: 'success',
};

export const dashboardGitResponse = [
  {
    path: 'config/prometheus/common_metrics.yml',
    display_name: 'Common Metrics',
    default: true,
  },
  {
    path: '.gitlab/dashboards/super.yml',
    display_name: 'Custom Dashboard 1',
    default: false,
  },
];
