module Ci
  class RetryBuildService < ::BaseService
    CLONE_ACCESSORS = %i[pipeline project ref tag options commands name
                         allow_failure stage stage_idx trigger_request
                         yaml_variables when environment coverage_regex
                         description tag_list].freeze

    def execute(build)
      reprocess(build).tap do |new_build|
        build.pipeline.mark_as_processable_after_stage(build.stage_idx)

        new_build.enqueue!

        MergeRequests::AddTodoWhenBuildFailsService
          .new(project, current_user)
          .close(new_build)
      end
    end

    def reprocess(build)
      unless can?(current_user, :update_build, build)
        raise Gitlab::Access::AccessDeniedError
      end

      attributes = CLONE_ACCESSORS.map do |attribute|
        [attribute, build.send(attribute)]
      end

      attributes.push([:user, current_user])

      project.builds.create(Hash[attributes])
    end
  end
end
