require 'spec_helper'

describe Gitlab::Ci::Status::Build::Common do
  let(:user) { create(:user) }
  let(:build) { create(:ci_build) }
  let(:project) { build.project }

  subject do
    Gitlab::Ci::Status::Core
      .new(build, user)
      .extend(described_class)
  end

  describe '#has_action?' do
    it { is_expected.not_to have_action }
  end

  describe '#has_details?' do
    context 'when user has access to read build' do
      before { project.team << [user, :developer] }

      it { is_expected.to have_details }
    end

    context 'when user does not have access to read build' do
      before { project.update(public_builds: false) }

      it { is_expected.not_to have_details }
    end
  end

  describe '#details_path' do
    it 'links to the build details page' do
      expect(subject.details_path).to include "jobs/#{build.id}"
    end
  end
end
