# Project features

When in a Project -> Settings, you will find Features on the bottom of the page that you can toggle.

Below you will find a more elaborate explanation of each of these.

## Issues

Issues is a really powerful, but lightweight issue tracking system.

You can make tickets, assign them to people, file them under milestones, order them with labels and have discussion in them.

They integrate deeply into GitLab and are easily referenced from anywhere by using `#` and the issue number.

## Merge Requests

Using a merge request, you can review and discuss code before it is merged in the branch of your code.

As with issues, it can be assigned; people, issues, etc. can be referenced; milestones attached.

We see it as an integral part of working together on code and couldn't work without it.

## Wiki

This is a separate system for documentation, built right into GitLab.

It is source controlled and is very convenient if you don't want to keep you documentation in your source code, but you do want to keep it in your GitLab project.

[Read more about Wikis.](../user/project/wiki/index.md)

## Snippets

Snippets are little bits of code or text.

This is a nice place to put code or text that is used semi-regularly within the project, but does not belong in source control.

For example, a specific config file that is used by the team that is only valid for the people that work on the code.

## Git LFS

>**Note:** Project-specific LFS setting was added on 8.12 and is available only to admins.

Git Large File Storage allows you to easily manage large binary files with Git.
With this setting admins can better control which projects are allowed to use 
LFS. 
