require 'active_record/fixtures'

namespace :gitlab do
  namespace :backup do
    # Create backup of GitLab system
    desc "GITLAB | Create a backup of the GitLab system"
    task create: :environment do
      warn_user_is_not_gitlab
      configure_cron_mode

      Rake::Task["gitlab:backup:db:create"].invoke
      Rake::Task["gitlab:backup:repo:create"].invoke
      Rake::Task["gitlab:backup:uploads:create"].invoke

      backup = Backup::Manager.new
      backup.pack
      backup.cleanup
      backup.remove_old
    end

    # Restore backup of GitLab system
    desc "GITLAB | Restore a previously created backup"
    task restore: :environment do
      warn_user_is_not_gitlab
      configure_cron_mode

      backup = Backup::Manager.new
      backup.unpack

      Rake::Task["gitlab:backup:db:restore"].invoke
      Rake::Task["gitlab:backup:repo:restore"].invoke
      Rake::Task["gitlab:backup:uploads:restore"].invoke
      Rake::Task["gitlab:shell:setup"].invoke

      backup.cleanup
    end

    namespace :repo do
      task create: :environment do
        $progress.puts "Dumping repositories ...".blue
        Backup::Repository.new.dump
        $progress.puts "done".green
      end

      task restore: :environment do
        $progress.puts "Restoring repositories ...".blue
        Backup::Repository.new.restore
        $progress.puts "done".green
      end
    end

    namespace :db do
      task create: :environment do
        $progress.puts "Dumping database ... ".blue
        Backup::Database.new.dump
        $progress.puts "done".green
      end

      task restore: :environment do
        $progress.puts "Restoring database ... ".blue
        Backup::Database.new.restore
        $progress.puts "done".green
      end
    end

    namespace :uploads do
      task create: :environment do
        $progress.puts "Dumping uploads ... ".blue
        Backup::Uploads.new.dump
        $progress.puts "done".green
      end

      task restore: :environment do
        $progress.puts "Restoring uploads ... ".blue
        Backup::Uploads.new.restore
        $progress.puts "done".green
      end
    end

    def configure_cron_mode
      if ENV['CRON']
        # We need an object we can say 'puts' and 'print' to; let's use a
        # StringIO.
        require 'stringio'
        $progress = StringIO.new
      else
        $progress = $stdout
      end
    end
  end # namespace end: backup
end # namespace end: gitlab
