class Admin::KeysController < Admin::ApplicationController
  before_filter :user, only: [:show, :destroy]

  def show
    @key = user.keys.find(params[:id])

    respond_to do |format|
      format.html
      format.js { render nothing: true }
    end
  end

  def destroy
    key = user.keys.find(params[:id])

    respond_to do |format|
      if key.destroy
        format.html { redirect_to [:admin, user], notice: 'User key was successfully removed.' }
      else
        format.html { redirect_to [:admin, user], alert: 'Failed to remove user key.' }
      end
    end
  end

  protected

  def user
    @user ||= User.find_by!(username: params[:user_id])
  end

  def key_params
    params.require(:user_id, :id)
  end
end
