# Documentation styleguide

This styleguide recommends best practices to improve documentation and to keep it organized and easy to find. 

## Text

- Split up long lines, this makes it much easier to review and edit. Only
double line breaks are shown as a full line break in markdown. 80 characters
is a good line length.
- For subtitles, make sure to start with the largest and go down, meaning:
`#` for the title, `##` for subtitles and `###` for subtitles of the subtitles, etc.
- Make sure that the documentation is added in the correct directory and that there's a link to it somewhere useful.
- Add only one H1 or title in each document, by adding '#' at the begining of it (when using markdown). 
For subtitles, use '##', '###' and so on.
- Do not duplicate information.
- Be brief and clear.
- Whenever it applies, add documents in alphabetical order.

## Images

- Create a directory to store the images with the specific name of the document where the images belong. 
It could be in the same directory where the .md document that you're working on is located.
- Images should have a specific, non-generic name that will differentiate them.
- Keep all file names in lower case.