<!---
  This documentation is auto generated by a script.

  Please do not edit this file directly, check compile_docs task on lib/tasks/gitlab/graphql.rake.
--->

# GraphQL API Resources

This documentation is self-generated based on GitLab current GraphQL schema.

The API can be explored interactively using the [GraphiQL IDE](../index.md#graphiql).

## Objects

### AddAwardEmojiPayload

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `clientMutationId` | String | A unique identifier for the client performing the mutation. |
| `errors` | String! => Array | Reasons why the mutation failed. |
| `awardEmoji` | AwardEmoji | The award emoji after mutation |

### AwardEmoji

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `name` | String! | The emoji name |
| `description` | String! | The emoji description |
| `unicode` | String! | The emoji in unicode |
| `emoji` | String! | The emoji as an icon |
| `unicodeVersion` | String! | The unicode version for this emoji |
| `user` | User! | The user who awarded the emoji |

### Blob

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `name` | String! |  |
| `type` | EntryType! |  |
| `path` | String! |  |
| `flatPath` | String! |  |
| `webUrl` | String |  |
| `lfsOid` | String |  |

### Commit

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `sha` | String! |  |
| `title` | String |  |
| `description` | String |  |
| `message` | String |  |
| `authoredDate` | Time |  |
| `webUrl` | String! |  |
| `author` | User |  |
| `latestPipeline` | Pipeline | Latest pipeline for this commit |

### DetailedStatus

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `group` | String! |  |
| `icon` | String! |  |
| `favicon` | String! |  |
| `detailsPath` | String! |  |
| `hasDetails` | Boolean! |  |
| `label` | String! |  |
| `text` | String! |  |
| `tooltip` | String! |  |

### DiffPosition

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `headSha` | String! | The sha of the head at the time the comment was made |
| `baseSha` | String | The merge base of the branch the comment was made on |
| `startSha` | String! | The sha of the branch being compared against |
| `filePath` | String! | The path of the file that was changed |
| `oldPath` | String | The path of the file on the start sha. |
| `newPath` | String | The path of the file on the head sha. |
| `positionType` | DiffPositionType! |  |
| `oldLine` | Int | The line on start sha that was changed |
| `newLine` | Int | The line on head sha that was changed |
| `x` | Int | The X postion on which the comment was made |
| `y` | Int | The Y position on which the comment was made |
| `width` | Int | The total width of the image |
| `height` | Int | The total height of the image |

### Discussion

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `createdAt` | Time! |  |

### Group

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `name` | String! |  |
| `path` | String! |  |
| `fullName` | String! |  |
| `fullPath` | ID! |  |
| `description` | String |  |
| `descriptionHtml` | String | The GitLab Flavored Markdown rendering of `description` |
| `visibility` | String |  |
| `lfsEnabled` | Boolean |  |
| `requestAccessEnabled` | Boolean |  |
| `rootStorageStatistics` | RootStorageStatistics | The aggregated storage statistics. Only available if the namespace has no parent |
| `userPermissions` | GroupPermissions! | Permissions for the current user on the resource |
| `webUrl` | String! |  |
| `avatarUrl` | String |  |
| `parent` | Group |  |

### GroupPermissions

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `readGroup` | Boolean! | Whether or not a user can perform `read_group` on this resource |

### Issue

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `userPermissions` | IssuePermissions! | Permissions for the current user on the resource |
| `iid` | ID! |  |
| `title` | String! |  |
| `titleHtml` | String | The GitLab Flavored Markdown rendering of `title` |
| `description` | String |  |
| `descriptionHtml` | String | The GitLab Flavored Markdown rendering of `description` |
| `state` | IssueState! |  |
| `reference` | String! |  |
| `author` | User! |  |
| `milestone` | Milestone |  |
| `dueDate` | Time |  |
| `confidential` | Boolean! |  |
| `discussionLocked` | Boolean! |  |
| `upvotes` | Int! |  |
| `downvotes` | Int! |  |
| `userNotesCount` | Int! |  |
| `webPath` | String! |  |
| `webUrl` | String! |  |
| `relativePosition` | Int |  |
| `closedAt` | Time |  |
| `createdAt` | Time! |  |
| `updatedAt` | Time! |  |
| `taskCompletionStatus` | TaskCompletionStatus! |  |

### IssuePermissions

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `readIssue` | Boolean! | Whether or not a user can perform `read_issue` on this resource |
| `adminIssue` | Boolean! | Whether or not a user can perform `admin_issue` on this resource |
| `updateIssue` | Boolean! | Whether or not a user can perform `update_issue` on this resource |
| `createNote` | Boolean! | Whether or not a user can perform `create_note` on this resource |
| `reopenIssue` | Boolean! | Whether or not a user can perform `reopen_issue` on this resource |

### Label

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `description` | String |  |
| `descriptionHtml` | String | The GitLab Flavored Markdown rendering of `description` |
| `title` | String! |  |
| `color` | String! |  |
| `textColor` | String! |  |

### MergeRequest

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `userPermissions` | MergeRequestPermissions! | Permissions for the current user on the resource |
| `id` | ID! |  |
| `iid` | String! |  |
| `title` | String! |  |
| `titleHtml` | String | The GitLab Flavored Markdown rendering of `title` |
| `description` | String |  |
| `descriptionHtml` | String | The GitLab Flavored Markdown rendering of `description` |
| `state` | MergeRequestState! |  |
| `createdAt` | Time! |  |
| `updatedAt` | Time! |  |
| `sourceProject` | Project |  |
| `targetProject` | Project! |  |
| `project` | Project! |  |
| `projectId` | Int! |  |
| `sourceProjectId` | Int |  |
| `targetProjectId` | Int! |  |
| `sourceBranch` | String! |  |
| `targetBranch` | String! |  |
| `workInProgress` | Boolean! |  |
| `mergeWhenPipelineSucceeds` | Boolean |  |
| `diffHeadSha` | String |  |
| `mergeCommitSha` | String |  |
| `userNotesCount` | Int |  |
| `shouldRemoveSourceBranch` | Boolean |  |
| `forceRemoveSourceBranch` | Boolean |  |
| `mergeStatus` | String |  |
| `inProgressMergeCommitSha` | String |  |
| `mergeError` | String |  |
| `allowCollaboration` | Boolean |  |
| `shouldBeRebased` | Boolean! |  |
| `rebaseCommitSha` | String |  |
| `rebaseInProgress` | Boolean! |  |
| `mergeCommitMessage` | String |  |
| `defaultMergeCommitMessage` | String |  |
| `mergeOngoing` | Boolean! |  |
| `sourceBranchExists` | Boolean! |  |
| `mergeableDiscussionsState` | Boolean |  |
| `webUrl` | String |  |
| `upvotes` | Int! |  |
| `downvotes` | Int! |  |
| `subscribed` | Boolean! |  |
| `headPipeline` | Pipeline |  |
| `taskCompletionStatus` | TaskCompletionStatus! |  |

### MergeRequestPermissions

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `readMergeRequest` | Boolean! | Whether or not a user can perform `read_merge_request` on this resource |
| `adminMergeRequest` | Boolean! | Whether or not a user can perform `admin_merge_request` on this resource |
| `updateMergeRequest` | Boolean! | Whether or not a user can perform `update_merge_request` on this resource |
| `createNote` | Boolean! | Whether or not a user can perform `create_note` on this resource |
| `pushToSourceBranch` | Boolean! | Whether or not a user can perform `push_to_source_branch` on this resource |
| `removeSourceBranch` | Boolean! | Whether or not a user can perform `remove_source_branch` on this resource |
| `cherryPickOnCurrentMergeRequest` | Boolean! | Whether or not a user can perform `cherry_pick_on_current_merge_request` on this resource |
| `revertOnCurrentMergeRequest` | Boolean! | Whether or not a user can perform `revert_on_current_merge_request` on this resource |

### MergeRequestSetWipPayload

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `clientMutationId` | String | A unique identifier for the client performing the mutation. |
| `errors` | String! => Array | Reasons why the mutation failed. |
| `mergeRequest` | MergeRequest | The merge request after mutation |

### Metadata

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `version` | String! |  |
| `revision` | String! |  |

### Milestone

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `description` | String |  |
| `title` | String! |  |
| `state` | String! |  |
| `dueDate` | Time |  |
| `startDate` | Time |  |
| `createdAt` | Time! |  |
| `updatedAt` | Time! |  |

### Namespace

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `name` | String! |  |
| `path` | String! |  |
| `fullName` | String! |  |
| `fullPath` | ID! |  |
| `description` | String |  |
| `descriptionHtml` | String | The GitLab Flavored Markdown rendering of `description` |
| `visibility` | String |  |
| `lfsEnabled` | Boolean |  |
| `requestAccessEnabled` | Boolean |  |

### Note

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `userPermissions` | NotePermissions! | Permissions for the current user on the resource |
| `id` | ID! |  |
| `project` | Project | The project this note is associated to |
| `author` | User! | The user who wrote this note |
| `resolvedBy` | User | The user that resolved the discussion |
| `system` | Boolean! | Whether or not this note was created by the system or by a user |
| `body` | String! | The content note itself |
| `bodyHtml` | String | The GitLab Flavored Markdown rendering of `note` |
| `createdAt` | Time! |  |
| `updatedAt` | Time! |  |
| `discussion` | Discussion | The discussion this note is a part of |
| `resolvable` | Boolean! |  |
| `resolvedAt` | Time | The time the discussion was resolved |
| `position` | DiffPosition | The position of this note on a diff |

### NotePermissions

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `readNote` | Boolean! | Whether or not a user can perform `read_note` on this resource |
| `createNote` | Boolean! | Whether or not a user can perform `create_note` on this resource |
| `adminNote` | Boolean! | Whether or not a user can perform `admin_note` on this resource |
| `resolveNote` | Boolean! | Whether or not a user can perform `resolve_note` on this resource |
| `awardEmoji` | Boolean! | Whether or not a user can perform `award_emoji` on this resource |

### PageInfo

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `hasNextPage` | Boolean! | When paginating forwards, are there more items? |
| `hasPreviousPage` | Boolean! | When paginating backwards, are there more items? |
| `startCursor` | String | When paginating backwards, the cursor to continue. |
| `endCursor` | String | When paginating forwards, the cursor to continue. |

### Pipeline

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `userPermissions` | PipelinePermissions! | Permissions for the current user on the resource |
| `id` | ID! |  |
| `iid` | String! |  |
| `sha` | String! |  |
| `beforeSha` | String |  |
| `status` | PipelineStatusEnum! |  |
| `detailedStatus` | DetailedStatus! |  |
| `duration` | Int | Duration of the pipeline in seconds |
| `coverage` | Float | Coverage percentage |
| `createdAt` | Time! |  |
| `updatedAt` | Time! |  |
| `startedAt` | Time |  |
| `finishedAt` | Time |  |
| `committedAt` | Time |  |

### PipelinePermissions

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `updatePipeline` | Boolean! | Whether or not a user can perform `update_pipeline` on this resource |
| `adminPipeline` | Boolean! | Whether or not a user can perform `admin_pipeline` on this resource |
| `destroyPipeline` | Boolean! | Whether or not a user can perform `destroy_pipeline` on this resource |

### Project

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `userPermissions` | ProjectPermissions! | Permissions for the current user on the resource |
| `id` | ID! |  |
| `fullPath` | ID! |  |
| `path` | String! |  |
| `nameWithNamespace` | String! |  |
| `name` | String! |  |
| `description` | String |  |
| `descriptionHtml` | String | The GitLab Flavored Markdown rendering of `description` |
| `tagList` | String |  |
| `sshUrlToRepo` | String |  |
| `httpUrlToRepo` | String |  |
| `webUrl` | String |  |
| `starCount` | Int! |  |
| `forksCount` | Int! |  |
| `createdAt` | Time |  |
| `lastActivityAt` | Time |  |
| `archived` | Boolean |  |
| `visibility` | String |  |
| `containerRegistryEnabled` | Boolean |  |
| `sharedRunnersEnabled` | Boolean |  |
| `lfsEnabled` | Boolean |  |
| `mergeRequestsFfOnlyEnabled` | Boolean |  |
| `avatarUrl` | String |  |
| `issuesEnabled` | Boolean |  |
| `mergeRequestsEnabled` | Boolean |  |
| `wikiEnabled` | Boolean |  |
| `snippetsEnabled` | Boolean |  |
| `jobsEnabled` | Boolean |  |
| `publicJobs` | Boolean |  |
| `openIssuesCount` | Int |  |
| `importStatus` | String |  |
| `onlyAllowMergeIfPipelineSucceeds` | Boolean |  |
| `requestAccessEnabled` | Boolean |  |
| `onlyAllowMergeIfAllDiscussionsAreResolved` | Boolean |  |
| `printingMergeRequestLinkEnabled` | Boolean |  |
| `namespace` | Namespace |  |
| `group` | Group |  |
| `statistics` | ProjectStatistics |  |
| `repository` | Repository |  |
| `mergeRequest` | MergeRequest |  |
| `issue` | Issue |  |

### ProjectPermissions

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `changeNamespace` | Boolean! | Whether or not a user can perform `change_namespace` on this resource |
| `changeVisibilityLevel` | Boolean! | Whether or not a user can perform `change_visibility_level` on this resource |
| `renameProject` | Boolean! | Whether or not a user can perform `rename_project` on this resource |
| `removeProject` | Boolean! | Whether or not a user can perform `remove_project` on this resource |
| `archiveProject` | Boolean! | Whether or not a user can perform `archive_project` on this resource |
| `removeForkProject` | Boolean! | Whether or not a user can perform `remove_fork_project` on this resource |
| `removePages` | Boolean! | Whether or not a user can perform `remove_pages` on this resource |
| `readProject` | Boolean! | Whether or not a user can perform `read_project` on this resource |
| `createMergeRequestIn` | Boolean! | Whether or not a user can perform `create_merge_request_in` on this resource |
| `readWiki` | Boolean! | Whether or not a user can perform `read_wiki` on this resource |
| `readProjectMember` | Boolean! | Whether or not a user can perform `read_project_member` on this resource |
| `createIssue` | Boolean! | Whether or not a user can perform `create_issue` on this resource |
| `uploadFile` | Boolean! | Whether or not a user can perform `upload_file` on this resource |
| `readCycleAnalytics` | Boolean! | Whether or not a user can perform `read_cycle_analytics` on this resource |
| `downloadCode` | Boolean! | Whether or not a user can perform `download_code` on this resource |
| `downloadWikiCode` | Boolean! | Whether or not a user can perform `download_wiki_code` on this resource |
| `forkProject` | Boolean! | Whether or not a user can perform `fork_project` on this resource |
| `createProjectSnippet` | Boolean! | Whether or not a user can perform `create_project_snippet` on this resource |
| `readCommitStatus` | Boolean! | Whether or not a user can perform `read_commit_status` on this resource |
| `requestAccess` | Boolean! | Whether or not a user can perform `request_access` on this resource |
| `createPipeline` | Boolean! | Whether or not a user can perform `create_pipeline` on this resource |
| `createPipelineSchedule` | Boolean! | Whether or not a user can perform `create_pipeline_schedule` on this resource |
| `createMergeRequestFrom` | Boolean! | Whether or not a user can perform `create_merge_request_from` on this resource |
| `createWiki` | Boolean! | Whether or not a user can perform `create_wiki` on this resource |
| `pushCode` | Boolean! | Whether or not a user can perform `push_code` on this resource |
| `createDeployment` | Boolean! | Whether or not a user can perform `create_deployment` on this resource |
| `pushToDeleteProtectedBranch` | Boolean! | Whether or not a user can perform `push_to_delete_protected_branch` on this resource |
| `adminWiki` | Boolean! | Whether or not a user can perform `admin_wiki` on this resource |
| `adminProject` | Boolean! | Whether or not a user can perform `admin_project` on this resource |
| `updatePages` | Boolean! | Whether or not a user can perform `update_pages` on this resource |
| `adminRemoteMirror` | Boolean! | Whether or not a user can perform `admin_remote_mirror` on this resource |
| `createLabel` | Boolean! | Whether or not a user can perform `create_label` on this resource |
| `updateWiki` | Boolean! | Whether or not a user can perform `update_wiki` on this resource |
| `destroyWiki` | Boolean! | Whether or not a user can perform `destroy_wiki` on this resource |
| `createPages` | Boolean! | Whether or not a user can perform `create_pages` on this resource |
| `destroyPages` | Boolean! | Whether or not a user can perform `destroy_pages` on this resource |
| `readPagesContent` | Boolean! | Whether or not a user can perform `read_pages_content` on this resource |

### ProjectStatistics

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `commitCount` | Int! |  |
| `storageSize` | Int! |  |
| `repositorySize` | Int! |  |
| `lfsObjectsSize` | Int! |  |
| `buildArtifactsSize` | Int! |  |
| `packagesSize` | Int! |  |
| `wikiSize` | Int |  |

### RemoveAwardEmojiPayload

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `clientMutationId` | String | A unique identifier for the client performing the mutation. |
| `errors` | String! => Array | Reasons why the mutation failed. |
| `awardEmoji` | AwardEmoji | The award emoji after mutation |

### Repository

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `rootRef` | String |  |
| `empty` | Boolean! |  |
| `exists` | Boolean! |  |
| `tree` | Tree |  |

### RootStorageStatistics

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `storageSize` | Int! | The total storage in Bytes |
| `repositorySize` | Int! | The git repository size in Bytes |
| `lfsObjectsSize` | Int! | The LFS objects size in Bytes |
| `buildArtifactsSize` | Int! | The CI artifacts size in Bytes |
| `packagesSize` | Int! | The packages size in Bytes |
| `wikiSize` | Int! | The wiki size in Bytes |

### Submodule

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `name` | String! |  |
| `type` | EntryType! |  |
| `path` | String! |  |
| `flatPath` | String! |  |

### TaskCompletionStatus

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `count` | Int! |  |
| `completedCount` | Int! |  |

### ToggleAwardEmojiPayload

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `clientMutationId` | String | A unique identifier for the client performing the mutation. |
| `errors` | String! => Array | Reasons why the mutation failed. |
| `awardEmoji` | AwardEmoji | The award emoji after mutation |
| `toggledOn` | Boolean! | True when the emoji was awarded, false when it was removed |

### Tree

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `lastCommit` | Commit |  |

### TreeEntry

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `id` | ID! |  |
| `name` | String! |  |
| `type` | EntryType! |  |
| `path` | String! |  |
| `flatPath` | String! |  |
| `webUrl` | String |  |

### User

| Name  | Type  | Description |
| ---   |  ---- | ----------  |
| `name` | String! |  |
| `username` | String! |  |
| `avatarUrl` | String! |  |
| `webUrl` | String! |  |
