# GitLab keyboard shortcuts

You can see GitLab's keyboard shortcuts by using <kbd>shift</kbd> + <kbd>?</kbd>

## Global Shortcuts

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>n</kbd> | Main navigation |
| <kbd>s</kbd> | Focus search |
| <kbd>f</kbd> | Focus filter |
| <kbd>p</kbd> + <kbd>b</kbd> | Show/hide the Performance Bar |
| <kbd>?</kbd> | Show/hide this dialog |
| <kbd>Cmd</kbd>/<kbd>Ctrl</kbd> + <kbd>Shift</kbd> + <kbd>p</kbd> | Toggle markdown preview |
| <kbd>↑</kbd> | Edit last comment (when focused on an empty textarea) |

## Project Files Browsing

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>↑</kbd> | Move selection up |
| <kbd>↓</kbd> | Move selection down |
| <kbd>enter</kbd> | Open selection |

## Finding Project File

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>↑</kbd> | Move selection up |
| <kbd>↓</kbd> | Move selection down |
| <kbd>enter</kbd> | Open selection |
| <kbd>esc</kbd> | Go back |

## Global Dashboard

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>Shift</kbd> + <kbd>a</kbd> | Go to the activity feed |
| <kbd>Shift</kbd> + <kbd>p</kbd> | Go to projects |
| <kbd>Shift</kbd> + <kbd>i</kbd> | Go to issues |
| <kbd>Shift</kbd> + <kbd>m</kbd> | Go to merge requests |
| <kbd>Shift</kbd> + <kbd>t</kbd> | Go to todos |

## Project

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>g</kbd> + <kbd>p</kbd> | Go to the project's home page |
| <kbd>g</kbd> + <kbd>v</kbd> | Go to the project's activity feed |
| <kbd>g</kbd> + <kbd>f</kbd> | Go to files |
| <kbd>g</kbd> + <kbd>c</kbd> | Go to commits |
| <kbd>g</kbd> + <kbd>j</kbd> | Go to jobs |
| <kbd>g</kbd> + <kbd>n</kbd> | Go to network graph |
| <kbd>g</kbd> + <kbd>d</kbd> | Go to repository charts |
| <kbd>g</kbd> + <kbd>i</kbd> | Go to issues |
| <kbd>g</kbd> + <kbd>b</kbd> | Go to issue boards |
| <kbd>g</kbd> + <kbd>m</kbd> | Go to merge requests |
| <kbd>g</kbd> + <kbd>e</kbd> | Go to environments |
| <kbd>g</kbd> + <kbd>k</kbd> | Go to kubernetes |
| <kbd>g</kbd> + <kbd>s</kbd> | Go to snippets |
| <kbd>g</kbd> + <kbd>w</kbd> | Go to wiki |
| <kbd>t</kbd> | Go to finding file |
| <kbd>i</kbd> | New issue |

## Network Graph

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>←</kbd> or <kbd>h</kbd> | Scroll left |
| <kbd>→</kbd> or <kbd>l</kbd> | Scroll right |
| <kbd>↑</kbd> or <kbd>k</kbd> | Scroll up |
| <kbd>↓</kbd> or <kbd>j</kbd> | Scroll down |
| <kbd>Shift</kbd> + <kbd>↑</kbd> or <kbd>Shift</kbd> + <kbd>k</kbd> | Scroll to top |
| <kbd>Shift</kbd> + <kbd>↓</kbd> or <kbd>Shift</kbd> + <kbd>j</kbd> | Scroll to bottom |

## Issues and Merge Requests

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>a</kbd> | Change assignee |
| <kbd>m</kbd> | Change milestone |
| <kbd>r</kbd> | Reply (quoting selected text) |
| <kbd>e</kbd> | Edit issue/merge request |
| <kbd>l</kbd> | Change label |
| <kbd>]</kbd> or <kbd>j</kbd> | Move to next file |
| <kbd>[</kbd> or <kbd>k</kbd> | Move to previous file |
| <kbd>n</kbd> | Move to next unresolved discussion     |
| <kbd>p</kbd> | Move to previous unresolved discussion |

## Epics **(ULTIMATE)**

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>r</kbd> | Reply (quoting selected text) |
| <kbd>e</kbd> | Edit description |
| <kbd>l</kbd> | Change label |

## Wiki pages

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>e</kbd> | Edit wiki page|

## Web IDE

| Keyboard Shortcut | Description |
| ----------------- | ----------- |
| <kbd>Cmd</kbd>/<kbd>Ctrl</kbd> + <kbd>p</kbd> | Go to file |
| <kbd>Cmd</kbd>/<kbd>Ctrl</kbd> + <kbd>Enter</kbd> | Commit (when editing the commit message) |
