---
type: howto
---

# Two-Factor Authentication

Two-factor Authentication (2FA) provides an additional level of security to your
GitLab account. Once enabled, in addition to supplying your username and
password to login, you'll be prompted for a code generated by your one time password
authenticator. For example, a password manager on one of your devices.

By enabling 2FA, the only way someone other than you can log into your account
is to know your username and password *and* have access to your one time password secret.

## Overview

TIP: **Tip:**
When you enable 2FA, don't forget to back up your [recovery codes](#recovery-codes)!

In addition to time-based one time passwords (TOTP), GitLab supports U2F
(universal 2nd factor) devices as the second factor of authentication. Once
enabled, in addition to supplying your username and password to log in, you'll
be prompted to activate your U2F device (usually by pressing a button on it),
and it will perform secure authentication on your behalf.

It is highly recommended that you set up 2FA with both a
[one-time password authenticator](#enable-2fa-via-one-time-password-authenticator)
and a [U2F device](#enable-2fa-via-u2f-device), so you can still access your account
if you lose your U2F device.

## Enabling 2FA

There are two ways to enable two-factor authentication: via a one time password authenticator
or a U2F device.

### Enable 2FA via one time password authenticator

To enable 2FA:

1. **In GitLab:**
   1. Log in to your GitLab account.
   1. Go to your **Profile Settings**.
   1. Go to **Account**.
   1. Click **Enable Two-factor Authentication**.
1. **On your device (usually your phone):**
   1. Install a compatible application, like:
      - [Authenticator](https://mattrubin.me/authenticator/): open source app for iOS devices.
      - [andOTP](https://github.com/andOTP/andOTP): feature rich open source app for Android which supports PGP encrypted backups.
      - [FreeOTP](https://freeotp.github.io/): open source app for Android.
      - [Google Authenticator](https://support.google.com/accounts/answer/1066447?hl=en): proprietary app for iOS and Android.
      - [SailOTP](https://openrepos.net/content/seiichiro0185/sailotp): open source app for SailFish OS.
   1. In the application, add a new entry in one of two ways:
      - Scan the code presented in GitLab with your device's camera to add the
        entry automatically.
      - Enter the details provided to add the entry manually.
1. **In GitLab:**
   1. Enter the six-digit pin number from the entry on your device into the **Pin
      code** field.
   1. Click **Submit**.

If the pin you entered was correct, you'll see a message indicating that
Two-Factor Authentication has been enabled, and you'll be presented with a list
of [recovery codes](#recovery-codes). Make sure you download them and keep them
in a safe place.

### Enable 2FA via U2F device

GitLab officially only supports [YubiKey](https://www.yubico.com/products/yubikey-hardware/)
U2F devices, but users have successfully used [SoloKeys](https://solokeys.com/).

The U2F workflow is [supported by](https://caniuse.com/#search=U2F) the
following desktop browsers:

- Chrome
- Edge
- Firefox (disabled by default)
- Opera

NOTE: **Note:**
For Firefox, you can enable the FIDO U2F API in
[about:config](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).
Search for `security.webauth.u2f` and double click on it to toggle to `true`.

To set up 2FA with a U2F device:

1. Log in to your GitLab account.
1. Go to your **Profile Settings**.
1. Go to **Account**.
1. Click **Enable Two-Factor Authentication**.
1. Plug in your U2F device.
1. Click on **Set up New U2F Device**.
1. A light will start blinking on your device. Activate it by pressing its button.

You will see a message indicating that your device was successfully set up.
Click on **Register U2F Device** to complete the process.

## Recovery codes

NOTE: **Note:**
Recovery codes are not generated for U2F devices.

CAUTION: **Caution:**
Each code can be used only once to log in to your account.

Immediately after successfully enabling two-factor authentication, you'll be
prompted to download a set of set recovery codes. Should you ever lose access
to your one time password authenticator, you can use one of them to log in to
your account. We suggest copying them, printing them, or downloading them using
the **Download codes** button for storage in a safe place. If you choose to
download them, the file will be called **gitlab-recovery-codes.txt**.

If you lose the recovery codes or just want to generate new ones, you can do so
[using SSH](#generate-new-recovery-codes-using-ssh).

## Logging in with 2FA Enabled

Logging in with 2FA enabled is only slightly different than a normal login.
Enter your username and password credentials as you normally would, and you'll
be presented with a second prompt, depending on which type of 2FA you've enabled.

### Log in via a one-time password

When asked, enter the pin from your one time password authenticator's application or a
recovery code to log in.

### Log in via U2F device

To log in via a U2F device:

1. Click **Login via U2F Device**.
1. A light will start blinking on your device. Activate it by touching/pressing
   its button.

You will see a message indicating that your device responded to the authentication
request and you will be automatically logged in.

## Disabling 2FA

If you ever need to disable 2FA:

1. Log in to your GitLab account.
1. Go to your **Profile Settings**.
1. Go to **Account**.
1. Click **Disable**, under **Two-Factor Authentication**.

This will clear all your two-factor authentication registrations, including mobile
applications and U2F devices.

## Personal access tokens

When 2FA is enabled, you can no longer use your normal account password to
authenticate with Git over HTTPS on the command line or when using
[GitLab's API](../../../api/README.md). You must use a
[personal access token](../personal_access_tokens.md) instead.

## Recovery options

To disable two-factor authentication on your account (for example, if you
have lost your code generation device) you can:

- [Use a saved recovery code](#use-a-saved-recovery-code).
- [Generate new recovery codes using SSH](#generate-new-recovery-codes-using-ssh).
- [Ask a GitLab administrator to disable two-factor authentication on your account](#ask-a-gitlab-administrator-to-disable-two-factor-authentication-on-your-account).

### Use a saved recovery code

Enabling two-factor authentication for your account generated several recovery
codes. If you saved these codes, you can use one of them to sign in.

To use a recovery code, enter your username/email and password on the GitLab
sign-in page. When prompted for a two-factor code, enter the recovery code.

Once you use a recovery code, you cannot re-use it. You can still use the other
recovery codes you saved.

### Generate new recovery codes using SSH

Users often forget to save their recovery codes when enabling two-factor
authentication. If an SSH key is added to your GitLab account, you can generate
a new set of recovery codes with SSH:

1. Run:

   ```sh
   ssh git@gitlab.example.com 2fa_recovery_codes
   ```

1. You will then be prompted to confirm that you want to generate new codes.
   Continuing this process invalidates previously saved codes:

   ```sh
   Are you sure you want to generate new two-factor recovery codes?
   Any existing recovery codes you saved will be invalidated. (yes/no)

   yes

   Your two-factor authentication recovery codes are:

   119135e5a3ebce8e
   11f6v2a498810dcd
   3924c7ab2089c902
   e79a3398bfe4f224
   34bd7b74adbc8861
   f061691d5107df1a
   169bf32a18e63e7f
   b510e7422e81c947
   20dbed24c5e74663
   df9d3b9403b9c9f0

   During sign in, use one of the codes above when prompted for your
   two-factor code. Then, visit your Profile Settings and add a new device
   so you do not lose access to your account again.
   ```

1. Go to the GitLab sign-in page and enter your username/email and password.
   When prompted for a two-factor code, enter one of the recovery codes obtained
   from the command-line output.

After signing in, visit your **Profile settings > Account**  immediately to set
up two-factor authentication with a new device.

### Ask a GitLab administrator to disable two-factor authentication on your account

If you cannot use a saved recovery code or generate new recovery codes, ask a
GitLab global administrator to disable two-factor authentication for your
account. This will temporarily leave your account in a less secure state.
Sign in and re-enable two-factor authentication as soon as possible.

## Note to GitLab administrators

- You need to take special care to that 2FA keeps working after
  [restoring a GitLab backup](../../../raketasks/backup_restore.md).
- To ensure 2FA authorizes correctly with TOTP server, you may want to ensure
  your GitLab server's time is synchronized via a service like NTP. Otherwise,
  you may have cases where authorization always fails because of time differences.
- The GitLab U2F implementation does _not_ work when the GitLab instance is accessed from
  multiple hostnames, or FQDNs. Each U2F registration is linked to the _current hostname_ at
  the time of registration, and cannot be used for other hostnames/FQDNs.

  For example, if a user is trying to access a GitLab instance from `first.host.xyz` and `second.host.xyz`:

  - The user logs in via `first.host.xyz` and registers their U2F key.
  - The user logs out and attempts to log in via `first.host.xyz` - U2F authentication succeeds.
  - The user logs out and attempts to log in via `second.host.xyz` - U2F authentication fails, because
    the U2F key has only been registered on `first.host.xyz`.

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, e.g. `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
