# GitLab UX Guide

The goal of this guide is to provide standards, principles and in-depth information to design beautiful and effective GitLab features. This will be a living document, and we welcome contributions, feedback and suggestions.

## Design

---

### [Principles](principles.md)
These guiding principles set a solid foundation for our design system, and should remain relatively stable over multiple releases. They should be referenced as new design patterns are created.

---

### [Basics](basics.md)
The basic ingredients of our experience establish our personality and feel. This section includes details about typography, iconography, and color.

---

### [Animation](animation.md)
Guidance on the timing, curving and motion for GitLab.

---

### [Illustrations](illustrations.md)
Guidelines for principals and styles related to illustrations for GitLab.

---

### [Copy](copy.md)
Conventions on text and messaging within labels, buttons, and other components.

---

### [Components](components.md)
Components are the controls that make up the GitLab experience, including guidance around buttons, links, dropdowns, etc.

---

### [Surfaces](surfaces.md)
The GitLab experience is broken apart into several surfaces. Each of these surfaces is designated for a specific scope or type of content. Examples include the header, global menu, side pane, etc.

---

### [Features](features.md)
The previous building blocks are combined into complete features in the GitLab UX. Examples include our navigation, filters, search results, and empty states.

---

## Research

---

### [Users](users.md)
How we think about the variety of users of GitLab, from small to large teams, comparing opensource usage to enterprise, etc.

---

## Other

---

### [Tips for designers](tips.md)
Tips for exporting assets, and other guidance.

---

### [Resources](resources.md)
Resources for GitLab UX
