---
comments: false
---

# From 7.2 to 7.3
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/7.2-to-7.3.md) for the most up to date instructions.*

### 0. Backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

### 1. Stop server

```bash
sudo service gitlab stop
```

### 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
sudo -u git -H git checkout -- db/schema.rb # local changes will be restored automatically
```

For GitLab Community Edition:

```bash
sudo -u git -H git checkout 7-3-stable
```

OR

For GitLab Enterprise Edition:

```bash
sudo -u git -H git checkout 7-3-stable-ee
```

### 3. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v2.0.1
```

### 4. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL installations (note: the line below states '--without ... postgres')
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL installations (note: the line below states '--without ... mysql')
sudo -u git -H bundle install --without development test mysql --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

# Update init.d script
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```


### 5. Configure Redis to use sockets

    # Configure redis to use sockets
    sudo cp /etc/redis/redis.conf /etc/redis/redis.conf.orig
    # Disable Redis listening on TCP by setting 'port' to 0
    sed 's/^port .*/port 0/' /etc/redis/redis.conf.orig | sudo tee /etc/redis/redis.conf
    # Enable Redis socket for default Debian / Ubuntu path
    echo 'unixsocket /var/run/redis/redis.sock' | sudo tee -a /etc/redis/redis.conf
    # Be sure redis group can write to the socket, enable only if supported (>= redis 2.4.0).
    sudo sed -i '/# unixsocketperm/ s/^# unixsocketperm.*/unixsocketperm 0775/' /etc/redis/redis.conf
    # Activate the changes to redis.conf
    sudo service redis-server restart
    # Add git to the redis group
    sudo usermod -aG redis git

    # Configure Redis connection settings
    sudo -u git -H cp config/resque.yml.example config/resque.yml
    # Change the Redis socket path if you are not using the default Debian / Ubuntu configuration
    sudo -u git -H editor config/resque.yml

    # Configure gitlab-shell to use Redis sockets
    sudo -u git -H sed -i 's|^  # socket.*|  socket: /var/run/redis/redis.sock|' /home/git/gitlab-shell/config.yml

### 6. Update config files

#### New configuration options for gitlab.yml

There are new configuration options available for gitlab.yml. View them with the command below and apply them to your current gitlab.yml.

```
git diff origin/7-2-stable:config/gitlab.yml.example origin/7-3-stable:config/gitlab.yml.example
```

```
# Use the default Unicorn socket backlog value of 1024
sudo -u git -H sed -i 's/:backlog => 64/:backlog => 1024/' config/unicorn.rb
```

- HTTP setups: Make `/etc/nginx/sites-available/nginx` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/7-3-stable/lib/support/nginx/gitlab but with your settings.
- HTTPS setups: Make `/etc/nginx/sites-available/nginx-ssl` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/7-3-stable/lib/support/nginx/gitlab-ssl but with your setting.

### 7. Start application

    sudo service gitlab start
    sudo service nginx restart

### 8. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade is complete!

### 9. Update OmniAuth configuration

When using Google omniauth login, changes of the Google account required.
Ensure that `Contacts API` and the `Google+ API` are enabled in the [Google Developers Console](https://console.developers.google.com/).
More details can be found at the [integration documentation](../integration/google.md).

## Things went south? Revert to previous version (7.2)

### 1. Revert the code to the previous version
Follow the [upgrade guide from 7.1 to 7.2](7.1-to-7.2.md), except for the database migration
(The backup is already migrated to the previous version)

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
If you have more than one backup *.tar file(s) please add `BACKUP=timestamp_of_backup` to the command above.

[yaml]: https://gitlab.com/gitlab-org/gitlab-ce/blob/7-3-stable/config/gitlab.yml.example
