---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Strict-Transport-Security header missing or invalid

## Description

The `Strict-Transport-Security` header was found to be missing or invalid. The `Strict-Transport-Security`
header allows web site operators to force communications to occur over a TLS connection. By enabling this
header, websites can protect their users from various forms of network eavesdropping or interception attacks.
While most browsers prevent mixed-content (loading resources from HTTP when navigating from an HTTPS site),
this header also ensures that all resource requests are only ever initiated over a secure transport.

## Remediation

Only three directives are applicable for the `Strict-Transport-Security` header.

1. `max-age`: This required directive specifies how long (in seconds) after receiving the response it should communicate only over a secure transport.
1. `includeSubDomains`: This optional, valueless directive signals that the policy applies to this host as well as any subdomains found under this host's domain.
1. `preload`: While not part of the specification, setting this optional value allows major browser organizations to add this site into the browser's preloaded set of HTTPS sites. This requires further action on behalf of the website operator to submit their domain to the browser's HSTS preload list. See [hstspreload.org](https://hstspreload.org/) for more information.

Invalid directives, or the `Strict-Transport-Security` header appearing more than once (if the
values are different) is considered invalid.

Prior to adding to this security configuration to your website, it is recommended you review the hstspreload.org [Deployment Recommendations](https://hstspreload.org/#deployment-recommendations).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.7 | true | 16 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [Deployment Recommendations](https://hstspreload.org/#deployment-recommendations)
- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/HTTP_Strict_Transport_Security_Cheat_Sheet.html)
- [RFC](https://datatracker.ietf.org/doc/html/rfc6797)
