---
stage: none
group: Tutorials
info: For assistance with this tutorial, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
---

# Tutorial: Use the left sidebar to navigate GitLab **(FREE)**

> [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/9044) in GitLab 16.0.

Follow this tutorial to learn how to use the new left sidebar to navigate the UI.

Provide feedback in
[issue 409005](https://gitlab.com/gitlab-org/gitlab/-/issues/409005).

## Enable the new left sidebar

To view the new sidebar:

1. On the top bar, in the upper-right corner, select your avatar.
1. Turn on the **New navigation** toggle.

To turn off this sidebar, return to your avatar and turn off the toggle.

## Find your project

Let's get started exploring the GitLab UI and left sidebar.

1. Start by finding the project you want to work on.
   To explore all available projects, on the left sidebar, select **Explore**:

   ![Explore](img/explore_v16_0.png)

1. On the right, above the list of projects, type search criteria.
   The search finds projects with a matching description.

   ![Search projects](img/search_projects_v16_0.png)

1. When you find the project you want, select the project name.
   The left sidebar now shows project-specific options.

   ![Project-specific options](img/project_selected_v16_0.png)

Your issues, merge requests, and to-do items are listed in the shortcuts
at the top:

![shortcuts](img/shortcuts_v16_0.png)

## Customize the sidebar

You can pin menu items if you tend to use them frequently.

1. Expand the sections until you are viewing the item you want to pin.
1. Hover over and select the pin (**{thumbtack}**).

   ![pin](img/pin_v16_0.png)

The item is displayed in the **Pinned** section:

![pinned item](img/pinned_v16_0.png)

## Use a more focused view

On the left sidebar, you can also choose a more focused view into the areas you have access to.
Change the view to **Your work**:

![Your work](img/your_work_v16_0.png)

## Go to the Admin Area

The Admin Area is also available on the left sidebar:

![Admin Area](img/admin_area_v16_0.png)
