# frozen_string_literal: true

class AddIndexToVulnerabilityFindingSignaturesOnSignatureSha < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'index_vulnerability_finding_signatures_on_signature_sha'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_finding_signatures, :signature_sha, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_finding_signatures, name: INDEX_NAME
  end
end
