# frozen_string_literal: true

class AddTmpPartialIndexOnVulnerabilityReportTypes < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'tmp_idx_vulnerability_occurrences_on_id_where_report_type_7_99'
  CLAUSE = 'report_type IN (7, 99)'

  def up
    # Temporary index to be removed in 15.11 https://gitlab.com/gitlab-org/gitlab/-/issues/393052
    prepare_async_index :vulnerability_occurrences, :id, where: CLAUSE, name: INDEX_NAME
  end

  def down
    unprepare_async_index :vulnerability_occurrences, :id, name: INDEX_NAME
  end
end
