# frozen_string_literal: true

class AddPipelineFkToVulnerabilityStateTransitions < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_state_transitions_on_pipeline_id'

  def up
    add_concurrent_index :vulnerability_state_transitions, :state_changed_at_pipeline_id, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_state_transitions, INDEX_NAME
  end
end
