# frozen_string_literal: true

require "spec_helper"

require_migration!

RSpec.describe AddSyncTmpIndexForPotentiallyMisassociatedVulnerabilityOccurrences,
  feature_category: :vulnerability_management do
  let(:table) { "vulnerability_occurrences" }
  let(:index) { described_class::INDEX_NAME }

  it "creates and drops the index" do
    reversible_migration do |migration|
      migration.before -> do
        expect(ActiveRecord::Base.connection.indexes(table).map(&:name)).not_to include(index)
      end

      migration.after -> do
        expect(ActiveRecord::Base.connection.indexes(table).map(&:name)).to include(index)
      end
    end
  end
end
