# frozen_string_literal: true

class AddIdxVulnerabilityOccurrencesDedupAgain < Gitlab::Database::Migration[1.0]
  TABLE = :vulnerability_occurrences
  INDEX_NAME = 'index_vulnerability_occurrences_deduplication'
  COLUMNS = %i[project_id report_type project_fingerprint]

  disable_ddl_transaction!

  def up
    add_concurrent_index TABLE, COLUMNS, name: INDEX_NAME
  end

  def down
    # nothing to do here
  end
end
