# frozen_string_literal: true

class CreateVulnerabilityMergeRequestLinks < Gitlab::Database::Migration[2.0]
  INDEX_NAME = "unique_vuln_merge_request_link_vuln_id_and_mr_id"

  def up
    create_table :vulnerability_merge_request_links do |t|
      t.bigint :vulnerability_id, null: false
      t.integer :merge_request_id, null: false

      t.index :merge_request_id
      t.timestamps_with_timezone null: false
    end

    add_index(
      :vulnerability_merge_request_links,
      %i[vulnerability_id merge_request_id],
      unique: true,
      name: INDEX_NAME
    )
  end

  def down
    drop_table(
      :vulnerability_merge_request_links,
      if_exists: true
    )
  end
end
