---
comments: false
---

# From 4.2 to 5.0
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/4.2-to-5.0.md) for the most up to date instructions.*

## Warning

GitLab 5.0 is affected by critical security vulnerability CVE-2013-4490.

## Important changes

- We don't use `gitlab` user any more. Everything will be moved to `git` user
- Self signed SSL certificates are not supported until GitLab 5.1
- **requires ruby1.9.3**

## 0. Stop GitLab

    sudo service gitlab stop

## 1. add bash to git user

```
sudo chsh -s /bin/bash git
```

## 2. git clone gitlab-shell

```
cd /home/git/
sudo -u git -H git clone https://github.com/gitlabhq/gitlab-shell.git /home/git/gitlab-shell
```

## 3. setup gitlab-shell

```bash
# chmod all repos and files under git
sudo chown git:git -R /home/git/repositories/

# login as git
sudo su git
cd /home/git/gitlab-shell
git checkout v1.1.0

# copy config
cp config.yml.example config.yml

# change URL to GitLab instance
# ! make sure the URL ends with '/' like 'https://gitlab.example/'
vim config.yml

# rewrite hooks
./support/rewrite-hooks.sh

# check ruby version for git user ( 1.9 required!! )
# GitLab shell requires system ruby 1.9
ruby -v

# exit from git user
exit
```

## 4. Copy GitLab instance to git user

```bash
sudo cp -R /home/gitlab/gitlab /home/git/gitlab
sudo chown git:git -R /home/git/gitlab
sudo rm -rf /home/gitlab/gitlab-satellites

# if exists
sudo rm /tmp/gitlab.socket
```

## 5. Update GitLab to recent version

```bash
cd /home/git/gitlab

# backup current config
sudo -u git -H cp config/gitlab.yml config/gitlab.yml.old

sudo -u git -H git fetch
sudo -u git -H git checkout 5-0-stable

# replace config with recent one
sudo -u git -H cp config/gitlab.yml.example config/gitlab.yml

# edit it
sudo -u git -H vim config/gitlab.yml

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u git -H vim Gemfile

# Run a bundle install without deployment to generate the new Gemfile
sudo -u git -H bundle install --without development test postgres --no-deployment

# Install libs (with deployment this time)
sudo -u git -H bundle install --without development test postgres --deployment

sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake gitlab:shell:setup RAILS_ENV=production
sudo -u git -H bundle exec rake gitlab:shell:build_missing_projects RAILS_ENV=production

sudo -u git -H mkdir -p /home/git/gitlab-satellites
sudo -u git -H bundle exec rake gitlab:satellites:create RAILS_ENV=production

# migrate wiki to git
sudo -u git -H bundle exec rake gitlab:wiki:migrate RAILS_ENV=production


# check permissions for /home/git/.ssh/
sudo -u git -H chmod 700 /home/git/.ssh
sudo -u git -H chmod 600 /home/git/.ssh/authorized_keys

# check permissions for /home/git/gitlab/
sudo chown -R git /home/git/gitlab/log/
sudo chown -R git /home/git/gitlab/tmp/
sudo chmod -R u+rwX  /home/git/gitlab/log/
sudo chmod -R u+rwX  /home/git/gitlab/tmp/
sudo -u git -H mkdir -p /home/git/gitlab/tmp/pids/
sudo chmod -R u+rwX  /home/git/gitlab/tmp/pids

```

## 6. Update init.d script and Nginx config

```bash
# init.d
sudo rm /etc/init.d/gitlab
sudo curl --location --output /etc/init.d/gitlab https://raw.github.com/gitlabhq/gitlab-recipes/5-0-stable/init.d/gitlab
sudo chmod +x /etc/init.d/gitlab

# unicorn
sudo -u git -H cp /home/git/gitlab/config/unicorn.rb /home/git/gitlab/config/unicorn.rb.old
sudo -u git -H cp /home/git/gitlab/config/unicorn.rb.example /home/git/gitlab/config/unicorn.rb

# Nginx
# Replace path from '/home/gitlab/' to '/home/git/'
sudo vim /etc/nginx/sites-enabled/gitlab
sudo service nginx restart

```

## 7. Start GitLab instance

```
sudo service gitlab start

# check if unicorn and sidekiq started
# If not try to logout, also check replaced path from '/home/gitlab/' to '/home/git/'
# in Nginx, unicorn, init.d etc
ps aux | grep unicorn
ps aux | grep sidekiq

```

## 8. Check installation


```bash
# In 5-10 seconds lets check gitlab-shell
sudo -u git -H /home/git/gitlab-shell/bin/check

# Example of success output
# Check GitLab API access: OK
# Check directories and files:
#         /home/git/repositories: OK
#         /home/git/.ssh/authorized_keys: OK


# Now check GitLab instance
sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

```

## 9. Cleanup

**If everything works as expected you can cleanup some old things**
Recommend you wait a bit and do a backup before completing the following.

```bash
# remove GitLab user from system
sudo userdel -r gitlab

cd /home/git

# cleanup .profile
## remove text from .profile added during gitolite installation:
##   PATH=\$PATH:/home/git/bin
##   export PATH
## to see what a clean .profile for new users on your system would look like see /etc/skel/.profile
sudo -u git -H vim .profile

# remove gitolite
sudo rm -R bin
sudo rm -Rf gitolite
sudo rm -R .gitolite
sudo rm .gitolite.rc
sudo rm -f gitlab.pub
sudo rm projects.list

# reset tmp folders
sudo service gitlab stop
cd /home/git/gitlab
sudo rm -R tmp
sudo -u git -H mkdir tmp
sudo chmod -R u+rwX  tmp/

# create directory for pids, make sure GitLab can write to it
sudo -u git -H mkdir tmp/pids/
sudo chmod -R u+rwX  tmp/pids/

# if you are already running a newer version of GitLab check that installation guide for other tmp folders you need to create

# reboot system
sudo reboot

# login, check that GitLab is running fine
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production
```
