class LegacyArtifactUploader < GitlabUploader
  extend Workhorse::UploadPath

  storage_options Gitlab.config.artifacts

  def store_dir
    dynamic_segment
  end

  private

  def dynamic_segment
    File.join(model.created_at.utc.strftime('%Y_%m'), model.project_id.to_s, model.id.to_s)
  end
end
