module Gitlab
  module DependencyLinker
    class RequirementsTxtLinker < BaseLinker
      self.file_type = :requirements_txt

      private

      def link_dependencies
        link_regex(/^(?<name>(?![a-z+]+:)[^#.-][^ ><=;\[]+)/) do |name|
          "https://pypi.python.org/pypi/#{name}"
        end

        link_regex(%r{^(?<name>https?://[^ ]+)}, &:itself)
      end
    end
  end
end
