# From 7.14 to 8.0

### 0. Double-check your Git version

**This notice applies only to /usr/local/bin/git**

If you compiled Git from source on your GitLab server then please double-check
that you are using a version that protects against CVE-2014-9390. For six
months after this vulnerability became known the GitLab installation guide
still contained instructions that would install the outdated, 'vulnerable' Git
version 2.1.2.

Run the following command to get your current Git version:

```sh
/usr/local/bin/git --version
```

If you see 'No such file or directory' then you did not install Git according
to the outdated instructions from the GitLab installation guide and you can go
to the next step 'Stop server' below.

If you see a version string then it should be v1.8.5.6, v1.9.5, v2.0.5, v2.1.4,
v2.2.1 or newer. You can use the [instructions in the GitLab source
installation
guide](https://gitlab.com/gitlab-org/gitlab-ce/blob/master/doc/install/installation.md#1-packages-dependencies)
to install a newer version of Git.

### 1. Stop server

    sudo service gitlab stop

### 2. Backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

### 3. Get latest code

```bash
sudo -u git -H git fetch --all
sudo -u git -H git checkout -- db/schema.rb # local changes will be restored automatically
```

For GitLab Community Edition:

```bash
sudo -u git -H git checkout 8-0-stable
```

OR

For GitLab Enterprise Edition:

```bash
sudo -u git -H git checkout 8-0-stable-ee
```

### 4. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v2.6.5
```

### 5. Install gitlab-git-http-server

First we download Go 1.5 and install it into `/usr/local/go`:

```bash
curl --remote-name --progress https://storage.googleapis.com/golang/go1.5.linux-amd64.tar.gz
echo '5817fa4b2252afdb02e11e8b9dc1d9173ef3bd5a  go1.5.linux-amd64.tar.gz' | shasum -c - && \
  sudo tar -C /usr/local -xzf go1.5.linux-amd64.tar.gz
sudo ln -sf /usr/local/go/bin/{go,godoc,gofmt} /usr/local/bin/
rm go1.5.linux-amd64.tar.gz
```

Now we download `gitlab-git-http-server` and install it in `/home/git/gitlab-git-http-server`:

```bash
cd /home/git
sudo -u git -H git clone https://gitlab.com/gitlab-org/gitlab-git-http-server.git
cd gitlab-git-http-server
sudo -u git -H git checkout 0.2.14
sudo -u git -H make
```

Make sure your unicorn.rb file contains a 'listen' line for
'127.0.0.1:8080' and that this line is not commented out.

```
cd /home/git/gitlab
grep ^listen config/unicorn.rb

# If there is no 'listen' line for 127.0.0.1:8080, add it:
sudo -u git tee -a config/unicorn.rb <<EOF
listen "127.0.0.1:8080", :tcp_nopush => true
EOF
```

If your Git repositories are in a directory other than `/home/git/repositories`,
you need to tell `gitlab-git-http-server` about it via `/etc/default/gitlab`.
See `lib/support/init.d/gitlab.default.example` for the options.

### 6. Copy secrets

The `secrets.yml` file is used to store keys to encrypt sessions and encrypt secure variables.
When you run migrations make sure to store it someplace safe.
Don't store it in the same place as your database backups,
otherwise your secrets are exposed if one of your backups is compromised.

```
cd /home/git/gitlab
sudo -u git -H cp config/secrets.yml.example config/secrets.yml
sudo -u git -H chmod 0600 config/secrets.yml
```

### 7. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL installations (note: the line below states '--without postgres')
sudo -u git -H bundle install --without postgres development test --deployment

# PostgreSQL installations (note: the line below states '--without mysql')
sudo -u git -H bundle install --without mysql development test --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

# Update init.d script
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

### 8. Update config files

#### New configuration options for `gitlab.yml`

There are new configuration options available for [`gitlab.yml`][yaml]. View them with the command below and apply them manually to your current `gitlab.yml`:

```sh
git diff origin/7-14-stable:config/gitlab.yml.example origin/8-0-stable:config/gitlab.yml.example
```

The new options include configuration of GitLab CI that are now being part of GitLab CE and EE.

#### New Nginx configuration

Because of the new `gitlab-git-http-server` you need to update your Nginx
configuration.  If you skip this step 'git clone' and 'git push' over HTTP(S)
will stop working.

View changes between the previous recommended Nginx configuration and the
current one:

```sh
# For HTTPS configurations
git diff origin/7-14-stable:lib/support/nginx/gitlab-ssl origin/8-0-stable:lib/support/nginx/gitlab-ssl

# For HTTP configurations
git diff origin/7-14-stable:lib/support/nginx/gitlab origin/8-0-stable:lib/support/nginx/gitlab
```

If you are using Apache instead of NGINX please see the updated [Apache templates](https://gitlab.com/gitlab-org/gitlab-recipes/tree/master/web-server/apache).
Also note that because Apache does not support upstreams behind Unix sockets you will need to let gitlab-git-http-server listen on a TCP port. You can do this via [/etc/default/gitlab](https://gitlab.com/gitlab-org/gitlab-ce/blob/8-0-stable/lib/support/init.d/gitlab.default.example#L34).

### 9. Migrate GitLab CI to GitLab CE/EE

Now, GitLab CE and EE has CI integrated. However, migrations don't happen automatically and you need to do it manually.
Please follow the following guide [to migrate](../migrate_ci_to_ce/README.md) your GitLab CI instance to GitLab CE/EE.

### 10. Use Redis v2.4.0+

Previous versions of GitLab allowed Redis versions >= 2.0 to be used, but
Sidekiq jobs could fail due to lack of support for the SREM command. GitLab
8.0 now checks that Redis >= 2.4.0 is used. You can check your Redis version
with the following command:

    redis-cli info | grep redis_version

### 11. Start application

    sudo service gitlab start
    sudo service nginx restart

### 12. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations, the upgrade is complete!

## Things went south? Revert to previous version (7.14)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 7.13 to 7.14](7.13-to-7.14.md), except for the database migration
(The backup is already migrated to the previous version)

### 2. Restore from the backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```

If you have more than one backup `*.tar` file(s) please add `BACKUP=timestamp_of_backup` to the command above.

## Troubleshooting

### "You appear to have cloned an empty repository."

If you see this message when attempting to clone a repository hosted by GitLab,
this is likely due to an outdated Nginx or Apache configuration, or a missing or
misconfigured `gitlab-git-http-server` instance. Double-check that you correctly
completed [Step 5](#5-install-gitlab-git-http-server) to install the daemon and
[Step 8](#new-nginx-configuration) to reconfigure Nginx.

[yaml]: https://gitlab.com/gitlab-org/gitlab-ce/blob/8-0-stable/config/gitlab.yml.example
