# Gitignores API

## List gitignore templates

Get all gitignore templates.

```
GET /templates/gitignores
```

```bash
curl https://gitlab.example.com/api/v4/templates/gitignores
```

Example response:

```json
[
  {
    "name": "AppEngine"
  },
  {
    "name": "Laravel"
  },
  {
    "name": "Elisp"
  },
  {
    "name": "SketchUp"
  },
  {
    "name": "Ada"
  },
  {
    "name": "Ruby"
  },
  {
    "name": "Kohana"
  },
  {
    "name": "Nanoc"
  },
  {
    "name": "Erlang"
  },
  {
    "name": "OCaml"
  },
  {
    "name": "Lithium"
  },
  {
    "name": "Fortran"
  },
  {
    "name": "Scala"
  },
  {
    "name": "Node"
  },
  {
    "name": "Fancy"
  },
  {
    "name": "Perl"
  },
  {
    "name": "Zephir"
  },
  {
    "name": "WordPress"
  },
  {
    "name": "Symfony"
  },
  {
    "name": "FuelPHP"
  },
  {
    "name": "DM"
  },
  {
    "name": "Sdcc"
  },
  {
    "name": "Rust"
  },
  {
    "name": "C"
  },
  {
    "name": "Umbraco"
  },
  {
    "name": "Actionscript"
  },
  {
    "name": "Android"
  },
  {
    "name": "Grails"
  },
  {
    "name": "Composer"
  },
  {
    "name": "ExpressionEngine"
  },
  {
    "name": "Gcov"
  },
  {
    "name": "Qt"
  },
  {
    "name": "Phalcon"
  },
  {
    "name": "ArchLinuxPackages"
  },
  {
    "name": "TeX"
  },
  {
    "name": "SCons"
  },
  {
    "name": "Lilypond"
  },
  {
    "name": "CommonLisp"
  },
  {
    "name": "Rails"
  },
  {
    "name": "Mercury"
  },
  {
    "name": "Magento"
  },
  {
    "name": "ChefCookbook"
  },
  {
    "name": "GitBook"
  },
  {
    "name": "C++"
  },
  {
    "name": "Eagle"
  },
  {
    "name": "Go"
  },
  {
    "name": "OpenCart"
  },
  {
    "name": "Scheme"
  },
  {
    "name": "Typo3"
  },
  {
    "name": "SeamGen"
  },
  {
    "name": "Swift"
  },
  {
    "name": "Elm"
  },
  {
    "name": "Unity"
  },
  {
    "name": "Agda"
  },
  {
    "name": "CUDA"
  },
  {
    "name": "VVVV"
  },
  {
    "name": "Finale"
  },
  {
    "name": "LemonStand"
  },
  {
    "name": "Textpattern"
  },
  {
    "name": "Julia"
  },
  {
    "name": "Packer"
  },
  {
    "name": "Scrivener"
  },
  {
    "name": "Dart"
  },
  {
    "name": "Plone"
  },
  {
    "name": "Jekyll"
  },
  {
    "name": "Xojo"
  },
  {
    "name": "LabVIEW"
  },
  {
    "name": "Autotools"
  },
  {
    "name": "KiCad"
  },
  {
    "name": "Prestashop"
  },
  {
    "name": "ROS"
  },
  {
    "name": "Smalltalk"
  },
  {
    "name": "GWT"
  },
  {
    "name": "OracleForms"
  },
  {
    "name": "SugarCRM"
  },
  {
    "name": "Nim"
  },
  {
    "name": "SymphonyCMS"
  },
  {
    "name": "Maven"
  },
  {
    "name": "CFWheels"
  },
  {
    "name": "Python"
  },
  {
    "name": "ZendFramework"
  },
  {
    "name": "CakePHP"
  },
  {
    "name": "Concrete5"
  },
  {
    "name": "PlayFramework"
  },
  {
    "name": "Terraform"
  },
  {
    "name": "Elixir"
  },
  {
    "name": "CMake"
  },
  {
    "name": "Joomla"
  },
  {
    "name": "Coq"
  },
  {
    "name": "Delphi"
  },
  {
    "name": "Haskell"
  },
  {
    "name": "Yii"
  },
  {
    "name": "Java"
  },
  {
    "name": "UnrealEngine"
  },
  {
    "name": "AppceleratorTitanium"
  },
  {
    "name": "CraftCMS"
  },
  {
    "name": "ForceDotCom"
  },
  {
    "name": "ExtJs"
  },
  {
    "name": "MetaProgrammingSystem"
  },
  {
    "name": "D"
  },
  {
    "name": "Objective-C"
  },
  {
    "name": "RhodesRhomobile"
  },
  {
    "name": "R"
  },
  {
    "name": "EPiServer"
  },
  {
    "name": "Yeoman"
  },
  {
    "name": "VisualStudio"
  },
  {
    "name": "Processing"
  },
  {
    "name": "Leiningen"
  },
  {
    "name": "Stella"
  },
  {
    "name": "Opa"
  },
  {
    "name": "Drupal"
  },
  {
    "name": "TurboGears2"
  },
  {
    "name": "Idris"
  },
  {
    "name": "Jboss"
  },
  {
    "name": "CodeIgniter"
  },
  {
    "name": "Qooxdoo"
  },
  {
    "name": "Waf"
  },
  {
    "name": "Sass"
  },
  {
    "name": "Lua"
  },
  {
    "name": "Clojure"
  },
  {
    "name": "IGORPro"
  },
  {
    "name": "Gradle"
  },
  {
    "name": "Archives"
  },
  {
    "name": "SynopsysVCS"
  },
  {
    "name": "Ninja"
  },
  {
    "name": "Tags"
  },
  {
    "name": "OSX"
  },
  {
    "name": "Dreamweaver"
  },
  {
    "name": "CodeKit"
  },
  {
    "name": "NotepadPP"
  },
  {
    "name": "VisualStudioCode"
  },
  {
    "name": "Mercurial"
  },
  {
    "name": "BricxCC"
  },
  {
    "name": "DartEditor"
  },
  {
    "name": "Eclipse"
  },
  {
    "name": "Cloud9"
  },
  {
    "name": "TortoiseGit"
  },
  {
    "name": "NetBeans"
  },
  {
    "name": "GPG"
  },
  {
    "name": "Espresso"
  },
  {
    "name": "Redcar"
  },
  {
    "name": "Xcode"
  },
  {
    "name": "Matlab"
  },
  {
    "name": "LyX"
  },
  {
    "name": "SlickEdit"
  },
  {
    "name": "Dropbox"
  },
  {
    "name": "CVS"
  },
  {
    "name": "Calabash"
  },
  {
    "name": "JDeveloper"
  },
  {
    "name": "Vagrant"
  },
  {
    "name": "IPythonNotebook"
  },
  {
    "name": "TextMate"
  },
  {
    "name": "Ensime"
  },
  {
    "name": "WebMethods"
  },
  {
    "name": "VirtualEnv"
  },
  {
    "name": "Emacs"
  },
  {
    "name": "Momentics"
  },
  {
    "name": "JetBrains"
  },
  {
    "name": "SublimeText"
  },
  {
    "name": "Kate"
  },
  {
    "name": "ModelSim"
  },
  {
    "name": "Redis"
  },
  {
    "name": "KDevelop4"
  },
  {
    "name": "Bazaar"
  },
  {
    "name": "Linux"
  },
  {
    "name": "Windows"
  },
  {
    "name": "XilinxISE"
  },
  {
    "name": "Lazarus"
  },
  {
    "name": "EiffelStudio"
  },
  {
    "name": "Anjuta"
  },
  {
    "name": "Vim"
  },
  {
    "name": "Otto"
  },
  {
    "name": "MicrosoftOffice"
  },
  {
    "name": "LibreOffice"
  },
  {
    "name": "SBT"
  },
  {
    "name": "MonoDevelop"
  },
  {
    "name": "SVN"
  },
  {
    "name": "FlexBuilder"
  }
]
```

## Single gitignore template

Get a single gitignore template.

```
GET /templates/gitignores/:key
```

| Attribute  | Type   | Required | Description |
| ---------- | ------ | -------- | ----------- |
| `key`      | string | yes      | The key of the gitignore template |

```bash
curl https://gitlab.example.com/api/v4/templates/gitignores/Ruby
```

Example response:

```json
{
  "name": "Ruby",
  "content": "*.gem\n*.rbc\n/.config\n/coverage/\n/InstalledFiles\n/pkg/\n/spec/reports/\n/spec/examples.txt\n/test/tmp/\n/test/version_tmp/\n/tmp/\n\n# Used by dotenv library to load environment variables.\n# .env\n\n## Specific to RubyMotion:\n.dat*\n.repl_history\nbuild/\n*.bridgesupport\nbuild-iPhoneOS/\nbuild-iPhoneSimulator/\n\n## Specific to RubyMotion (use of CocoaPods):\n#\n# We recommend against adding the Pods directory to your .gitignore. However\n# you should judge for yourself, the pros and cons are mentioned at:\n# https://guides.cocoapods.org/using/using-cocoapods.html#should-i-check-the-pods-directory-into-source-control\n#\n# vendor/Pods/\n\n## Documentation cache and generated files:\n/.yardoc/\n/_yardoc/\n/doc/\n/rdoc/\n\n## Environment normalization:\n/.bundle/\n/vendor/bundle\n/lib/bundler/man/\n\n# for a library or gem, you might want to ignore these files since the code is\n# intended to run in multiple environments; otherwise, check them in:\n# Gemfile.lock\n# .ruby-version\n# .ruby-gemset\n\n# unless supporting rvm < 1.11.0 or doing something fancy, ignore this:\n.rvmrc\n"
}
```
