class Dashboard::TodosController < Dashboard::ApplicationController
  include ActionView::Helpers::NumberHelper

  before_action :find_todos, only: [:index, :destroy_all]

  def index
    @sort = params[:sort]
    @todos = @todos.page(params[:page])
    if @todos.out_of_range? && @todos.total_pages != 0
      redirect_to url_for(params.merge(page: @todos.total_pages, only_path: true))
    end
  end

  def destroy
    TodoService.new.mark_todos_as_done_by_ids([params[:id]], current_user)

    respond_to do |format|
      format.html do
        redirect_to dashboard_todos_path,
                    status: 302,
                    notice: 'Todo was successfully marked as done.'
      end
      format.js { head :ok }
      format.json { render json: todos_counts }
    end
  end

  def destroy_all
    updated_ids = TodoService.new.mark_todos_as_done(@todos, current_user)

    respond_to do |format|
      format.html { redirect_to dashboard_todos_path, status: 302, notice: 'All todos were marked as done.' }
      format.js { head :ok }
      format.json { render json: todos_counts.merge(updated_ids: updated_ids) }
    end
  end

  def restore
    TodoService.new.mark_todos_as_pending_by_ids([params[:id]], current_user)

    render json: todos_counts
  end

  def bulk_restore
    TodoService.new.mark_todos_as_pending_by_ids(params[:ids], current_user)

    render json: todos_counts
  end

  private

  def find_todos
    @todos ||= TodosFinder.new(current_user, params).execute
  end

  def todos_counts
    {
      count: number_with_delimiter(current_user.todos_pending_count),
      done_count: number_with_delimiter(current_user.todos_done_count)
    }
  end
end
