# frozen_string_literal: true

module Gitlab
  module Database
    module Count
      # This strategy performs an exact count on the model.
      #
      # This is guaranteed to be accurate, however it also scans the
      # whole table. Hence, there are no guarantees with respect
      # to runtime.
      #
      # Note that for very large tables, this may even timeout.
      class ExactCountStrategy
        attr_reader :models
        def initialize(models)
          @models = models
        end

        def count
          models.each_with_object({}) do |model, data|
            data[model] = model.count
          end
        rescue *CONNECTION_ERRORS
          {}
        end

        def self.enabled?
          true
        end
      end
    end
  end
end
