# Neuro Elman 1 Layer

<img src="../../assets/nodes/logic/neuro.png"/>

<h2>Functionality</h2>
<p>
Однослойная нейронная сеть с обучением. На вход подаются входные данные и ожидаемые выходные.
Необходимо сеть обучить на наборе данных. После обучения можно использовать этот узел для вычислений по новому набору.
</p>
<a href="https://kpfu.ru/staff_files/F1493580427/NejronGafGal.pdf">Описание алгоритма</a>
<p>Перед использованием узел нужно настроить. Сначала настраиваются обязаельные параметры. Дополнительные парметры можно не трогать без необходимости.
После настройки узла и поключения связей можно приступать к обчению.
Узел обучается при каждом обновлении. Обновить можно с помощью кнопки или запустить анимацию.
Последний вариант удобен тем, что можно просто ждать пока узел обучится, и затем остановить анимацию.
</p>
<p>
<u>Формат данных</u>:<br>
[obj1, obj2, obj3, ...]<br>
obj = [...]<br>
[[...], [...], [...], ...]<br>
т.е. уровень списка объектов. Каждый объект содержит список значений для одной порции обучения. 
Т.о. предварительно подготовить данные и запаковать их в объекты, а затем подать на вход. На вход <b>etalon</b> нужно подать 
такое же количество объектов, чтобы обучать сеть. На выходе получим такое же количество объектов с результатом работы сети.
</p>

<h2>Category</h2>
Logic -> Neuro Elman 1 Layer

<h2>Inputs</h2>
<ul>
<li><b>data</b> - входящий набор данных</li>
<li><b>etalon</b> - ожидаемый набор данных</li>
</ul>

<h2>Outputs</h2>
<ul>
<li><b>result</b> - результат преобразований</li>
</ul>

<h2>Parameters</h2>
<ul>
<li><b>A layer</b> - количество нейронов первого слоя, равно количеству входных данных в объекте</li>
<li><b>B layer</b> - количество нейронов второго слоя, это внутренний слой</li>
<li><b>C layer</b> - количество нейронов третьего слоя, равно количеству значений в объекте на выходе</li>
<li><b>maximum</b> - максимальные возможные значения, которые предполагается использовать на узле</li>
<li><b>koeff learning</b> - темп обучения узла (не страшно менять)</li>
<li><b>gisterezis</b> - запланирован для установки пороговых значений при обработке сигналов (пока не используется)</li>
<li><b>cycles</b> - количество циклов обучения узла за один прогон</li>
<li><b>epsilon</b> - восприимчивость обучаения узла</li>
<li><b>lambda</b> - шаг изменения весовых коэффиуциентов</li>
<li><b>treshold</b> - порог, предотвращающий переобучение</li>
<li><b>Reset</b> (button) - сброс всех весовых коэффициентов</li>
</ul>

<h2>Usage</h2>
<strong>Постановка задачи</strong>
<p>
Необходимо обучить сеть операции XOR:<br>
[1, 1] = [1]<br>
[1, 0] = [1]<br>
[0, 1] = [1]<br>
[0, 0] = [0]<br>
</p>
<strong>Подготовка набора данных</strong>
<p>
<img src="../../assets/nodes/logic/neuro_data_in.png"/>
<img src="../../assets/nodes/logic/neuro_data_in_text.png"/>
<br>Аналогично подготовим ожидаемые данные<br>
<img src="../../assets/nodes/logic/neuro_etalon.png"/>
</p>
<strong>Подготовка узла</strong>
<ul>
<li><b>A layer</b> - задаём значение 2, т.к. на вход подаются значения парами</li>
<li><b>B layer</b> - поставим 5, но может быт любым (экспериментируйте)</li>
<li><b>C layer</b> - задаём 1, т.к. на выходе должны получить результат в одно число</li>
</ul>
<img src="../../assets/nodes/logic/neuro_ansumble.png"/>
<br>
Запускаем анимацию и ждём минуту. Затем выключаем анимацию. У меня получился такой результат:
<br>
<img src="../../assets/nodes/logic/neuro_training_result.png"/>

<p>
Давайте проверим результат обучения.<br>
<img src="../../assets/nodes/logic/neuro_result.png"/>
<br>
</p>

