#ifndef LINKWINDOW_H
#define LINKWINDOW_H

#include <QMainWindow>
#include <QTime>
#include <QWebEnginePage>
#include <QSystemTrayIcon>

class Browser;
class TabWidget;
class WebView;

class LinkWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit LinkWindow(Browser *browser, QWebEngineProfile *profile, bool forDevTools = false);
    ~LinkWindow();
    QSize sizeHint() const override;
    TabWidget *tabWidget() const;
    WebView *currentTab() const;
    Browser *browser() { return m_browser; }


private:
    Browser *m_browser;
    QWebEngineProfile *m_profile;
    TabWidget *m_tabWidget;

};

#endif // LINKWINDOW_H
