#include "webEngineWidgets/browser.h"
#include "webEngineWidgets/browserwindow.h"
#include "webEngineWidgets/tabwidget.h"
#include "webEngineWidgets/webview.h"

#include <QApplication>
#include <QLocale>
#include <QTranslator>
#include <QWebEngineProfile>
#include <QWebEngineSettings>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    a.setWindowIcon(QIcon(QStringLiteral(":/icon.png")));
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);
    QCoreApplication::setAttribute(Qt::AA_UseHighDpiPixmaps);

    QTranslator translator;
    const QStringList uiLanguages = QLocale::system().uiLanguages();
    for (const QString &locale : uiLanguages) {
        const QString baseName = "mos-vkm_" + QLocale(locale).name();
        if (translator.load(":/i18n/" + baseName)) {
            a.installTranslator(&translator);
            break;
        }
    }

    QWebEngineSettings::defaultSettings()->setAttribute(QWebEngineSettings::PluginsEnabled, true);
    #if QT_VERSION >= QT_VERSION_CHECK(5, 13, 0)
        QWebEngineSettings::defaultSettings()->setAttribute(QWebEngineSettings::DnsPrefetchEnabled, true);
        QWebEngineProfile::defaultProfile()->setUseForGlobalCertificateVerification();
    #endif

    Browser browser;
    BrowserWindow *window = browser.createWindow();

    QString vkm_link = "https://web.vk.me/";
    QUrl vkm_url = QUrl(vkm_link);
    window->tabWidget()->currentWebView()->setUrl(vkm_url);
    return a.exec();
}
