#ifndef AUTHSERVICE_H
#define AUTHSERVICE_H

#include <QMap>
#include <QObject>
#include <QProcess>
#include <QString>

class Configuration;

class AuthService : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool guestEnabled READ guestEnabled CONSTANT)
    Q_PROPERTY(bool mosAuthBtnEnabled READ mosAuthBtnEnabled CONSTANT)
    Q_PROPERTY(bool loginLowercaseOnly READ loginLowercaseOnly CONSTANT)
    Q_PROPERTY(bool wifiEapDomainIsSet READ wifiEapDomainIsSet CONSTANT)
    Q_PROPERTY(QString wifiEapSsid READ wifiEapSsid CONSTANT)

public:
    enum Role {
        Student,
        Teacher,
        Admin,
    };
    Q_ENUM(Role)

    explicit AuthService(QObject *parent = nullptr);
    ~AuthService() override = default;

    bool guestEnabled() const;
    bool mosAuthBtnEnabled() const;
    bool loginLowercaseOnly() const;
    bool wifiEapDomainIsSet() const;
    QString wifiEapSsid() const;


    Q_INVOKABLE void registerUser(const QString &obrId, //
                                  const QString &name,
                                  const QString &login,
                                  const QString &pin,
                                  QList<int> roles);

    Q_INVOKABLE void prepareGuest();

    Q_INVOKABLE void handleEapWifi(const QString &ssid, //
                                   const QString &login,
                                   const QString &pass);

Q_SIGNALS:
    void registerUserFinished(bool result);
    void prepareGuestFinished(bool result);

    // handle DBus signals
    void login(const QString &user, const QString &pass);

private:
    const QString commonGroup = "users";
    const QString enterpriseConnectionName = "temp-enterprise-сonnection";

    Configuration *config = nullptr;

    QProcess *registerUserProcess = nullptr;
    QProcess *prepareGuestProcess = nullptr;

    QMap<int, QString> mapRoleToGroup = initMapRoleToGroup();
    QMap<int, QString> initMapRoleToGroup();

    QString getGroupsFromRoles(const QList<int> &roles, const QString &separator = ",");
    QString getExcludeGroupsFromRoles(const QList<int> &roles, const QString &separator = "\\|");

    // connect to DBus system bus
    void dbusConnect();
};

#endif
