import QtQuick 2.15
import QtQuick.Layouts 1.15
import QtQuick.Controls 2.15 as QQC2
import org.kde.kirigami 2.13 as Kirigami
import org.kde.plasma.core 2.0 as PlasmaCore

Item {
    id: item

    property alias text: labelItem.text
    property alias subtitle: subtitleItem.text

    property string avatarPath: ""
    property string homeDir: ""
    property bool tooltipVisible: false
    property bool bold: false
    property color textColor: PlasmaCore.Theme.textColor

    property int leftPadding: Kirigami.Units.largeSpacing
    property int rightPadding: Kirigami.Units.largeSpacing

    anchors.fill: parent

    RowLayout {
        id: layout

        anchors.fill: parent
        anchors.leftMargin: leftPadding
        anchors.rightMargin: rightPadding
        spacing: Kirigami.Units.largeSpacing

        Kirigami.Avatar {
            source: (avatarPath.endsWith("/.face.icon")
                     && !avatarPath.startsWith(`file://${homeDir}`))
                    ? ""
                    : avatarPath

            name: text
            cache: false // avoid caching
            implicitWidth: Kirigami.Units.iconSizes.medium - 2
            implicitHeight: Kirigami.Units.iconSizes.medium - 2
            border.color: Kirigami.ColorUtils.adjustColor(textColor, {alpha: 0.4*255})
            border.width: 1
        }

        ColumnLayout {
            id: labelColumn
            spacing: 0
            Layout.fillWidth: true
            Layout.alignment: Qt.AlignVCenter
            QQC2.Label {
                id: labelItem
                Layout.fillWidth: true
                color: textColor
                elide: Text.ElideRight
                font.weight: item.bold ? Font.Bold : Font.Normal
            }
            QQC2.Label {
                id: subtitleItem
                Layout.fillWidth: true
                color: textColor
                elide: Text.ElideRight
                font: PlasmaCore.Theme.smallestFont
                opacity: item.bold ? 0.9 : 0.7
                visible: text.length > 0
            }
        }
    }

    QQC2.ToolTip.text: {
        let txt = "";
        if (labelItem.truncated) {
            txt += labelItem.text;
        }
        if (subtitleItem.truncated) {
            if (txt.length > 0) {
                txt += "<br/><br/>";
            }
            txt += subtitleItem.text;
        }
        return txt;
    }
    QQC2.ToolTip.visible: QQC2.ToolTip.text.length > 0 && tooltipVisible
    QQC2.ToolTip.delay: Kirigami.Settings.tabletMode ? Qt.styleHints.mousePressAndHoldInterval : Kirigami.Units.toolTipDelay
}
