#include "guestdbusservice.h"

#include <QCoreApplication>
#include <QDBusConnection>
#include <QDebug>

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    const auto service = std::make_unique<GuestDBusService>();

    auto connection = QDBusConnection::systemBus();

    if (!connection.isConnected()) {
        qWarning() << "Cannot connect to the D-Bus system bus.";
        return 1;
    }

    if (!connection.registerService(SERVICE_NAME)) {
        qWarning() << QString("Service '%1' is already registered by another application.").arg(SERVICE_NAME);
        return 1;
    }

    connection.registerObject("/", service.get(), QDBusConnection::ExportAllSlots);

    return a.exec();
}
