#include "guestdbusservice.h"
#include "qobject.h"

#include <QDebug>
#include <QProcess>

GuestDBusService::GuestDBusService(QObject *parent)
    : QObject(parent)
{
}

QString GuestDBusService::run(const QString &cmd)
{
    qInfo() << QString("run command: %1").arg(cmd);

    QProcess process;
    process.start("bash", QStringList() << "-c" << cmd);

    if (!process.waitForStarted(-1))
        return "Can't run command";

    if (!process.waitForFinished(-1))
        return "Can't wait command finish";

    return process.readAll();
}

bool GuestDBusService::runDetach(const QString &cmd)
{
    qInfo() << QString("run detach command: %1").arg(cmd);

    return QProcess::startDetached("bash", QStringList() << "-c" << cmd);
}
