#!/bin/bash

set -e
set -u

trap 'echo exit' EXIT

# Общие функции.
. mos-auth-folders-functions

case "$2" in
    up)
        log "Была подключена сеть ($1 $2). Инициализировано подключение сетевых папок..." "debug"

        # Пытаемся получить ip адрес сервера с папками.
        shared_ip=$(get_shared_ip)

        # Монтируем, если не примонтировано. Если удалось, то создаем общую папку (в случае её отсутствия).
        prepare_shared_folders "$shared_ip"

        # Для всех активных пользователей создадим симлинки на сетевые папки.
        log "Создание ссылок на сетевые папки для всех активных пользователей..." "debug"
        for uname in $(who -u | awk '{print $1}')
        do
            if { ! check_user_group "$uname" ; }
            then
                continue
            fi

            create_folder_links "$uname"
        done
    ;;
    down|pre-up)
        # Возможно была отключена сеть, которая не имеет отношения к сетевым папкам,
        # поэтому проверим, можем ли мы все ещё получать ip-адрес сервера с папками,
        # и если да, то проверим также доступность этого сервера.
        if { ! shared_ip=$(get_shared_ip) || ! timeout -s SIGKILL --preserve-status 3 /usr/bin/rpcinfo -p "$shared_ip" > /dev/null 2>&1 ; }
        then
            # И только если ip-адрес не удалось получить, или сервер не доступен, тогда принудительно отмонтируем папки.
            # Это также поможет и в случае, если папки долго 'висят' после потери соединения.

            server_domain=$(get_server_domain)
            log "После изменения состояния сети ($1 $2), сервер с сетевыми папками стал не доступен ($server_domain).\nДемонтируем сетевые папки ($server_domain)..." "debug"

            umount -qf "$(get_shared_folder)" || true
        fi

        delete_folder_links_if_unmounted
    ;;
esac
