#!/bin/bash

set -e
set -u

trap 'echo exit' EXIT

# Общие функции.
. mos-auth-folders-functions

if { check_user_group "$PAM_USER" ; }
then
    log "Запущен сеанс пользователя '$PAM_USER'. Инициализировано подключение сетевых папок..." "debug"

    # Пытаемся получить ip адрес сервера с папками.
    shared_ip=$(get_shared_ip)

    # Если не примонтировано, удаляем все симлинки.
    delete_folder_links_if_unmounted

    # Монтируем, если не примонтировано. Если удалось, то создаем общую папку (в случае её отсутствия).
    prepare_shared_folders "$shared_ip"

    # Создаем личную папку (если отсутствует) и симлинки для пользователя.
    create_folder_links "$PAM_USER"
fi
