#!/bin/bash
set -x
set -e
trap 'if [ $? != 0 ]; then echo "!!! TEST FAILED !!!" && exit 1; fi' EXIT
SOURCING=1
. ./mos-auth-config.sh
conf="$(mktemp)"
cat sddm.conf > "$conf"
[ "$(py-ini-config get ""$conf"" Theme Current)" = breeze ]
_sddm_config "$conf"
grep -q 'Current=mos-auth' "$conf"
# проверяем, что не было сделано лишних правок
[ "$(diff sddm.conf "$conf" | grep -E -- '(<|>)' | grep -c .)" = 6 ]
unlink "$conf"
