ChangeLog
=========

English version [by liar Google](https://libmdbx-dqdkfa-ru.translate.goog/md__change_log.html?_x_tr_sl=ru&_x_tr_tl=en) and [by Yandex](https://translated.turbopages.org/proxy_u/ru-en.en/https/libmdbx.dqdkfa.ru/md__change_log.html).

The source code is availale on [SourceCraft](https://sourcecraft.dev/dqdkfa/libmdbx) and mirrors on [abf.io](https://abf.io/erthink/libmdbx) and [GitFlic](https://gitflic.ru/project/erthink/libmdbx).
Please use the `stable` branch or the latest release for production environment through stagging, but the `master` branch for development a derivative projects.
Donations are welcome to ETH `0xD104d8f8B2dC312aaD74899F83EBf3EEBDC1EA3A`. Всё будет хорошо!

## v0.14.2 в разработке без конкретизации даты выпуска

Продолжение развития нового куста/линейки версий с добавлением функционала, расширением API и внутренними переработками.

Проект libmdbx полностью перемещен в юрисдикцию Российской Федерации.
Пожалуйста обращайтесь на https://libmdbx.dqdkfa.ru за документацией и на https://sourcecraft.dev/dqdkfa/libmdbx за исходным кодом (он по-прежнему открыт и обеспечен первоклассной бесплатной поддержкой).

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Артёму Воротникову](https://github.com/vorot93) за сообщение об ошибках и тестировании [призязок для Rust](https://github.com/vorot93/libmdbx-rs).
 - [Stefan de Konink](https://github.com/skinkie) for fixing [Python bindings](https://github.com/wtdcode/mdbx-py) and documentation improvement.

Новое:

 - Реализована "Ранняя очистка GC".

   Теперь переработанные записи GC удаляются не при фиксации пишущей транзакции, а по-возможности сразу. Это открывает путь к реализации явной дефрагментации (без копирования БД) и далее к нелинейной переработке GC (что позволит устранить проблему распухания/переполнения БД из-за остановки переработке GC при длительных читающих транзакциях).

   Объём накладных расходов теперь более пропорционален объему совершаемых операций. Поэтому, в большинстве сценариев накладные расходы чуть меньше, но наоборот чуть больше при отмене вложенных транзакций.

 - В API копирования БД добавлена опция `MDBX_CP_OVERWRITE` (перезапись целевого файла), а в утилиту `mdbx_copy` аналогичная по смыслу опция командной строки `-f` .

 - Поддержка Harmony OS (OHOS).

 - Операции с плавающей точкой больше не используются как внутри библиотеки, так и в утилитах, а из сценариев сборки удалено связывание c `libm`.

 - Обеспечена возможность установки отладочных опций `MDBX_DBG_ASSERT`, `MDBX_DBG_AUDIT` и других, через переменные среды окружения. Но соответствующие отладочные возможности по-прежнему должны быть активированы во время сборки.

 - Расширен и переработан состав информации формируемой функцией `mdbx_chk_env()` и выводимой утилитой `mdbx_chk`.

 - Основной репозиторий libmdbx перенесен с Gitflic на SourceCraft.

   Со своей стороны, я удручен необходимостью совершать такие манипуляции, ибо они создают существенные неудобства пользователям, но (к сожалению) для того есть достаточные причины:
     - Вместо обещанной интернационализации на Gitflic осталась только русскоязычная локализация с массой технический особенностей, затрудняющих использование систем машинного перевода. Это сделало невозможным использование сервиса многими пользователями и породило ряд справедливых жалоб/упреков, в том числе от разработчиков из Китая, Бразилии, Кореи, Ирана и т.д.
     - За три года, прошедшие с миграции на Gitflic, не исправлено несколько возмутительных ошибок в редакторе markdown, что превращало оформление релизов в раздражающую борьбу. Кроме этого из публичного пространства пропал roadmap развития. Суммарно это заставило меня отказаться от Gitflic.

Исправления:

 - Устранена критическая ошибка в функционале `mdbx_env_resurrect_after_fork()` при использовании SysV-семафоров.

   Проявлялась ошибка только после порождения дочернего процесса посредством `fork()` на фоне выполняющейся пишущей транзакции, что приводило к неверной работе семафоров и далее к самым различным ошибкам, вплоть до повреждения БД.
   Проблема существовала начиная с появления `mdbx_env_resurrect_after_fork()` и затрагивала OSX, а также POSIX-платформы при сборке с опцией `MDBX_LOCKING=5`.

 - Устранена проблема в API копирования БД на отличных от Linux системах POSIX, а также в некоторых случаях при расположении целевого файла на не-локальной файловой системе.
   Проблема проявлялась в основном на OSX, возвратом ошибки `EWOULDBLOCK`/`EAGAIN` (35), что обусловлено недочётом/конфликтом блокировок `fcntl(F_SETLK)` и `flock()` в ядре ОС.
   Переработана обработка ошибок захвата файловых блокировок в API копирования на системах POSIX.

 - Устранена ошибка приводившая к неожиданному возврату `MDBX_BAD_DBI` при одновременном старте нескольких транзакций внутри одного процесса после открытия БД.

 - Устранена ошибка приводившая к неожиданному возврату `MDBX_DBS_FULL` при повторном открытии уже открытых таблиц и уже достигнутом лимите открытых DBI-дескрипторов.

 - Исправлена ошибка сборки для платформы Android при явном определении `_FILE_OFFSET_BITS`.

 - Поправлено либо удалено несколько неверных assert-проверок, из-за которых происходили падения отладочных сборок в специфических ситуациях.
   Главным образом, в коде функций `txn_end()`, `txn_lock()` и `txn_unlock()` как на Windows, так и на POSIX.

 - Устранены несущественные предупреждения MSVC. Отключены предупреждения `C5286` и `C5287`.

 - Устранено получение неожиданного `SIGBUS` из-за отложенного/ленивого выделение места в заполненной файловой системе после приращения файла БД.
   Более подробное пояснение в комментарии коммита [`2a7f460345edbeb26a51782cbe6af3c55254ae77`](https://gitflic.ru/project/erthink/libmdbx/commit/2a7f460345edbeb26a51782cbe6af3c55254ae77).

 - Исправлена assert-проверка в пути сканирования битовой карты DBI-дексрипторов приводившая к редким падениям 32-битных отладочных сборок.

 - Переделан поиск утилит `lib.exe` и `dlltool.exe` при сборке посредством CMake на Windows.

 - Устранено падение при выполнении Thread-Local-Storage конструкторов при выгрузке библиотеки и наличия экземпляров env, инициализация которых не была завершена.

 - На Windows устранена причина возврата неожиданной ошибки `ERROR_IO_PENDING` в сценариях множественного открытия одной БД в одном процессе.

 - Исправлен недочёт автоподстройки параметров при установке геометрии с заданным минимальным размером страницы, из-за которого на машинах с большим количеством ОЗУ размер страницы мог увеличиваться.

 - В CMake-скриптах устранён регресс, из-за которого инфраструктура `ctest` не использовала задаваемые параметры Valgrind, в том числе `MEMORYCHECK_SUPPRESSIONS_FILE`.
   Теперь использование `ctest -D ExperimentalMemCheck` не приводит к множественной ложно-положительной диагностики. Однако, для использования Valgrind по-прежнему необходимо собирать библиотеку с предопределением макроса `ENABLE_MEMCHECK`.

Изменение поведения:

 - Вновь включена/разрешена на старых ядрах Linux, начиная с версии 3.16, так как сейчас уже нет причин отказываться от работы на 3.16 поддерживая при этом ядра 4.x, и еще есть проекты (Isar, Isar-Community, Hive) которым требуется такая поддержка.

 - Изменено значение по-умолчанию порога слияния страниц с 25% до 33%.

 - Ошибка `MDBX_WANNA_RECOVERY` при открытии БД в режиме только-чтение теперь возвращается если размер БД не кратен размеру системной страницы, но игнорируется не кратность размеру блока выделения виртуальной памяти. Этим устраняется регресс, проявившейся вследствие изменения поведения после задействования системного вызова `fallocate()` для предотвращения `SIGBUS` после приращения файла БД в заполненной файловой системе.

 - Для уменьшения вероятности неожиданных ошибок, вследствие переходных процессах и отложенной обработки в ядре ОС при конкурентном закрытии и открытии БД разными процессами, втрое увеличено количество повторных попыток захвата блокировок. Предположительно это также решит проблему неожиданных ошибок `EAGAIN` (11) на Android при рестарте приложений и открытия БД сразу после закрытия.

 - По-умолчанию сборка для Windows теперь выполняется с использованием SDK уровня Windows 10, а не Windows 7.

 - Изменён размер и состав структуры `MDBX_envinfo`, а функция `mdbx_env_info_ex()` больше не поддерживает старые варианты. Этим нарушена совместимость ABI со старыми версиями библиотеке, но сохранена совместимость API на уровне исходного кода.

 - Шаблон `mdbx::buffer<ALLOCATOR, POLICY>` теперь наследуется от `mdbx::slice` и `mdbx::buffer_tag`, что упростило C++ API и использование подходом мета-программирования.

 - При сборке посредством GNU Make и CMake теперь, вместо одного `config.h`, генерируются разные файлы `config-gnumake.h` и `config-cmake.h`.

Прочие доработки:

 - Доработана логика отказа от использования OFD-блокировок на POSIX-платформах.
   Теперь кроме `EINVAL` учитываются дополнительные коды ошибок (`ENOSYS`, `ENOIMPL`, `ENOTSUP`, `ENOSUPP`, `EOPNOTSUPP`), что позволит работать собранной библиотеке в некоторых случаях, когда актуальное ядро/контейнер/эмулятор не поддерживает требуемых системных вызовов.

 - Тесты дополнены сценариями для проверки добавленных возможностей, выявленных регрессов и ошибок.

 - В тестовый фреймворк добавлена поддержка опции `--numa #` для привязки стохастического теста к NUMA-узлу, а в battery/tmux-скрипте добавлено явное распределение по NUMA-узлам, что существенно увеличило КПД при тестировании на NUMA-машинах.

 - В стохастическом скрипте реализован случайный порядок запуска отдельных тестов.

 - В функционал проверки целостности БД и утилиту `mdbx_chk` добавлен вывод гистограммы заполнения страниц образующих структуру дерева и участвующих в операциях разделения/слияния/перебалансировки.

 - Для Android добавлен обход (workaround) для уменьшения вероятности системной ошибки `EAGAIN` возникающей из-за нехватки системных ресурсов и переходных процессов при закрытии и быстром повтороном открытии БД.

 - Для Linux добавлено предотвращение проявления ошибки в реализации fast_commit файловой системы Ext4.

 - В отладочные сборки на Windows при срабатывании assert-проверок добавлена поддержка вариантов "Пропустить" и "Повторить".

 - В используемых на платформе Windows файловых блокировках задействованы ожидания с таймаутами, что теоретически должно снизить вероятность возникновения ошибок `ERROR_LOCK_VIOLATION` (`33`) при открытии БД в конкурентных сценариях.

 - Переработка реализации буферов и другие доработки в C++ API.

 - В тестах устранено несколько несущественных утечек памяти и предупреждение UBSAN о вызове `memcmp(, length = 0)`.

--------------------------------------------------------------------------------

## v0.14.1 выпуск "Горналь" от 2025-05-05

Первый выпуск в новом кусте/линейке версий с добавлением функционала, расширением API и внутренними переработками.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Alain Picard](https://github.com/castortech) for support [Java bindings](https://github.com/castortech/mdbxjni) and MacOS universal binaries patch for CMake build scenario,
   also for bug reporting (put-`MDBX_MULTIPLE` regression). Big thank for assistance with debugging and testing.
 - [Alex Sharov](https://github.com/AskAlexSharov) за сообщение об ошибках и тестирование.
 - [Виктору Логунову](https://t.me/vl_username) за сообщение об опечатки в имени переменной в Conan-рецепте.
 - [Илье Михееву](https://t.me/IlyaMkhv) за сообщение о лишнем/ненужном предупреждении несоответствия файла БД новому размеру.
 - [maxc0d3r](https://gitflic.ru/user/maxc0d3r) for bug reporting and testing.
 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения о проблеме копирования на NFS.

Новое:

 - Переработан код обновления GC и возврата страниц при фиксации транзакций.

   Возникающая при этом задача алгоритмически сложна, так как список
   возвращаемых страниц находится в рекурсивной зависимости от самой
   процедуры возврата и связанных с этим операций, а прямые решения во
   многих случаях приводят к многократному росту накладных расходов.
   Поэтому исторически эта часть кода была запутанным наслоением «сдержек и
   противовесов», что создавало препятствие для развития. В ходе этой
   доработки, унаследованный из LMDB код связанный с обновлением GC, был
   полностью заменен вместе со всеми базирующимися на нём заплатками.

   Новая реализация использует контейнеры идентификаторов (aka RKL),
   комбинирующие внутри списки элементов и непрерывные интервалы, что
   позволяет предельно сократить накладные расходы и упросить реализацию
   остальных алгоритмов. Основывается новая реализация на простом
   прагматичном подходе «резервирования со взвешенным запасом». Для
   подавляющего подмножества сценариев этого достаточно для однопроходного
   обновления GC, с общей сложностью от `O(1)` для мелких транзакций, до
   `O(log(N))` для огромных. При этом реализованный еще в 0.12.1 подход «Big
   Foot» (дробление больших списков retired-страниц) полностью избавляет GC
   от потребности в последовательностях смежных/соседствующих страниц и
   одновременно позволяет работать новому коду обновления GC только по
   самому простому и быстрому пути.

   Тем не менее, при намеренном отключении «Big Foot», либо при работы с БД
   от старых версий движка без «Big Foot», возможны сложные ситуации, когда
   в GC могут огромные списки страниц, которые желательно дробить при
   возвращении неиспользованных переработанных остатков. В таких сценариях
   для возврата в GC требуется создавать больше записей чем было исходно
   переработано, что может приводить к нехватке имеющихся/переработанных
   идентификаторов. Тогда в игру вступает следующая часть нового кода,
   поиск в GC «дыр» (неиспользуемых промежутков/интервалов в пространстве
   ключей GC). Далее, если свободных идентификаторов (неиспользуемого
   пространства ключей GC) будет недостаточно, что весьма вероятно в
   некоторых сценариях, будет решаться задача родственная «укладке
   рюкзака». В конечном итоге, неиспользованные переработанные страницы
   будут возвращены в GC, с максимально равномерным
   распределением/дроблением и использованием имеющихся последовательностей
   смежных/соседствующих страниц, что гарантирует близость к теоретическому
   минимуму суммарной стоимости текущих действий и последующих операций.

   На данный момент нет известных практических сценариев ведущих к
   отказу/неуспеху новой реализации обновления GC. Но гипотетически такие
   случаи возможны, как из-за ошибок/недочетов в реализации, так и из-за
   использования катастрофически неудачных режимов работы и значений опций
   (например `MDBX_opt_rp_augment_limit`). В текущем понимании, в том числе
   основываясь на объем тестирования, вероятность проявления
   ошибок/недочетов оценивается как крайне низкая, а устраняться замеченные
   проблемы будут по мере обнаружения. Однако, полностью автоматическое
   решение самых кошмарных и запутанных ситуаций с GC следует ожидать
   только при реализации дефрагментации — просто потому что нет иного
   рационального способа решения, за вычетом копирования БД с
   дефрагментацией.

 - Добавлена опция сборки `MDBX_NOSUCCESS_PURE_COMMIT` предназначенная для отладки кода пользователя.
   По-умолчанию опция выключена и при фиксации пустых транзакции возвращается `MDBX_SUCCESS`.
   При включении опции, фиксация пишущих транзакций без каких-либо изменений считается нештатным поведением, с возвратом из `mdbx_txn_commit()` кода `MDBX_RESULT_TRUE` вместо `MDBX_SUCCESS`.
   Таким образом, у пользователя появляется возможность легко диагностировать лишние/ненужные транзакции записи.

 - Добавлена опция сборки `MDBX_ENABLE_NON_READONLY_EXPORT` позволяющая использовать в режиме чтения-записи БД расположенных в файловых системах экспортированных через NFS.
   По-умолчанию опция выключена и при открытии в неэксклюзивном режиме чтения-записи БД расположенных в файловых системах доступных извне по NFS будет возвращаться ошибка `MDBX_EREMOTE`.
   Включение опции позволяет открывать БД в описанных выше ситуациях, но риск чтения неверных данных на удалённой стороне ложится на пользователя.

 - Поддержка MacOS universal binaries при сборке посредством CMake.

 - Для закрытия или отсоединения всех курсоров с получением их количества в API добавлена функция `mdbx_txn_release_all_cursors_ex()`.

 - Добавлена операция `MDBX_SEEK_AND_GET_MULTIPLE` в API курсора, позволяющая за одну операцию выполнить позиционирование
   курсора на конкретное значение и начать чтение multi-значений в пакетном режиме.

 - Добавлены методы `mdbx::cursor::put_multiple_samelength()`, `mdbx::cursor::seek_multiple_samelength()`, `mdbx::cursor_managed::withdraw_handle()`.

 - В политику управления выделением для `mdbx::buffer<ALLOCATOR, CAPACITY_POLICY>` добавлен параметр `inplace_storage_size_rounding`.
   Одновременно с этим переработан внутренний union-тип `mdbx::buffer<ALLOCATOR, CAPACITY_POLICY>::silo::bin` для возможности увеличения без пенальти встроенного в экземпляр буфера места под данные.

 - Добавлена опция `-c` (concise) для включения компактного режима в `mdbx_dump`, также поддержка таких дампов в `mdbx_load`.
   В таких дампах значение ключей сохраняются однократно (не повторяются), что может существенно уменьшать результирующий объём для таблиц с multi-значениями (aka dupsort).
   Однако, компактные дампы не совместимы с форматом ожидаемым/поддерживаемым в Berkeley Database и LMDB.

 - В API добавлена функция `mdbx_cursor_close2()` возвращающая код ошибки.

 - В chk-функционал добавлена гистограмма количества multi-значений/дубликатов.
   При использовании утилиты `mdbx_chk`, для получения соответствующей (и массы другой) информации, достаточно увеличить детализацию несколько раз использовав опцию `-v`.

Изменение поведения:

 - Теперь при вставке данных в dupsort-таблицу CoW копирование целевых страниц выполняется после проверки отсутствия добавляемого значения среди уже присутствующих multi-значений (aka дубликатов).
   В результате вставка уже присутствующих "дубликатов" не приводит к каким-либо изменениям в БД и принципиально увеличивает производительность в таких сценариях.
   В текущем понимании, добавленная проверка не приводит к заметному увеличению накладных расходов и, как следствие, не приводит к снижению производительности в сценариях с обычным/регулярным обновлением и/или вставкой данных.

 - Использование системного кода ошибки `EREMOTEIO` ("Remote I/O error") вместо `ENOTBLK` ("Block device required") в качестве `MDBX_EREMOTE` для индикации ошибочной ситуации открытия БД расположенной на сетевом носителе.

 - Функция `mdbx_txn_release_all_cursors()` возвращает только код ошибки, не смешивая его с количеством обработанных/закрытых курсоров.
   Для аналогичных действий с получением количества закрытых курсоров в API добавлена функция `mdbx_txn_release_all_cursors_ex()`.

 - Поддержка пустого набора данных в put-операции `MDBX_MULTIPLE` ради упрощения пользовательского кода, какой-либо модификации данных в БД при этом не происходит.

 - Для основных вариантов использования шаблона `mdbx::buffer<>` теперь явно инстанцируются внутри библиотеки,
   одновременно соответствующие специализации шаблона помечены как `external` для предотвращения повторного инстанцирования в пользовательском коде.

 - Запрещена отвязка/открепление курсоров во вложенных транзакциях, т.е. вызовы `mdbx_cursor_unbind()` и
   `mdbx_txn_release_all_cursors(unbind=true)` для курсоров открытых в одной из родительских транзакций.
   Причина в том, что в случае отмены вложенной транзакции возникает неконструктивная неопределенность  — следует ли
   восстанавливать состояние курсоров. Если не восстанавливать, то получается что вложенная транзакция может поломать родительскую,
   сделав её продолжение невозможным. Если восстанавливать, то также следует «воскрешать» закрытые курсоры,
   что неизбежно приведет к путанице, утечкам памяти и использованию после освобождения.

 - В C++ API отменён вброс исключения при запросе транзакции у отсоединённого курсора посредством вывоза `mdbx::cursor::txn()`.

 - При невозможности отвязки курсора от его текущей транзакции функция `mdbx_cursor_bind()`
   теперь возвращает `MDBX_EINVAL` вместо `MDBX_BAD_TXN`.

Исправления:

 - Для совместимости с GCC 15.x в режиме C23 изменен порядок указания атрибутов функций.

 - Устранён регресс допускающий SIGSEGV в операциях обновления после вытеснения/spilling страниц в больших транзакциях.
   Ошибка присутствует в выпусках v0.13.1, v0.13.2, v0.13.3 и оставалась незамеченной из-за специфических условий и низкой вероятности проявления.
   Более подробная информация в описании коммита `cb8eec6d11cdab4f7d3cf87913e8009149dcf60b`.

 - Устранено лишнее/ненужное предупреждение в сценарии изменения размера БД посредством вызова `mdbx_env_set_geometry()` до её открытия.
   API предусматривает возможность запросить изменение геометрии/размера БД перед её открытием, чтобы избежать как лишних накладных расходов,
   так и потенциальных ошибок из-за нехватки адресного пространства. В этом сценарии ранее могло выдаваться лишнее/ненужное предупреждение
   о несоответствии файла БД новому размеру. Теперь этот недостаток исправлен.

 - Восстановлена доступность дескрипторов таблиц, открытых в дочерней транзакции, после её фиксации, в случае отсутствия изменений в данных.
   Проблема не была замечена ранее из-за специфического сценария проявления.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранён сбой аудита таблиц при инвалидации дескрипторов таблиц вследствие отмены вложенной транзакции.
   Проблема не была замечена ранее из-за специфического сценария проявления.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранена причина потенциальных сбоев и/и деградации производительности в сценарии закрытия курсора до завершения вложенной транзакции,
   с последующим изменением данных той-же таблицы в текущей вложенной транзакции, либо её дочерних транзакциях.
   Проблема обнаружена при ручном анализе кода, сценарии воспроизведения/проявления проблемы пока не известны.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `3de3d425a128a3c6f7866503f5f93b80c09dbe41` от 2024-05-19.

 - Устранена причина ложных ошибок при работе `mdbx_chk` с высоким уровнем логирования.
   Проблема возникала из-за неверной трактовки `MDBX_NOTFOUND` при штатном окончании итерируемых данных.

 - Устранена причина попыток рекурсивного захвата мьютекса при работе `mdbx_chk -w` в сборах с поддержкой Valring/ASAN и под управлением этих инструментов.

 - Устранена вероятность ситуации гонки в `tbl_setup(MDBX_DUPFIXED | MDBX_INTEGERDUP)` при работе в разных потоках.
   В реальных сценариях вероятность проявления проблемы была близка к нулю.
   Для подробностей смотрите комментарий коммита `3e91500fac475947f5b58268d5edd3c9cc4f77f6`.

 - Устранён регресс затенения курсоров во вложенных транзакциях.
   При реализации отложенной/ленивой инициализации dbi-дескрипторов также было реализовано отложенное затенение курсоров (создание копии состояния для отката при прерывании транзакции),
   что существенно уменьшало накладные расходы при старте и завершении вложенных транзакций в сценариях с большим количеством курсоров.
   Однако, была допущена логическая ошибка, вследствие которой отложенная инициализация и затенение выполнялись при использовании dbi-дескрипторов, но не курсора открытого в родительской транзакции.
   В результате, родительские курсоры во вложенных транзакциях могли не затеняться, что приводило к неконсистентному состоянию в случае
   прерывания/откате вложенной транзакции и в соответствующей таблицы были изменения в рамках прерванной вложенной транзакции.
   Проблема не реализовывалась в тестовых сценариях и не была замечена при эксплуатации, но была обнаружена при расширении тестов.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранён регресс в пути обработки операции `MDBX_MULTIPLE`.
   Пакетная вставка значений посредством `MDBX_MULTIPLE` могла приводить к падениям и повреждению структуры БД. Ошибка оставалось не
   замеченной из-за специфических условий проявления, которые не реализовались в тестах.
   Проблема присутствовала во всех выпусках начиная с v0.13.1, но соответствующая ошибка не связана с конкретным коммита в истории, а
   является следствием нескольких доработок (шагов рефакторинга), которые суммарно привели к регрессу.
   Технически ошибка обусловлена не-обнулением переменной, чего не происходило в некотором пути выполнения, так как исходно не требовалось.
   Однако, такое обнуление потребовалось после ряда этапов оптимизации и рефакторинга смежных участков кода.
   Для подробностей смотрите комментарий коммита `23a417fe19614481c6546845995d6dc845baf797`.

 - Скорректировано описание ошибки `MDBX_MVCC_RETARDED` и текста соответствующего сообщения.

 - В C++ API добавлена упущенная проверка `__cpp_concepts >= 202002` для использования концептов C++.

 - Устранён регресс при использовании курсоров для DBI=0 в читающих транзакциях.

   После рефакторинга и ряда оптимизаций для завершения/гашения
   курсоров в читающих и пишущих транзакций стал использоваться общий код.
   Причем за основу, был взят соответствующий фрагмент относящийся к
   пишущим транзакциям, в которых пользователю не позволяется
   использоваться курсоры для DBI=0 и поэтому эта итераций пропускалась.

   В результате, при завершении читающих транзакциях, курсоры связанные с
   DBI=0 не завершались должным образом, а при их повторном использовании
   или явном закрытии после завершения читающей транзакции происходило
   обращение к уже освобожденной памяти. Если же такие курсоры
   отсоединялись или закрывались до завершения читающей транзакции, то
   ошибка не имела шансов на проявление.

 - Устранён регресс в виде ошибки `EAGAIN` при копировании БД на NFS и CIFS/SMB.

   При доработках/развитии API в функции копирования был добавлен захват
   файловой блокировки посредством как `fcntl()`, так и `flock()`. Однако,
   в зависимости от версии локального ядра, версии удалённого сервера NFS и
   опций монтирования, это могло приводить к возврату POSIX-ошибки `EAGAIN`
   (`11` на большинстве платформ, включая Linux).

 - Устранена ошибка merge/rebase внутри `mdbx_txn_release_all_cursors_ex()`,
   что могло приводить к последующим неожиданным ошибкам `MDBX_EBADSIGN` и утечкам памяти.
   Для проверки сценария дополнен соответствующий тест.

 - Исправлена assert-проверка в пути завершения вложенных транзакций.
   Для проверки сценария дополнен соответствующий тест.

 - Устранена возможность возврата неожиданной ошибки `MDBX_BUSY` из `mdbx_txn_lock(dont_wait=false)`.

Прочие доработки:

 - Существенный рефакторинг с реструктуризацией кода, переименованием внутренних структур, их полей и внутренних функций.

 - Доработка использования LTO в CMake-сценариях: использование `-flto=auto` для GCC >= 11.4,
   расслабление условий для включения LTO для CLANG на Linux, расширение поиска `LLVMgold.so` в относительных lib-директориях.

 - Добавлены дополнительные проверки сигнатур курсоров при итерации связанных списков.

 - Кратное сокращение итераций тестов в зависимости от конфигурации Valgrind/Debug/CI.

 - Устранены предупреждения UBASN о невыравненном доступе в тесте extra/close-dbi.

 - Добавлен перехват и логирование исключений в extra-тестах на C++.

 - Расширены тесты extra/dupfix-multiple, extra/cursor-closing и extra/txn.

 - В утилиту тестирования добавлена поддержка режима/опции `MDBX_VALIDATION` и поддержка значений `on`/`off` для опций командной строки.

 - Добавлены doxygen-описания для doubtless-positioning констант.

 - Переработана проверка курсоров на входе в API-функций с добавлением `cursor_check()`, `cursor_reset()` и `cursor_drown()`.

 - Отключено использование C23 `[[атрибутов]]` для версий CLANG меньше 20.

 - Во избежание потенциальных проблем отключено использование `copy_file_range()` на ядрах Linux 5.3 - 5.18.

 - Вброс `std::invalid_argument` теперь производится явным сообщением `MDBX_EINVAL`.

--------------------------------------------------------------------------------

## v0.14.0 от 2025-01-13

Технический тэг, отмечающий начало ветки `0.14`
с новым функционалом и изменением API.

Запланированные новые возможности 0.14:

1. Ранняя (не-отложенная) очистка GC и рефакторинг обновления GC. Самостоятельной видимой для пользователя ценности не имеет, но требуется для последующих пунктов.
   Будет реализовано в 0.14.1.

2. Явная дефрагментация БД. В API будет добавлена функция с двумя парами параметров:
    - минимальный (требуемый) объём дефрагментации (уменьшения БД) и минимальное время, которое следует потратить;
    - максимальный (ограничивающий) объём дефрагментации и максимальной время, которое допустимо потратить.

    Упрощенно, алгоритмически явная дефрагментация сводится к сканированию b-tree с формированием списка страниц расположенных близко к концу БД, а затем копирование этих страниц в не-используемые, но расположенные ближе к началу БД.
    В результате, после фиксации дефрагментирующей транзакции оригиналы скопированных страниц становятся не-используемыми, а размер БД может быть уменьшен за счет отсечения ни-используемых страниц в конце используемого пространства.
    Будет реализовано в 0.14.2.

3. Нелинейная переработка GC, без остановки переработки мусора на старом MVCC-снимке используемом долгой транзакцией чтения.

    После реализации запланированного, любая длительная читающая транзакция по-прежнему будет удерживать от переработки используемый/читаемый MVCC-снимок данных (все образующие его страницы БД), но позволит перерабатывать все неиспользуемые MVCC-снимки, как до читаемого, так и после.
    Это позволит устранить [один из основных архитектурных недостатков](https://libmdbx.dqdkfa.ru/intro.html#long-lived-read) унаследованных от LMDB и связанных с ростом размера БД пропорционально объёму производимых изменений данных на фоне долго работающей транзакции чтения.

    Будет реализовано предположительно в 0.14.3, 0.14.4 или даже в 0.15.x.
    Перенос в 0.15.x оправдан возможностью переноса функционала дефрагментации в stable-ветку, но посмотри как пойдут дела.

********************************************************************************

## v0.13.10 "Блеск Славы" (Gloss of Glory) от 2025-12-17

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в память о Майкле Глоссе (Michael Alexander Gloss, American, son of Deputy Director of the CIA) героически погибшем в поисках справедливости за светлые идеалы человечества и посмертно награждённом Орденом Мужества.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.

Важное:

 - Проект _libmdbx_ полностью перемещен в юрисдикцию Российской Федерации.
   Пожалуйста обращайтесь на https://libmdbx.dqdkfa.ru за документацией и на https://sourcecraft.dev/dqdkfa/libmdbx за исходным кодом (он по-прежнему открыт и обеспечен первоклассной бесплатной поддержкой).

 - Каких-либо существенных ошибок/недочетов влияющих на стабильность и/или эксплуатационные качества не обнаружено.

Исправления:

 - Устранение предупреждения "unused function 'osal_yield()'" от новых версий CLANG при сборке амальгамированного исходного кода и при компиляции в режиме одного объектного модуля.

 - Для Linux добавлено предотвращение проявления ошибки в реализации fast_commit файловой системы Ext4.

 - Устранено падение при выполнении Thread-Local-Storage конструкторов при выгрузке библиотеки и наличия экземпляров env, инициализация которых не была завершена.

 - На Windows устранена причина возврата неожиданной ошибки `ERROR_IO_PENDING` в сценариях множественного открытия одной БД в одном процессе.

 - Исправлен недочёт автоподстройки параметров при установке геометрии с заданным минимальным размером страницы, из-за которого на машинах с большим количеством ОЗУ размер страницы мог увеличиваться.

 - В CMake-скриптах устранён регресс, из-за которого инфраструктура `ctest` не использовала задаваемые параметры Valgrind, в том числе `MEMORYCHECK_SUPPRESSIONS_FILE`.
   Теперь использование `ctest -D ExperimentalMemCheck` не приводит к множественной ложно-положительной диагностики. Однако, для использования Valgrind по-прежнему необходимо собирать библиотеку с предопределением макроcа `ENABLE_MEMCHECK`.

 - В тестах устранено несколько несущественных утечек памяти и предупреждение UBSAN о вызове `memcmp(, length = 0)`.

Прочие доработки:

 - Переработка реализации буферов и другие доработки в C++ API.

 - Для предотвращения неожиданных ошибок при сборке, в CMake-скрипты добавлена очистка исходного кода от файлов с именами совпадающими с генерируемыми в сборочной директории.

 - Устранено ложное предупреждение некоторых компиляторов о возможном использовании неинициализированной переменной внутри `env::get_path()`.

 - Во внутренней информации о сборке обеспечена поддержка сведений о RISC-V и Harmony OS.

 - Расширен набор тестов, cmake-тесты дополнены сценариями запуска `mdbx_copy`.

 - При сборке посредством GNU Make и CMake теперь, вместо одного `config.h`, генерируются разные файлы `config-gnumake.h` и `config-cmake.h`.

--------------------------------------------------------------------------------

## v0.13.9 "ИС-2" (IS-2) от 2025-10-31

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов.
Выпуск назван в память о cамом мощном тяжелом советском танке ["ИС-2"](https://ru.ruwiki.ru/wiki/ИС-2), который был принят на вооружение
31 октября 1943 года в разгар Великой Отечественной Войны и долгое время оставался одной из сильнейших машин мира в категории по массе 40—50 тонн.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.

Исправления:

 - Исправлена assert-проверка в пути сканирования битовой карты DBI-дескрипторов приводившая к редким падениям 32-битных отладочных сборок.

 - Переделан поиск утилит `lib.exe` и `dlltool.exe` при сборке посредством CMake на Windows.

 - Устранён регресс проявлявшийся увеличением (не-уменьшением) размера БД, после добавления использования `fallocate()`
   ради предотвращения SIGBUS при нехватке места в файловой системе где расположена БД.

 - Устранена опечатка в тестовом скрипте `test/battery-tmux.sh` приводящая к созданию мусорного файла с именем `-`.

 - Удалено лишнее/ненужное использование макроса `MDBX_INTERNAL` оставшееся после рефакторинга.

 - Для Android добавлен обход (workaround) для уменьшения вероятности системной ошибки `EAGAIN` возникающей
   из-за нехватки системных ресурсов и переходных процессов при закрытии и быстром повторном открытии БД.

Прочие доработки:

 - Поддержка Harmony OS (OHOS).

--------------------------------------------------------------------------------

## v0.13.8 "Всеобуч" (v`seabooch) от 2025-08-31

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в день 100 летнего юбилея Постановления Всероссийского центрального исполнительного комитета о всеобщем бесплатном начальном образовании.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.

Исправления:

 - Устранена возможность получения неожиданного `SIGBUS` из-за отложенного/ленивого выделение места в заполненной файловой системе после приращения файла БД.
   Более подробное пояснение в комментарии коммита [`2930b304dc674bbccd188b7ce7c3f83755ef706e`](https://gitflic.ru/project/erthink/libmdbx/commit/2930b304dc674bbccd188b7ce7c3f83755ef706e).

Изменение поведения:

 - Вновь включена/разрешена на старых ядрах Linux, начиная с версии 3.16, так как
   сейчас уже нет причин отказываться от работы на 3.16 поддерживая при этом ядра 4.x,
   и еще есть проекты (Isar, Isar-Community, Hive) которым требуется такая поддержка.

 - Ошибка `MDBX_WANNA_RECOVERY` при открытии БД в режиме только-чтение теперь возвращается если размер БД не кратен размеру системной страницы,
   но игнорируется не кратность размеру блока выделения виртуальной памяти.
   Этим устраняется регресс, проявившейся вследствие изменения поведения после задействования
   системного вызова `fallocate()` для предотвращения `SIGBUS` после приращения файла БД в заполненной файловой системе.

--------------------------------------------------------------------------------

## v0.13.7 "Дружба" (Friendship) от 2025-07-30.

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в [международный день дружбы](https://www.un.org/ru/observances/friendship-day).

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Артёму Воротникову](https://github.com/vorot93) за сообщение об ошибках и тестировании [призязок для Rust](https://github.com/vorot93/libmdbx-rs).

Исправления:

 - Устранена критическая ошибка в функционале `mdbx_env_resurrect_after_fork()` при использовании SysV-семафоров.

   Проявлялась ошибка только после порождения дочернего процесса посредством `fork()` на фоне выполняющейся пишущей транзакции, что
   приводило к неверной работе семафоров и далее к самым различным ошибкам, вплоть до повреждения БД. Проблема существовала начиная с появления
   `mdbx_env_resurrect_after_fork()` и затрагивала OSX, а также POSIX-платформы при сборке с опцией `MDBX_LOCKING=5`.

 - Устранена проблема в API копирования БД на отличных от Linux системах POSIX,
   а также в некоторых случаях при расположении целевого файла на не-локальной файловой системе.
   Проблема проявлялась в основном на OSX, возвратом ошибки `EWOULDBLOCK`/`EAGAIN` (35),
   что обусловлено недочетом/конфликтом блокировок `fcntl(F_SETLK)` и `flock()` в ядре ОС.
   Переработана обработка ошибок захвата файловых блокировок в API копирования на системах POSIX.

 - Устранена ошибка приводившая к неожиданному возврату `MDBX_BAD_DBI` при одновременном старте нескольких транзакций внутри одного процесса после открытия БД.

 - Устранена ошибка приводившая к неожиданному возврату `MDBX_DBS_FULL` при повторном открытии уже открытых таблиц и уже достигнутом лимите открытых DBI-дескрипторов.

 - Исправлена ошибка сборки для платформы Android при явном определении `_FILE_OFFSET_BITS`.

 - Исправлена ошибка использования `ENOMEM` вместо `MDBX_ENOMEM`.
   Что могло ломать сборку на не-POSIX/Windows платформах, в зависимости от конфигурации и/или версии SDK.

 - Поправлено либо удалено несколько неверных assert-проверок, из-за которых происходили падения отладочных сборок в специфических ситуациях.
   Главным образом, в коде функций `txn_end()`, `txn_lock()` и `txn_unlock()` как на Windows, так и на POSIX.

 - Устранены несущественные предупреждения MSVC. Отключены предупреждения `C5286` и `C5287`.

Прочие доработки:

 - Доработана логика отказа от использования OFD-блокировок на POSIX-платформах.
   Теперь кроме `EINVAL` учитываются дополнительные коды ошибок (`ENOSYS`, `ENOIMPL`, `ENOTSUP`, `ENOSUPP`, `EOPNOTSUPP`),
   что позволит работать собранной библиотеке в некоторых случаях,
   когда актуальное ядро/контейнер/эмулятор не поддерживает требуемых системных вызовов.

 - В тестовый фреймворк добавлена поддержка опции --numa # для привязки стохастического теста к NUMA-узлу,
   а в battery/tmux-скрипте добавлено явное распределение по NUMA-узлам, что существенно увеличило КПД
   при тестировании на NUMA-машинах.

 - В стохастическом скрипте реализован случайный порядок запуска отдельных тестов.

--------------------------------------------------------------------------------

## v0.13.6 "Бузина" от 2025-04-22

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в память о погибшем украинском историке и писателе [Алесе Бузине](https://ru.ruwiki.ru/wiki/Бузина,_Олесь_Алексеевич).

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Илье Михееву](https://t.me/IlyaMkhv) и команде [Erigon](https://github.com/erigontech) за сообщения о проблеме и тестирование.
 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения о проблеме копирования на NFS.

Исправления:

 - Устранён регресс при использовании курсоров для DBI=0 (aka GC/FreeDB) в читающих транзакциях.

   После рефакторинга и ряда оптимизаций для завершения/гашения
   курсоров в читающих и пишущих транзакций, стал использоваться общий код.
   Причем за основу, был взят соответствующий фрагмент относящийся к
   пишущим транзакциям, в которых пользователю не позволяется
   использоваться курсоры для DBI=0 и поэтому эта итераций пропускалась.

   В результате, при завершении читающих транзакциях, курсоры связанные с
   DBI=0 не завершались должным образом, а при их повторном использовании
   или явном закрытии после завершения читающей транзакции происходило
   обращение к уже освобожденной памяти. Если же такие курсоры
   отсоединялись или закрывались до завершения читающей транзакции, то
   ошибка не имела шансов на проявление.

 - Устранён регресс в виде ошибки `EAGAIN` при копировании БД на NFS и CIFS/SMB.

   При доработках/развитии API в функции копирования был добавлен захват
   файловой блокировки посредством как `fcntl()`, так и `flock()`. Однако,
   в зависимости от версии локального ядра, версии удалённого сервера NFS и
   опций монтирования, это могло приводить к возврату POSIX-ошибки `EAGAIN`
   (`11` на большинстве платформ, включая Linux).

 - Устранена ошибка merge/rebase внутри `mdbx_txn_release_all_cursors_ex()`,
   что могло приводить к последующим неожиданным ошибкам `MDBX_EBADSIGN` и утечкам памяти.
   Для проверки сценария дополнен соответствующий тест.

 - Исправлена assert-проверка в пути завершения вложенных транзакций.
   Для проверки сценария дополнен соответствующий тест.

 - Устранена возможность возврата неожиданной ошибки `MDBX_BUSY` из `mdbx_txn_lock(dont_wait=false)`.

 - Для совместимости с GCC 15.x в режиме C23 изменен порядок указания атрибутов функций.

Изменение поведения:

 - При невозможности отвязки курсора от его текущей транзакции функция `mdbx_cursor_bind()`
   теперь возвращает `MDBX_EINVAL` вместо `MDBX_BAD_TXN`.

Прочие доработки:

 - Во избежание потенциальных проблем отключено использование `copy_file_range()` на ядрах Linux 5.3 - 5.18.

 - Вброс `std::invalid_argument` теперь производится явным сообщением `MDBX_EINVAL`.

 - Уточнен тип адреса для пожертвований.
   Ethereum/ERC-20 позволяет перечислять не только ETH, но и другие валюты/токены, в том числе USDC.

 - Дополнен тест курсоров extra/cursor-closing.

 - В `NOTICE` обновлена информация о Github.

--------------------------------------------------------------------------------

## v0.13.5 "Труба" от 2025-03-21

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Илье Михееву](https://t.me/IlyaMkhv) за сообщения о недочетах и тестирование.
 - [Alex Sharov](https://github.com/AskAlexSharov) за сообщение об ошибках и тестирование.
 - [maxc0d3r](https://gitflic.ru/user/maxc0d3r) for bug reporting and testing.
 - [Alain Picard](https://github.com/castortech) for support [Java bindings](https://github.com/castortech/mdbxjni) and MacOS universal binaries patch for CMake build scenario,
   also for bug reporting (put-`MDBX_MULTIPLE` regression). Big thank for assistance with debugging and testing.

Новое:

 - Добавлена опция сборки `MDBX_ENABLE_NON_READONLY_EXPORT` позволяющая использовать в режиме чтения-записи БД расположенных в файловых системах экспортированных через NFS.
   По-умолчанию опция выключена и при открытии в неэксклюзивном режиме чтения-записи БД расположенных  файловых системах доступных извне по NFS будет возвращаться ошибка `MDBX_EREMOTE`.
   Включение опции позволяет открывать БД в описанных выше ситуациях, но риск чтения неверных данных на удалённой стороне ложится на пользователя.

 - Поддержка MacOS universal binaries при сборке посредством CMake.

 - Для закрытия или отсоединения всех курсоров с получением их количества в API добавлена функция `mdbx_txn_release_all_cursors_ex()`.

 - Добавлена операция `MDBX_SEEK_AND_GET_MULTIPLE` в API курсора, позволяющая за одну операцию выполнить позиционирование
   курсора на конкретное значение и начать чтение multi-значений в пакетном режиме.

 - Добавлены методы `mdbx::cursor::put_multiple_samelength()`, `mdbx::cursor::seek_multiple_samelength()`, `mdbx::cursor_managed::withdraw_handle()`.

 - В политику управления выделением для `mdbx::buffer<ALLOCATOR, CAPACITY_POLICY>` добавлен параметр `inplace_storage_size_rounding`.
   Одновременно с этим переработан внутренний union-тип `mdbx::buffer<ALLOCATOR, CAPACITY_POLICY>::silo::bin` для возможности увеличения без пенальти встроенного в экземпляр буфера места под данные.

 - В API добавлена функция `mdbx_cursor_close2()` возвращающая код ошибки.

Исправления:

 - Устранение лишнего/ненужного предупреждения в сценарии изменения размера БД посредством вызова `mdbx_env_set_geometry()` до её открытия.
   API предусматривает возможность запросить изменение геометрии/размера БД перед её открытием, чтобы избежать как лишних накладных расходов,
   так и потенциальных ошибок из-за нехватки адресного пространства. В этом сценарии ранее могло выдаваться лишнее/ненужное предупреждение
   о несоответствии файла БД новому размеру. Теперь этот недостаток исправлен.

 - Восстановлена доступность дескрипторов таблиц, открытых в дочерней транзакции, после её фиксации, в случае отсутствия изменений в данных.
   Проблема не была замечена ранее из-за специфического сценария проявления.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранён сбой аудита таблиц при инвалидации дескрипторов таблиц вследствие отмены вложенной транзакции.
   Проблема не была замечена ранее из-за специфического сценария проявления.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранена причина потенциальных сбоев и/и деградации производительности в сценарии закрытия курсора до завершения вложенной транзакции,
   с последующим изменением данных той-же таблицы в текущей вложенной транзакции, либо её дочерних транзакциях.
   Проблема обнаружена при ручном анализе кода, сценарии воспроизведения/проявления проблемы пока не известны.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `3de3d425a128a3c6f7866503f5f93b80c09dbe41` от 2024-05-19.

 - Устранена причина ложных ошибок при работе `mdbx_chk` с высоким уровнем логирования.
   Проблема возникала из-за неверной трактовки `MDBX_NOTFOUND` при штатном окончании итерируемых данных.

 - Устранена причина попыток рекурсивного захвата мьютекса при работе `mdbx_chk -w` в сборах с поддержкой Valring/ASAN и под управлением этих инструментов.

 - Устранены проверки потока владеющего транзакцией при сборке с опцией `MDBX_TXN_CHECKOWNER=OFF`.

 - Устранена вероятность ситуации гонки в `tbl_setup(MDBX_DUPFIXED | MDBX_INTEGERDUP)` при работе в разных потоках.
   В реальных сценариях вероятность проявления проблемы была близка к нулю.
   Для подробностей смотрите комментарий коммита `3e91500fac475947f5b58268d5edd3c9cc4f77f6`.

 - Устранён регресс затенения курсоров во вложенных транзакциях.
   При реализации отложенной/ленивой инициализации dbi-дескрипторов также было реализовано отложенное затенение курсоров (создание копии состояния для отката при прерывании транзакции),
   что существенно уменьшало накладные расходы при старте и завершении вложенных транзакций в сценариях с большим количеством курсоров.
   Однако, была допущена логическая ошибка, вследствие которой отложенная инициализация и затенение выполнялись при использовании dbi-дескрипторов, но не курсора открытого в родительской транзакции.
   В результате, родительские курсоры во вложенных транзакциях могли не затеняться, что приводило к неконсистентному состоянию в случае
   прерывания/откате вложенной транзакции и в соответствующей таблицы были изменения в рамках прерванной вложенной транзакции.
   Проблема не реализовывалась в тестовых сценариях и не была замечена при эксплуатации, но была обнаружена при расширении тестов.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранён регресс в пути обработки операции `MDBX_MULTIPLE`.
   Пакетная вставка значений посредством `MDBX_MULTIPLE` могла приводить к падениям и повреждению структуры БД. Ошибка оставалось не
   замеченной из-за специфических условий проявления, которые не реализовались в тестах.
   Проблема присутствовала во всех выпусках начиная с v0.13.1, но соответствующая ошибка не связана с конкретным коммита в истории, а
   является следствием нескольких доработок (шагов рефакторинга), которые суммарно привели к регрессу.
   Технически ошибка обусловлена не-обнулением переменной, чего не происходило в некотором пути выполнения, так как исходно не требовалось.
   Однако, такое обнуление потребовалось после ряда этапов оптимизации и рефакторинга смежных участков кода.
   Для подробностей смотрите комментарий коммита `23a417fe19614481c6546845995d6dc845baf797`.

 - Скорректировано описание ошибки `MDBX_MVCC_RETARDED` и текста соответствующего сообщения.

 - В C++ API добавлена упущенная проверка `__cpp_concepts >= 202002` для использования концептов C++.

Изменение поведения:

 - Функция `mdbx_txn_release_all_cursors()` возвращает только код ошибки, не смешивая его с количеством обработанных/закрытых курсоров.
   Для аналогичных действий с получением количества закрытых курсоров в API добавлена функция `mdbx_txn_release_all_cursors_ex()`.

 - Использование системного кода ошибки `EREMOTEIO` ("Remote I/O error") вместо `ENOTBLK` ("Block device required") в качестве `MDBX_EREMOTE` для индикации ошибочной ситуации открытия БД расположенной на сетевом носителе.

 - Для основных вариантов использования шаблона `mdbx::buffer<>` теперь явно инстанцируются внутри библиотеки,
   одновременно соответствующие специализации шаблона помечены как `external` для предотвращения повторного инстанцирования в пользовательском коде.

 - Запрещена отвязка/открепление курсоров во вложенных транзакциях, т.е. вызовы `mdbx_cursor_unbind()` и
   `mdbx_txn_release_all_cursors(unbind=true)` для курсоров открытых в одной из родительских транзакций.
   Причина в том, что в случае отмены вложенной транзакции возникает неконструктивная неопределенность
   — следует ли восстанавливать состояние курсоров. Если не восстанавливать, то получается что вложенная транзакция может
   поломать родительскую, сделав её продолжение невозможным. Если восстанавливать, то также следует «воскрешать» закрытые
   курсоры, что неизбежно приведет к путанице, утечкам памяти и использованию после освобождения.

 - В C++ API отменён вброс исключения при запросе транзакции у отсоединённого курсора посредством вызова `mdbx::cursor::txn()`.

Прочие доработки:

 - Доработка использования LTO в CMake-сценариях: использование `-flto=auto` для GCC >= 11.4,
   расслабление условий для включения LTO для CLANG на Linux, расширение поиска `LLVMgold.so` в относительных lib-директориях.

 - Добавлены дополнительные проверки сигнатур курсоров при итерации связанных списков.

 - Кратное сокращение итераций тестов в зависимости от конфигурации Valgrind/Debug/CI.

 - Устранены предупреждения UBASN о невыравненном доступе в тесте extra/close-dbi.

 - Добавлен перехват и логирование исключений в extra-тестах на C++.

 - Расширены тесты extra/dupfix-multiple, extra/cursor-closing и extra/txn.

 - В утилиту тестирования добавлена поддержка режима/опции `MDBX_VALIDATION` и поддержка значений `on`/`off` для опций командной строки.

 - Добавлены doxygen-описания для doubtless-positioning констант.

 - Переработана проверка курсоров на входе в API-функций с добавлением `cursor_check()`, `cursor_reset()` и `cursor_drown()`.

 - Отключено использование C23 `[[атрибутов]]` для версий CLANG меньше 20.

--------------------------------------------------------------------------------

## v0.13.4 "Sigma Boy" от 2025-02-14

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов.

Благодарности:

 - [Erigon](https://docs.erigon.tech/) за спонсорство.
 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения об ошибках и недочетах.
 - [Alain Picard](https://github.com/castortech) for support [Java bindings](https://github.com/castortech/mdbxjni) and MacOS universal binaries patch for CMake build scenario.
 - [Alex Sharov](https://github.com/AskAlexSharov) за сообщение об ошибках и тестирование.
 - [Виктору Логунову](https://t.me/vl_username) за сообщение об опечатки в имени переменной в Conan-рецепте.

Новое:

 - Поддержка MacOS universal binaries при сборке посредством CMake.

Исправления:

 - Устранён регресс допускающий SIGSEGV в операциях обновления после вытеснения/spilling страниц в больших транзакциях.
   Ошибка присутствует в выпусках v0.13.1, v0.13.2, v0.13.3 и оставалась незамеченной из-за специфических условий и низкой вероятности проявления.
   Более подробная информация в описании коммита `21630ea115690a5cb39cfa921f9d199271a08102`.

 - Исправлена опечатка в документации в упоминании `mdbx_env_resurrect_after_fork()`.

 - Исправлена опечатка в условном операторе внутри `cursor_touch()`.
   При переделке курсоров было пропущено отрицание в условии, при оценке количества страниц, которые могут потребоваться для выполнения операции.
   В текущем понимании ошибка не приводила к каким-либо проблемам, ибо оценка делает по верхней границе с существенным запасом, а в худшем
   случае это могло приводить к прерыванию транзакции из-за достижения ограничения на кол-во грязных страниц.

 - Корректировка излишне строгого условия в assert-проверке внутри `recalculate_subpage_thresholds()`.
   Ошибка могла проявляться только в отладочных сборках при выставлении определенной комбинации предельных значений опций `MDBX_opt_subpage_limit`,
   `MDBX_opt_subpage_room_threshold`, `MDBX_opt_subpage_reserve_prereq`, `MDBX_opt_subpage_reserve_limit`.

 - Исправление опечатки в Conan-рецепте в коде протокольно-отладочного вывода в имени переменной `version_json_pathname`.

--------------------------------------------------------------------------------

## v0.13.3 "Королёв" от 2025-01-12

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов
в день рождения и в память об [Серге́е Па́вловиче Королёве](https://ru.wikipedia.org/wiki/Королёв,_Сергей_Павлович),
советском учёном и Главном конструкторе ракетно-космических систем.

Одновременно с этим релизом:

 - Ветка `0.12.x` перестаёт поддерживаться и отправляется в `архив/0.12`.
 - Ветка `0.13.x` получает статус стабильной и вливается в `stable`.

Благодарности:

 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения об ошибках и недочетах.
 - [Erigon](https://docs.erigon.tech/) за спонсорство.
 - [Lazymio](https://github.com/wtdcode) за новые [привязки к Python](https://pypi.org/project/libmdbx/).

Новое:

 - В C API добавлена функция `mdbx_cursor_count_ex()` позволяющая получить как количество мульти-значений
   соответствующих текущему ключу, так и информацию о вложенном дереве хранящем эти значения.

 - В C++ API добавлен метод `mdbx::txn::make_broken()` аналогичный `mdbx_txn_break()`.

 - В утилиты mdbx_copy, mdbx_drop, mdbx_dump, mdbx_load, mdbx_stat добавлено логирование ошибок,
   предупреждений и важных сообщений от libmdbx.

Исправления:

 - Устранён регресс неразблокировки мьютекса при попытки повторного закрытия dbi-дескриптора,
   в том числе при попытке явно закрыть дескриптор после удаления связанной с ним таблицы.

   Вместо возврата ошибки `MDBX_BAD_DBI` происходил выход из тела функции по успешному пути,
   но без освобождения захваченной блокировки.
   Ошибка была внесена 2024-10-23 коммитом `3049bb87b5b14d83b16d121c186ce8fb3f21383e`.

 - Устранён регресс состояния вложенного/dupsort курсора после вставки данных в `MDBX_APPEND`-режиме.

   При добавлении нового ключа в append-режиме, в случае когда в текущей
   (последней) позиции с ключом связаны несколько значений и
   (соответственно) вложенный dupsort-курсор инициализирован, вставка
   происходила без сброса вложенного курсора.

   В результате вложенный курсор логически оставался стоять на
   multivalue-данных связанных с предыдущей позицией основного курсора,
   т.е. переходил в неконсистентное состояние.

   Ошибка проявлялась возвратом неверных значений из `mdbx_cursor_count()`
   или срабатывание assert-проверки в отладочных сборках.

 - Поддержка получения boot_id при работе внутри LXC-контейнера.

   Из LXC-контейнера не доступен файл хостовой системы `/proc/sys/kernel/random/boot_id`.
   Вместо него, при каждом старте контейнера, создается и заполняется
   случайными данными собственный boot_id смонтированный через bind из `tmpfs`.
   https://github.com/lxc/lxc/issues/3027

   Ранее этот подставной/замещенный boot_id отбраковывался внутри libmdbx,
   так как файл располагается в `tmpfs`, а не в файловой системе `/proc`.
   В результате boot_id для проверки целостности БД не был доступен.
   Теперь при работе внутри LXC-контейнера такой bootid будет использоваться.

   Однако, полноценно работающий контроль по boot_id не возможен, так как при
   рестарте LXC-контейнера (но не хоста) boot_id будет меняться, хотя
   данные в unified page cache сохраняются.

   Таким образом, при рестарте LXC-контейнера без рестарта хоста, libmdbx придется
   откатить состояние БД до крайней точки устойчивой фиксации, что повлечет
   утрату данных пользователя в случаях когда они могли быть сохранены.
   Однако, улучшить ситуацию пока не представляется возможным, как минимум
   до доступности boot_id хостовой системы изнутри LXC-контейнера.

 - Устранена ошибка неверной обработки попытки запуска вложенной читающей транзакции.
   Теперь в таких ситуациях возвращается ошибка `MDBX_EINVAL`, так как вложенность
   поддерживается только для транзакций чтения-записи.

   Ошибка была внесена при рефакторинге, коммитом `2f2df1ee76ab137ee66d00af69a82a30dc0d6deb`
   чуть более 5 лет назад и долго оставалось не замеченной.

 - Устранён SIGSEGV-регресс обращения к нулевому адресу при работе в режиме только-чтение без использования LCK-файла,
   например при размещении БД на носителе доступном только для чтения.

   Ошибка была внесена при реализации функционала парковки читающих транзакций.

Изменение поведения:

 - Теперь при включении профилирования GC (сборка с опцией `MDBX_ENABLE_PROFGC=ON`)
   подсчитываются затраты времени ЦПУ на слияние списков страниц, т.е. на работу функции `pnl_merge()`.

 - В утилите тестирования значение режима данных переименовано из `data.dups` в `data.multi`.

 - Доработан контроль длины ключа внутри `cursor_seek()`.

   Ранее проверка внутри `cursor_seek()` не позволяла искать ключи длиннее, чем можно поместить в таблицу.
   Однако, при поиске/позиционировании это не является ошибкой для таблиц с ключами переменного размера.

 - Если посредством `mdbx_env_set_option(MDBX_opt_txn_dp_limit)` пользователем не задано собственно значение,
   то теперь выполняется подстройка dirty-pages-limit при старте каждой не-вложенной пишущей транзакций,
   исходя из объёма доступного ОЗУ и размера БД.

 - Теперь в режиме `MDBX_NOSTICKYTHREADS` допускается commit/abort вложенных транзакций из любого треда/потока.

 - Теперь при попытке запуска вложенных транзакций в режиме `MDBX_WRITEMAP` производится
   логирование и возврат ошибки `MDBX_INCOMPATIBLE`.

 - Теперь в C++ API в конструкторах/инициализаторах и методах связанных с формированием геометрии БД
   по-умолчанию используются только `default`-значений, в том числа для минимального и максимального
   размера. В результате, при создании БД с геометрией по-умолчанию не происходит выбор максимального
   размера страницы из-за очень большого максимального размера БД.

 - Внутри `mdbx_env_set_geometry()` доработаны эвристики для подбора параметров геометрии БД запрошенных пользователем "по-умолчанию".

--------------------------------------------------------------------------------

## v0.13.2 "Прошлогодний Снег" (Last Year's Snow) от 2024-12-11

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов
в день рождения и в память об [Алекса́ндре Миха́йловиче Тата́рском](https://ru.wikipedia.org/wiki/Татарский,_Александр_Михайлович),
российском режиссёре-мультипликаторе, создавшем такие знаменитые
мультфильмы как "Падал прошлогодний снег", "Пластилиновая ворона",
заставку "Спокойной ночи, малыши!" и многие другие шедевры нашего
детства.

Новое:

 - Ускорено обновление GC при возврате/помещении списков страниц в
   сложных сценариях. Был доработан и активирован ранее отключенный
   экспериментальный режим корректирующей обратной связи. Этим
   принципиально улучшилась сходимость (сократилось количество повторных
   попыток), а также устранен дефект приводящий к "зацикливанию" при
   фиксации транзакций (с возвратом ошибки `MDBX_PROBLEM`) в редких
   специфических условиях.
   Подробности см. в описании коммита [`6c56ed97bbd8ca46abac61886a113ba31e5f1291`](https://gitflic.ru/project/erthink/libmdbx/commit/6c56ed97bbd8ca46abac61886a113ba31e5f1291).
 - Включен стандарт `C23` в CMake-скриптах сборки.
 - Добавлены T-макросы для парных `char`/`wchar_t` функций.
 - Поддержка вложенных пишущих транзакций в C++ API.
 - Переход на "Semantic Versioning 2" и экспорт информации о версии в `VERSION.json`.
 - Добавлена поддержка переменной среды `SOURCE_DATE_EPOCH` для воспроизводимости сборок.
   Прежний способ посредством `MDBX_BUILD_TIMESTAMP` также работает и имеет приоритет.
 - Добавлена возможность указывать дополнительную информацию о сборке
   libmdbx через опцию `MDBX_BUILD_METADATA`. Сейчас задаваемая информация
   просто включается внутрь библиотеки в качестве значения
   `mdbx_build.metadata`, а в дальнейшем также будет использоваться при
   формировании пакетов и т.п.
 - Добавлено логирование ошибок возвращаемых из API. Теперь для этого
   достаточно задать уровень логирования `MDBX_LOG_DEBUG` (для логирования
   ошибок за вычетом `MDBX_NOTFOUND`) или `MDBX_LOG_TRACE` (для логирования
   всех ошибок, а также `MDBX_RESULT_TRUE`).
 - Поддержка сборки посредством Conan.

Изменение поведения:

 - Добавлен метод `mdbx::cursor::get_multiple_samelength()` и
   переименован `mdbx::txn::put_multiple_samelength()`.
 - Для единообразия C++ API при выполнении операции `MDBX_GET_MULTIPLE`
   теперь также возвращается значение самого ключа.
 - Для размерных констант `mdbx::env::geometry` базовый тип изменен с
   беззнакового `size_t` на знаковый `intptr_t`.
 - Теперь выбор в пользу использования ntdll вместо CRT делается только
   при явном отключении C++ API.
 - Теперь выполняется освобождение памяти сброшенных/прерванных читающих
   транзакций передаваемых в `mdbx_txn_commit()`. Соглашение по API требует
   чтобы такие транзакции освобождались посредством `mdbx_txn_abort()`,
   из-за чего функция `mdbx_txn_commit()` возвращала ошибку в таких
   случаях, не разрушая сами транзакции. Это приводило к утечкам памяти
   из-за ошибок в приложениях, что побудило изменить поведение.
 - Использование макроса `__deprecated_enum` если он определен.
 - При сборке посредством CMake выбор стандарта языка `C` теперь
   выполняется с учётом `CMAKE_C_STANDARD`.
 - Изменения в опциях сборки:
   * опция `MDBX_OSX_SPEED_INSTEADOF_DURABILITY` переименована в
     `MDBX_APPLE_SPEED_INSTEADOF_DURABILITY`, так как актуальна для всех
     "Яблочных" платформ;
   * опция `MDBX_MMAP_USE_MS_ASYNC` переименована в
     `MDBX_MMAP_NEEDS_JOLT`, для более точного соответствия своей семантики;
   * в CMake добавлена поддержка опции `MDBX_USE_MINCORE`;
   * использование `madvise()` и родственных системных вызовов теперь
     всегда включено, а опция `MDBX_ENABLE_MADVISE` удалена;
   * удалены неиспользуемая опция `MDBX_USE_SYNCFILERANGE` и
     неиспользуемый режим `MDBX_LOCKING_BENAPHORE`.

Исправления:

 - Устранен регресс возврата неверной информации из функций
   `mdbx_env_stat_ex()` и `mdbx_env_stat()`. При рефакторинге до выпуска
   v0.13.1 была допущена ошибка, из-за которой выполнялось суммирование
   значений без очистки переданного пользователем буфера для результата.
   Таким образом, возвращаемая информация была верной, только если память
   используемая для размещения результата содержала нули на момент вызова
   функции.
 - Функция `mdbx_close_dbi()` доработана для возврата ошибки `MDBX_DANGLING_DBI`
   при попытке закрыть dbi-дескриптор таблицы, созданной и/или измененной в
   ещё выполняющейся транзакции. Такое преждевременное закрытие дескриптора
   является неверным использованием API и нарушением контракта/предусловий
   сформулированных в описании `mdbx_close_dbi()`. Однако, вместо возврата
   ошибки выполнялось некорректное закрытие дескриптора, что могло
   приводить к созданию таблицы с пустым именем, утечки страниц БД и/или
   нарушению структуры b-tree (неверной ссылкой на корень таблицы).
 - Исправлено открытие таблицы с пустым/нулевым именем, в том числе устранена
   возможность `SIGSEGV` при закрытии её дескриптора.
 - Добавлены упущенные inline-реализации `mdbx::cursor::upper_bound()` и `mdbx::cursor::upper_bound_multivalue()`.
 - Продолжена корректировка описания С++ API для использования термина "таблица" вместо "sub-database".
 - Исправлено проверяемое условие внутри `assert()` в пути обработки `MDBX_GET/NEXT/PREV_MULTIPLE`.
 - На 32-битных платформах разрешено использовать 4-байтное выравнивание при получении 64-битных значений посредством `MDBX_MULTIPLE`.
 - Добавлен костыль для устранения проблем из-за некорректной обработки `[[gnu::pure]]` в Apple Clang и MSVC.
 - Поправлено определение `MDBX_DEPRECATED_ENUM` для старых компиляторов при включении С++11.
 - Доработано использование `std::experimental::filesystem` для решения проблем со сборкой в старых компиляторах.
 - Исправлена обработка `MDBX_GET_MULTIPLE` в специальных случаях и одного значения у ключа в позиции курсора.
 - Исправление сборки при включении профилирования GC и `MDBX_ENABLE_DBI_SPARSE=OFF`.

Мелочи:

 - Теперь `MDBX_ENABLE_BIGFOOT` включена по-умолчанию вне зависимости от разрядности платформы.
 - Дополнение README и исправление опечаток/орфографии.
 - Использование `WIN32` вместо `${CMAKE_SYSTEM_NAME}`.
 - Подавление параноидальных предупреждений MSVC в extra-тестах.
 - Дополнение отладочного логирования внутри `dxb_resize()`.
 - Добавление в сценарии CMake/CTest копирования dll под  Windows для работы исключений в тестах на C++.
 - Добавление С++ теста `extra/open`.
 - Доработка `osal_jitter()` для уменьшения задержек в тестах под Windows.
 - Исправление максимальной длины значений в тесте `extra/crunched-delete`.
 - Добавление логирования С++ исключений в `extra/dupfix_multiple`.
 - Корректировка API-макросов для Doxygen.
 - Уточнение описания `mdbx_dbi_close()` для случая хендлов измененных таблиц.
 - Добавление теста `extra/early_close_dbi`.
 - Доработка скрипта стохастического теста и его переименование в `stochastic.sh`.
 - Доработка тестов для совместимости с режимами сборки до С++17.
 - Добавление `.WAIT` для устранения коллизий при распараллеливании сборки посредстом GNU Make 4.4.

--------------------------------------------------------------------------------

## v0.13.1 "РДС-1" от 2024-08-29

Новая версия со сменой лицензии, существенным расширением API,
добавлением функционала и внутренними переработками. В том числе,
с незначительным нарушением обратной совместимости API библиотеки.

Новое:

 - Изменение лицензии на Apache 2.0, пояснения и подробности в файле `COPYRIGHT`.

 - Реструктуризация исходного кода с рефакторингом.

 - Переработка курсоров для унификации поведения, более регулярного
   кода, уменьшения количества ветвлений и машинных операций.

 - Перенос функционала утилиты `mdbx_chk` внутрь библиотеки в виде
   функции `mdbx_env_chk() `для проверка целостности структуры БД, в том
   числе с вовлечением логики приложения.

 - Опция `MDBX_opt_gc_time_limit` для более гибкого контроля времени
   расходуемого на поиск последовательностей соседствующих свободных
   страниц в GC.

 - Снижение накладных расходов на запуск транзакций в сценариях с
   большим количеством DBI-хендов, за счет отложенной/ленивой инициализации
   элементов служебных таблиц. В том числе, механизм поддержки разреженных
   наборов DBI-хендов, управляемый опцией сборки `MDBX_ENABLE_DBI_SPARSE`,
   которая включена по-умолчанию.

 - Снижение накладных расходов на открытие DBI-хендов. В том числе,
   механизм отложенного освобождения и поддержки быстрого пути открытия без
   использования блокировок, управляемый опцией сборки
   `MDBX_ENABLE_DBI_LOCKFREE`, которая включена по-умолчанию.

 - Поддержка "парковки" читающих транзакций с их вытеснением ради
   переработки старых MVCC-снимков и предотвращения проблем вызываемых
   приостановкой переработки мусора. Механизм парковки и вытеснения
   припаркованных транзакций является как дополнением, так и более простой
   в использовании альтернативой обратному вызову
   [Handle-Slow-Readers](https://libmdbx.dqdkfa.ru/group__c__err.html#ga2cb11b56414c282fe06dd942ae6cade6).
   Для удобства функции `mdbx_txn_park()` и `mdbx_txn_unpark()` имеют
   дополнительные аргументы, позволяющие запросить автоматическую
   "распарковку" припаркованных и перезапуск вытесненных транзакций.

 - Расширение API позиционирования курсоров более удобными и очевидными
   операциями по аналогии условиям `<`, `<=`, `==`, `>=`, `>` как для
   ключей, так и для пар ключ-значение.

 - Функции `mdbx_dbi_rename()` и `mdbx_dbi_rename2()` для переименования таблиц.

 - Функции `mdbx_cursor_unbind()` и `mdbx_txn_release_all_cursors()` для
   гибкого управления курсорами в сценариях повторного использования для
   уменьшения накладных расходов.

 - Функция `mdbx_env_resurrect_after_fork()` для восстановление открытой
   среды работы с БД в дочернем процессе после ветвления/расщепления
   процесса.

 - Функция `mdbx_cursor_compare()` для сравнения позиций курсоров
   аналогично оператору `<=>`.

 - Функции `mdbx_cursor_scan()` и `mdbx_cursor_scan_from()` для
   сканирования таблиц с использованием функционального предиката и
   уменьшением сопутствующих накладных расходов.

 - Функции `mdbx_cursor_on_first_dup()` и `mdbx_cursor_on_last_dup()`
   для оценки позиции курсора.

 - Функция `mdbx_preopen_snapinfo()` для получения информации о БД без
   её открытия.

 - Функция `mdbx_enumerate_tables()` для получение информации
   об именованных пользовательских таблицах.

 - Поддержка функций логирования обратного вызова без функционала
   `vprintf()`, что существенно облегчает использование логирования в
   привязках к другим языкам программирования.

 - Режим работы `MDBX_NOSTICKYTHREADS` вместо `MDBX_NOTLS` для упрощения
   интеграции с легковесными потоками/нитями их мультиплексирования вместе
   с транзакциями по потокам операционной системы.

 - Опция `MDBX_opt_prefer_waf_insteadof_balance`.

 - Опции `MDBX_opt_subpage_limit`, `MDBX_opt_subpage_room_threshold`,
   `MDBX_opt_subpage_reserve_prereq`, `MDBX_opt_subpage_reserve_limit`.

 - Управление основной блокировкой lock/unlock/upgrade/downgrade для координации пишущих транзакций.

 - Функции `mdbx_limits_keysize_min()` и `mdbx_limits_valsize_min()` для
   получения нижней границы длины ключей и значений.

 - Для идентификации БД добавлен UUID доступный в поле `mi_dxbid` структуры `MDBX_envinfo`,
   получаемой посредством `mdbx_env_info_ex()`.

 - Расширение API функциями lock/unlock/upgrade/downgrade основной блокировки.

 - Добавление в API функций `mdbx_cursor_unbind()` и `mdbx_txn_release_all_cursors()`.

 - Добавление в API функций `mdbx_txn_copy2pathname()` и `mdbx_txn_copy2fd()`.

 - Добавление в утилиту `mdbx_copy` опций `-d` и `-p`.

 - Расширение и доработка C++ API:

     - добавлен тип `mdbx::cursor::estimate_result`, а поведение методов
      `mdbx::cursor::estimate()` унифицировано с `mdbx::cursor::move()`;
     - для предотвращения незаметного неверного использования API, для инициализации
       возвращаемых по ссылке срезов, вместо пустых срезов задействован `mdbx::slice::invalid()`;
     - добавлены дополнительные C++ операторы преобразования к типам C API;
     - для совместимости со старыми стандартами C++ и старыми версиями STL перенесены
       в public классы `mdbx::buffer::move_assign_alloc` и `mdbx::buffer::copy_assign_alloc`;
     - добавлен тип `mdbx::default_buffer`;
     - для срезов и буферов добавлены методы `mdbx::buffer::hex_decode()`, `mdbx::buffer::base64_decode()`, `mdbx::buffer::base58_decode()`;
     - добавлен тип `mdbx::comparator` и функций `mdbx::default_comparator()`;
     - добавлены статические методы `mdbx::buffer::hex()`, `mdbx::buffer::base64()`, `mdbx::buffer::base58()`;
     - для транзакций и курсоров добавлены методы `get_/set_context`;
     - добавлен метод `mdbx::cursor::clone()`;
     - поддержка base58 переработана и приведена в соответствии с черновиком RFC,
       в текущем понимании теперь это одна из самых высокопроизводительных реализаций base58;
     - переработка `to_hex()` и `from_hex()`;
     - добавлены перегрузи со `std::string_view` для методов `open_map`/`create_map`/`drop_map`/`clear_map`/`rename_map()`;
     - добавлены перегрузки методов put/insert/upsert для `mdbx::pair`;
     - добавлены методы принимающие имена таблиц/subDb через `mdbx::slice`.

Нарушение совместимости:

 - Использование термина "таблица" вместо "subDb".
 - Опция `MDBX_COALESCE` объявлена устаревшей, так как соответствующий функционал всегда включен начиная с предыдущей версии 0.12.
 - Опция `MDBX_NOTLS` объявлена устаревшей и заменена на `MDBX_NOSTICKYTHREADS`.
 - Опция сборки `MDBX_USE_VALGRIND` заменена на общепринятую `ENABLE_MEMCHECK`.
 - В структуре `MDBX_envinfo` серии полей вида `meta1`, `meta2` и `meta3` заменены на массивы вида `meta[3]`.
 - В шаблонных классах и функциях С++ API по-умолчанию вместо `mdbx::legacy_buffer` использован тип `mdbx::default_buffer` использующий полиморфные аллокаторы С++ 17.
 - Удаление `DEFAULT_MAPSIZE` и изменение геометрии по-умолчанию при создании БД.
 - Возвращение `MDBX_TXN_INVALID` (`INT32_MIN`) вместо `-1`
   из `mdbx_txn_flags()` при передаче невалидной транзакции.

Исправления:

 - Исправление упущенного `TXN_END_EOTDONE` при сбое старта читающей транзакции.
   Упомянутый флажок отсутствовал в пути разрушения транзакции при ошибке
   её запуска. Из-за чего делалась попытка разрушить курсоры, что приводило
   к падению **отладочных сборок**, так как в них соответствующий массив
   намеренно заполнен некорректными указателями.

 - Устранение возможности `SIGSEGV` внутри `coherency_check()` после
   изменения геометрии другим процессом с увеличением верхнего размера БД
   и увеличением БД больше предыдущего лимита.

 - Исправление assert-проверки при попытке создания таблицы с другими флагами/опциями.

Мелочи:

 - Обновление конфигурации Doxygen до 1.9.6.
 - Добавление `--read-var-info=yes` для Valgrind.
 - Вывод из `mdbx_chk` информации об уровне детализации/verbosity.

## v0.13.0 от 2023-04-23

Технический тэг, отмечающий начало ветки `0.13`
с новым функционалом и изменением API.

********************************************************************************

## v0.12.13 от 2025-02-28

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов.

Это последний/консервирующий выпуск куста стабильных версий 0.12.x, спустя более двух
лет после выпуска 0.12.1.

```
git diff' stat: 14 commits, 7 files changed, 256 insertions(+), 103 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправлена обработка `MDBX_GET_MULTIPLE` в специальных случаях и одного значения у ключа в позиции курсора.

 - Устранена ошибка неверной обработки попытки запуска вложенной читающей транзакции.
   Теперь в таких ситуациях возвращается ошибка `MDBX_EINVAL`, так как вложенность
   поддерживается только для транзакций чтения-записи.

   Ошибка была внесена при рефакторинге, коммитом `2f2df1ee76ab137ee66d00af69a82a30dc0d6deb`
   чуть более 5 лет назад и долго оставалось не замеченной.

 - Поддержка получения boot_id при работе внутри LXC-контейнера.

   Из LXC-контейнера не доступен файл хостовой системы `/proc/sys/kernel/random/boot_id`.
   Вместо него, при каждом старте контейнера, создается и заполняется
   случайными данными собственный boot_id смонтированный через bind из `tmpfs`.
   https://github.com/lxc/lxc/issues/3027

   Ранее этот подставной/замещенный boot_id отбраковывался внутри libmdbx,
   так как файл располагается в `tmpfs`, а не в файловой системе `/proc`.
   В результате boot_id для проверки целостности БД не был доступен.
   Теперь при работе внутри LXC-контейнера такой bootid будет использоваться.

   Однако, полноценно работающий контроль по boot_id не возможен, так как при
   рестарте LXC-контейнера (но не хоста) boot_id будет меняться, хотя
   данные в unified page cache сохраняются.

   Таким образом, при рестарте LXC-контейнера без рестарта хоста, libmdbx придется
   откатить состояние БД до крайней точки устойчивой фиксации, что повлечет
   утрату данных пользователя в случаях когда они могли быть сохранены.
   Однако, улучшить ситуацию пока не представляется возможным, как минимум
   до доступности boot_id хостовой системы изнутри LXC-контейнера.

 - Доработан контроль длины ключа внутри `cursor_set()`.

   Ранее проверка внутри `cursor_set()` не позволяла искать ключи длиннее, чем можно поместить в таблицу.
   Однако, при поиске/позиционировании это не является ошибкой для таблиц с ключами переменного размера.

 - Теперь при попытке запуска вложенных транзакций в режиме `MDBX_WRITEMAP` производится
   логирование и возврат ошибки `MDBX_INCOMPATIBLE`.

 - Доработано использование `std::experimental::filesystem` для решения проблем со сборкой в старых компиляторах.

--------------------------------------------------------------------------------

## v0.12.12 "Доллежаль" от 2024-10-27

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в память о советском ученом-энергетике Николае Антоновиче Доллежаль в день 125-летия со дня его рождения.

Это последний выпуск куста стабильных версий 0.12.x, спустя более двух
лет после выпуска 0.12.1. Последующие выпуски 0.12.x будут формироваться
только в случае существенных проблем/ошибок, вероятность чего близка к
нулю. Для всех проектов находящихся в стадии активной разраборки
рекомендуется использовать ветку `master`.

```
git diff' stat: 6 commits, 5 files changed, 239 insertions(+), 6 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправление упущенного `TXN_END_EOTDONE` при сбое старта читающей транзакции.
   Упомянутый флажок отсутствовал в пути разрушения транзакции при ошибке
   её запуска. Из-за чего делалась попытка разрушить курсоры, что приводило
   к падению **отладочных сборок**, так как в них соответствующий массив
   намеренно заполнен некорректными указателями.

 - Устранение возможности `SIGSEGV` внутри `coherency_check()` после
   изменения геометрии другим процессом с увеличением верхнего размера БД
   и увеличением БД больше предыдущего лимита.

 - Доработка `mdbx_close_dbi()` для возврата ошибки при попытке закрыть
   dbi-дескриптор таблицы, созданной и/или измененной в ещё выполняющейся
   транзакции. Такое преждевременное закрытие дескриптора является неверным
   использованием API и нарушением контракта/предусловий сформулированных
   в описании `mdbx_close_dbi()`. Однако, вместо возврата ошибки
   выполнялось некорректное закрытие дескриптора, что могло приводить к
   созданию таблицы с пустым именем, утечки страниц БД и/или нарушению
   структуры b-tree (неверной ссылкой на корень таблицы).
   Добавлен соответствующий тест `extra/early_close_dbi`.

--------------------------------------------------------------------------------

## v0.12.11 "Лиза и Соня" от 2024-07-23

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в память об убитых в Крыму девочках 2 и 9 лет.

Лиза и Соня погибли 23 Июня 2024 на глазах у родителей, в результате
удара по общественному городскому пляжу ракетами ATACMS с кассетными
боеприпасами. Всего пострадало более 150 граждан России, в том числе 27
детей. Ракеты были выпущенными украинскими бандеровцами/фашистами, но
полетные задания формировались и загружались военными США, а управление
и наведение ATACAMS невозможно без использования орбитальной группировки
военных спутников США.

```
git diff' stat: 29 commits, 14 files changed, 379 insertions(+), 151 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправление для ОС Windows нарезки `FILE_SEGMENT_ELEMENT`.
   Похоже что был потерян коммит входе работы над оптимизацией пути записи
   на диск в ОС Windows. В текущем понимании, вероятность проявления ошибки
   достаточно низкая, так как выявлена она была синтетическими тестами в
   ходе других доработок, а соответствующих сообщений/жалоб не поступало. К
   повреждению БД ошибка не приводила, так как сбой происходил до записи
   данных с возвратом `ERROR_INVALID_PARAMETER` из системного вызова, т.е.
   либо ошибка не проявлялась, либо транзакция не фиксировалась.

 - Устранение вероятности `SIGSEGV` при включении логирования
   уровня `MDBX_LOG_TRACE` в отладочных сборках.

 - Исправление генерации исключения `key_exists` в C++ API.

 - Исправление опечаток в документации и README.

 - Исправление обработки курсоров, открытых в родительских транзакциях и
   закрытых до завершения вложенных транзакций. В описанной ситуации
   закрытые курсоры "воскрешались", что приводило к утечке памяти
   выделенной под такие курсоры.

 - Костыль для MSVC ARM/ARM64 для предотвращения ICE (Internal Compiler Error).

 - Устранение `MDBX_EINVAL` для случая вызова `mdbx_env_remove(".")`.

 - Исправление инверсии bool-результата `env::remove()` в C++ API.

 - Исправление опечатки `равно`/`неравно` в условии внутри
   `update_gc()`. Существенных последствий ошибки не было, но в
   определенных сценариях, сходимость требовала еще одного цикла повтора
   внутри update_gc().

Прочие доработки:

 - Проверка совместимости флагов GC/FreeDB на случай их изменения в будущих версиях.
 - Очистка сообщений `FormatMessageA()` от концевых переводов строк.
 - Уточнение макроса `__always_inline` для особо яблочных версий CLANG.
 - Использование `\n` вместо `std::endl` в C++ API для разделения строк в кодировщиках данных.
 - Проверка дополнительных и пока не используемых полей в meta-страницах.
 - Отключение ненужной отладки внутри `txn_merge()`.
 - Исправление условий и привязки к версиям компиляторов при формировании макроса `MDBX_DEPRECATED`.
 - Больше атрибутов `__cold` для редко-используемых функций (backport).
 - Добавление методов `buffer::append_bytes()` и `buffer::clear_and_reserve()`.
 - Отключение установки признака фатальной ошибки для не-активной среды при отличии идентификатора процесса.

--------------------------------------------------------------------------------

## v0.12.10 "СЭМ" от 2024-03-12

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов
в память Героя России гвардии майора Дмитрия Семёнова с позывным "СЭМ".

```
git diff' stat: 19 commits, 57 files changed, 751 insertions(+), 331 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - [Dvir H](https://t.me/Dvirsw) за [сообщение](https://t.me/libmdbx/5368)
   об ошибке `MDBX_CORRUPTED` в сценарии работы в режиме `MDBX_DUPFIXED` и нечетной длиной
   мульти-значений, с предоставлением точного минимального сценария воспроизведения.

Значимые исправления и доработки:

 - Устранение унаследованной от LMDB ошибки приводящей к повреждению БД при использовании `MDBX_DUPFIXED`.
   Проблема была выявлена при расширении тестов сценариями с длинными мульти-значениями в режиме `MDBX_DUPFIXED`.
   Сообщений о проявлении этой ошибки в эксплуатационных/продуктовых средах не поступало.

   На LEAF2-страниц, используемых для компактного хранения мульти-значений фиксированной длины,
   выполнялось резервирование места без учета возможности превышения размера страниц,
   с последующим переполнением, повреждением структуры БД и/или повреждением содержимого ОЗУ.

   Вероятность проявления ошибки существенно увеличивалась с увеличением размера/длины
   мульти-значений/дубликатов и уменьшением размера страницы БД. Поэтому при использовании `MDBX_INTEGERDUP`
   вероятность проявления близка к нулю, а сценарий такого проявления найти не удалось.

   В MDBX ошибка присутствовала с момента отделения проекта от LMDB,
   где эта ошибка присутствует более 11 лет, по настоящее время.

 - Исправление ложной ошибки `MDBX_CORRUPTED (-30796)` в сценарии работы
   в режиме `MDBX_DUPFIXED` и нечетной длиной мульти-значений.

 - Исправление недочета корректировки сопутствующих курсоров при разделении страницы
   по сценарию добавления пустой страницы слева.

 - Доработка `rebalance()` ради уменьшения WAF. Новый функционал, включая
   контролируемую пользователем опцию `enum MDBX_option_t`, будет доступен
   в выпусках ветки `0.13.x`, а в этом выпуске доработка сводится к тактике
   не-вовлечения чистой страницы при нехватке запаса страниц в ходе обновления GC,
   за счет ухудшения баланса дерева страниц.

 - Устранение упущения приводящего к нелогичной ситуации
   `me_dxb_mmap.curren > me_dxb_mmap.limit` при "дребезге" размера БД.
   В текущем понимании, последствий кроме срабатывания assert-проверки нет, а
   вероятность проявления близка к нулю.

 - Исправление в функционале обхода дерева, используемого утилитой
   `mdbx_chk`, подсчета места затраченного на выравнивание на вложенной
   под-странице, в случае нечетного количества dupfixed-элементов нечетного
   размера.
   Сообщений о проявлении этой ошибки в эксплуатационных/продуктовых средах не поступало.

 - Исправление assert-проверки внутри `check_txn()` для случая завершенных транзакций в режиме `MDBX_NO_TLS`.
   Последствий ошибки, кроме срабатывания assert-проверки в отладочных сборках, нет.

 - Устранение ошибки при открытии БД на файловой системе только-для-чтения.

 - Удалены излишне строгие проверки в утилите `mdbx_chk`, которые
   приводили к ложно-позитивным ошибкам при проверке БД после серии
   последних доработок. Подробности см в комментариях к коммитам [781b3f64d52b73cbaeb00a55811d1247c25624a8](https://gitflic.ru/project/erthink/libmdbx/commit/781b3f64d52b73cbaeb00a55811d1247c25624a8)
   и [0741c81cfd8dc0864fcf55e04192b2207c8f68f7](https://gitflic.ru/project/erthink/libmdbx/commit/0741c81cfd8dc0864fcf55e04192b2207c8f68f7).

Прочее:

 - Расширение стохастического теста dupfixed-сценариями.
 - Корректировка условия в assert-проверке для `MDBX_TXN_DRAINED_GC`.
 - Добавление в jitter-сценарий простого теста сброса и перезапуска читающих транзакций.
 - Вынужденное продолжение очистки/рефакторинга унаследованных ребусов в `cursor_put_nochecklen()`.
 - Фиксация транзакции при ошибках теста для последующего анализа содержимого БД.
 - Сопутствующий рефакторинг `node_shrink()` для ясности исходного кода.
 - Приведение в соответствие протоколируемых имен тестов опциям командной строки.
 - Добавление cmoke-теста `extra/dupfixed_addodd`.

--------------------------------------------------------------------------------

## v0.12.9 "Ясень-4" от 2023-12-11

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением недочетов.

```
git diff' stat: 32 commits, 8 files changed, 667 insertions(+), 401 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Исправления и доработки:

 - Ликвидация зависимости от ранее удаленной опции `MDBX_ENABLE_PREFAULT`, из-за
   чего опция `MDBX_ENABLE_MINCORE` не включалась автоматически, что приводило
   к не-активации соответствующего улучшения и не-достижению  декларируемого уровня
   производительности в сценариях использования в режиме `MDBX_WRITEMAP`.

 - Исправление авто-установки `MDBX_ENV_CHECKPID` при отключении использования
   функционала `madvise()` посредством опции сборки `MDBX_ENABLE_MADVISE=0`.
   Из-за чего при поддержке системой `madvise(MADV_DONTFORK)` не включался контроль pid.

 - Добавлена проверка переданного ключа на `NULL` при обработке `MDBX_GET_MULTIPLE`.

 - Добавлена проверка номеров корневых страниц в `coherency_check()`.

 - Обеспечен `const` для начала и конца диапазона в аргументах `mdbx_estimate_range()`.

 - Из разрабатываемой версии перенесены не-нарушающие совместимости доработки C++ API:

     - добавлен тип `mdbx::cursor::estimate_result`, а поведение методов
      `cursor::estimate()` унифицировано с `cursor::move()`;
     - для предотвращения незаметного неверного использования API, для инициализации
       возвращаемых по ссылке срезов, вместо пустых срезов задействован `slice::invalid()`;
     - добавлены дополнительные C++ операторы преобразования к типам C API;
     - для совместимости со старыми стандартами C++ и старыми версиями STL перенесены
       в public классы `buffer::move_assign_alloc` и `buffer::copy_assign_alloc`;
     - добавлен тип `mdbx::default_buffer`;
     - для срезов и буферов добавлены методы `hex_decode()`, `base64_decode()`, `base58_decode()`;
     - добавлен тип `mdbx::comparator` и функций `mdbx::default_comparator()`;
     - добавлены статические методы `buffer::hex()`, `base64()`, `base58()`;
     - для транзакций и курсоров добавлены методы `get_/set_context`;
     - добавлен метод `cursor::clone()`;

 - Поддержка base58 приведена в соответствии с черновиком RFC.

 - Переработка/исправление `to_hex()` и `from_hex()`.

 - Уменьшение `MDBX_opt_rp_augment_limit` по умолчанию до 1/3 от текущего количества страниц в БД.

Мелочи:

 - Удаление устаревших `mdbx_set_compare()` и `mdbx_set_dupsort()`.
 - Корректировка определения `MDBX_LAST_ADDED_ERRCODE`.
 - Добавление в C++ API забытого исключения `mdbx::duplicated_lck_file`.
 - Обновление патча для старых версий buildroot.
 - Использование в API `const MDBX_txn` где это возможно.
 - Удаление устаревшего упоминания `MDBX_EAGAIN`.
 - Проверка pid процесса только в функциях API требующих активной среды/env.
 - Исправление опечаток в комментариях, в том числе  в doxygen-описании.
 - В тестах для совместимости с проблемными версиями glibc и glibc++
   устранено использование `std::stoull()`.

--------------------------------------------------------------------------------

## v0.12.8 "Владимир Уткин" от 2023-10-17

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в день 100-летия со дня рождения выдающегося советского и российского ученого и конструктора [Влади́мира Фёдоровича У́ткина](https://ru.wikipedia.org/wiki/Уткин,_Владимир_Фёдорович).

```
git diff' stat: 24 commits, 18 files changed, 624 insertions(+), 94 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - [Alain Picard](https://github.com/castortech) за сообщение о проблеме
   с обработкой `MDBX_MULTIPLE` и помощь в тестировании.

Исправления и доработки:

 - Устранение регресса/ошибки в пути обработки `put(MDBX_MULTIPLE)` при пакетном/оптовом
   помещении в БД множественных значений одного ключа (aka multi-value или dupsort).
   Проявление проблемы зависит от компилятора и опций оптимизации/кодогенерации, но с большой вероятностью возвращается
   ошибка `MDBX_BAD_VALSIZE` (`-30781`), а в отладочных сборках срабатывает проверка `cASSERT(mc, !"Invalid key-size")`.
   Сценарии приводящие к другим проявлениям на данный момент не известны.

 - Реализована перезапись в `mdbx_put(MDBX_CURRENT)` всех текущих мульти-значений ключа
   при отсутствии флага `MDBX_NOOVERWRITE`. Ранее в такой ситуации возвращалась ошибка `MDBX_EMULTIVAL`.
   В текущем понимании новое поведение более удобно и не создаёт проблем совместимости с ранее написанным кодом.

 - Добавлена возможность использовать `mdbx_cursor_get(MDBX_GET_MULTIPLE)` без предварительной установки
   курсора, совмещая операцию пакетного получения данных с позиционированием курсора на передаваемый ключ.

 - Микрооптимизация и рефакторинг `cursor_put_nochecklen()` в продолжение исправления
   регресса/ошибки в пути обработки `put(MDBX_MULTIPLE)`.

 - Уточнение формулировок в описании API, в том числе пояснений о `SIGSEGV`
   и недопустимости прямого изменения данных.

Мелочи:

 - Исправление несущественных предупреждений при `MDBX_ENABLE_PROFGC=ON`.
 - Добавление `slice::as_pod<typename>()` в C++ API.
 - Добавление перегрузки `txn::put_multiple()` и контроля POD в C++ API.
 - Добавление smoke-теста для `put(MDBX_MULTIPLE)`.
 - Добавление дополнительных smoke-тестов в область видимости ctest.
 - Устранение жалоб Valgrind на инвариантное чтение неинициализированной памяти
   и утечки памяти в одном из тестов.
 - Костыль для глушения/игнорирования `EDEADLK` в ряде сценариев при
   использовании Valgrind или ASAN. В частности, это устраняет
   ложно-негативный результат проверки БД посредством `mdbx_chk -wc`,
   т.е. проверку БД в кооперативном (не эксклюзивном) режиме чтения-записи
   в сборках с поддержкой Valgrind или включеным ASAN. Для более подробной
   информации см. [соответствующий коммит](https://gitflic.ru/project/erthink/libmdbx/commit/1aead6869a7eff1a85e400ab3eeecb4c8b904fe6).
 - Доработка `mdbx_dump_val()` используемой для логирования и отладки.
 - Устранение предупреждений Valgrind при логировании в отладочных сборках.
 - Доработка использования `filesystem` для старых компиляторов.
 - Сокращение излишнего вызова `osal_thread_self()`.
 - Вывод информации о большинстве mdbx-опций при сборке посредством CMake.
 - Добавление определений макросов для Doxygen.

--------------------------------------------------------------------------------

## v0.12.7 "Артек" от 2023-06-16

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением
недочетов, в день основания международного детского центра [«Арте́к»](https://ru.wikipedia.org/wiki/Артек).

```
14 files changed, 222 insertions(+), 56 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Исправления и доработки:

  - Исправление опечатки в имени переменной внутри `mdbx_env_turn_for_recovery()`,
    что приводило к неверному поведению в некоторых ситуациях.

    С точки зрения пользователя, с учетом актуальных сценариев использования
    утилиты `mdbx_chk`, был только один специфический/редкий сценарий
    проявления ошибки/проблемы - когда выполнялась проверка и активация
    слабой/weak мета-страницы с НЕ-последней транзакцией после системной
    аварии машины, где БД использовалась в хрупком/небезопасном режиме.
    В сценарии, при успешной проверке целевой страницы и её последующей
    активации выводилось сообщение об ошибке, связанной со срабатыванием
    механизма контроля не-когерентности кэша файловой системы и отображенных
    в ОЗУ данных БД. При этом БД успешно восстанавливалось и не было
    каких-либо негативных последствия, кроме самого сообщения об ошибке.

    Технически же ошибка проявлялась при "переключении" на мета-страницу,
    когда у хотя-бы одной из двух других мета-страниц номер транзакции был
    больше:

      * Если содержимое других мета-страниц было корректным, а номера
        связанных транзакций были больше, то результирующий номер транзакции в
        целевой/активируемой мета-страницы устанавливается без учета этих
        мета-страниц и мог быть меньше-или-равным.

      * В результате, если такие мета-страницы были в статусе слабых/weak, то
        при закрытии БД после переключения могла срабатывать защита от
        не-когерентности unified buffer/page cache, а в отладочных сборках могла
        срабатывать assert-проверка.

      * Если же такие мета-страницы были в статусе сильных/steady, то
        переключение на новую мета-страницу могло не давать эффекта либо
        приводить к появлению двух мета-страниц с одинаковым номером транзакции,
        что является ошибочной ситуацией.

  - Обходное решение проблем сборки посредством GCC с использование опций `-m32 -arch=i686 -Ofast`.
    Проблема обусловлена ошибкой GCC, из-за которой конструкция `__attribute__((__target__("sse2")))`
    не включает полноценное использование инструкций SSE и SSE2, если это не было сделано посредством
    опций командной строки, но была использована опция `-Ofast`. В результате сборка заканчивалась
    сообщением об ошибке:
        `error: inlining failed in call to 'always_inline' '_mm_movemask_ps': target specific option mismatch`

  - Доработка режима "восстановления" БД и переключения на заданную мета-страницу:
      * Устранение обновления без необходимости мета-страницы с увеличением номера транзакции;
      * Устранение вывода (логирования) бессмысленного/лишнего предупреждения о пропуске обновления геометрии БД;
      * Более ожидаемое и безопасное поведение при проверке БД с указанием целевой мета-страницы в режиме чтения-записи.

    Теперь при открытии БД посредством `mdbx_env_open_for_recovery()` не
    выполняется неявное изменение/обновление БД, в том числе при закрытии
    БД. Это позволяет обезопасить БД (снизить шанс её разрушения) если
    пользователь при попытке восстановления, либо просто в качестве
    эксперимента, задал утилите `mdbx_chk` неверную или опасную комбинацию
    параметров. При этом обычная проверка, как и явное переключение
    мета-страниц, работают по-прежнему.

Мелочи:

 - Незначительное уточнение CMake-пробника для `std::filesystem`,
   проверяющего необходимость линковки с дополнительными библиотеками C++.
 - Устранение минорных предупреждений старых компиляторов в тестах.
 - Устранение причины ложно-позитивного предупреждения новых версий GCC в C++ API.
 - Исправление ссылки на репозиторий бенчмарка ioarena.
 - Добавление перекрестных ссылок в doxygen-документацию по C++ API.
 - Уточнение ограничений в разделе [Restrictions & Caveats](https://libmdbx.dqdkfa.ru/intro.html#restrictions).
 - Исправление ссылок на описание `mdbx_canary_put()`.

--------------------------------------------------------------------------------

## v0.12.6 "ЦСКА" от 2023-04-29

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением
недочетов, в день 100-летнего юбилея спортивного клуба [«ЦСКА»](https://ru.wikipedia.org/wiki/Центральный_спортивный_клуб_Армии).

```
14 files changed, 117 insertions(+), 83 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Мелочи:

 - Обновление патча для старых версий buildroot.
 - Использование clang-format-16.
 - Использование `enum`-типов вместо `int` для устранения предупреждений GCC 13,
   что могло ломать сборку в Fedora 38.

--------------------------------------------------------------------------------

## v0.12.5 "Динамо" от 2023-04-18

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением
недочетов, в день 100-летнего юбилея спортивного общества [«Динамо»](https://ru.wikipedia.org/wiki/Динамо_(спортивное_общество)).

```
16 files changed, 686 insertions(+), 247 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - Max <maxc0d3r@protonmail.com> за сообщение о проблеме экспорта из DSO/DLL
   устаревших функций API.
 - [`@calvin3721`](https://t.me/calvin3721) за сообщение о проблеме работы
   `MainDB` с флагами не по-умолчанию.

Исправления:

 - Поправлен экспорт из DSO/DLL устаревших функций,
   которые заменены на inline в текущем API.
 - Устранено использование неверного компаратора при создании или пересоздании
   `MainDB` с флагами/опциями предполагающим использование специфического
   компаратора (не по-умолчанию).

Мелочи:

 - Удалена дублирующая диагностика внутри `node_read_bigdata()`.
 - Исправлены ссылки в описании `mdbx_env_set_geometry()`.
 - Добавлен отдельный тест `extra/upsert_alldups` для специфического
   сценария замены/перезаписи одним значением всех multi-значений
   соответствующих ключу, т.е. замена всех «дубликатов» одним значением.
 - В C++ API добавлены варианты `buffer::key_from()` с явным именованием по типу данных.
 - Добавлен отдельный тест `extra/maindb_ordinal` для специфического
   сценария создания `MainDB` с флагами требующими использования
   компаратора не по-умолчанию.
 - Рефакторинг проверки "когерентности" мета-страниц.
 - Корректировка `osal_vasprintf()` для устранения предупреждений статических анализаторов.

--------------------------------------------------------------------------------

## v0.12.4 "Арта-333" от 2023-03-03

Стабилизирующий выпуск с исправлением обнаруженных ошибок, устранением
недочетов и технических долгов. Ветка 0.12 считается готовой к
продуктовому использованию, получает статус стабильной и далее будет
получать только исправление ошибок. Разработка будет продолжена в ветке
0.13, а ветка 0.11 становится архивной.

```
63 files changed, 1161 insertions(+), 569 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - Max <maxc0d3r@protonmail.com> за сообщение о проблеме ERROR_SHARING_VIOLATION
   в режиме MDBX_EXCLUSIVE на Windows.
 - Alisher Ashyrov <https://t.me/a1is43ras4> за сообщение о проблеме
   с assert-проверкой и содействие в отладке.
 - Masatoshi Fukunaga <https://gitflic.ru/user/mah0x211> за сообщение о проблеме
   `put(MDBX_UPSERT+MDBX_ALLDUPS)` для случая замены всех значений в subDb.

Исправления:

 - Устранен регресс после коммита 474391c83c5f81def6fdf3b0b6f5716a87b78fbf,
   приводящий к возврату ERROR_SHARING_VIOLATION в Windows при открытии БД
   в режиме MDBX_EXCLUSIVE для чтения-записи.

 - Добавлено ограничение размера отображения при коротком read-only файле, для
   предотвращения ошибки ERROR_NOT_ENOUGH_MEMORY в Windows, которая возникает
   в этом случае и совсем не информативна для пользователя.

 - Произведен рефакторинг `dxb_resize()`, в том числе, для устранения срабатывания
   assert-проверки `size_bytes == env->me_dxb_mmap.current` в специфических
   многопоточных сценариях использования. Проверка срабатывала только в
   отладочных сборках, при специфическом наложении во времени читающей и
   пишущей транзакции в разных потоках, одновременно с изменением размера БД.
   Кроме срабатывание проверки, каких-либо других последствий не возникало.

 - Устранена проблема в `put(MDBX_UPSERT+MDBX_ALLDUPS)` для случая замены
   всех значений единственного ключа в subDb. В ходе этой операции subDb
   становится полностью пустой, без каких-либо страниц и именно эта
   ситуация не была учтена в коде, что приводило к повреждению БД
   при фиксации такой транзакции.

 - Устранена излишняя assert-проверка внутри `override_meta()`.
   Что в отладочных сборках могло приводить к ложным срабатываниям
   при восстановлении БД, в том числе при автоматическом откате слабых
   мета-страниц.

 - Скорректированы макросы `__cold`/`__hot`, в том числе для устранения проблемы
   `error: inlining failed in call to ‘always_inline FOO(...)’: target specific option mismatch`
   при сборке посредством GCC >10.x для SH4.

Ликвидация технических долгов и мелочи:

 - Исправлены многочисленные опечатки в документации.
 - Доработан тест для полной стохастической проверки `MDBX_EKEYMISMATCH` в режиме `MDBX_APPEND`.
 - Расширены сценарии запуска `mdbx_chk` из CMake-тестов для проверки как в обычном,
   так и эксклюзивном режимах чтения-записи.
 - Уточнены спецификаторы `const` и `noexcept` для нескольких методов в C++ API.
 - Устранено использование стека под буферы для `wchar`-преобразования путей.
 - Для Windows добавлена функция `mdbx_env_get_path()` для получения пути к БД
   в формате многобайтных символов.
 - Добавлены doxygen-описания для API с широкими символами.
 - Устранены предупреждения статического анализатора MSVC,
   все они были несущественные, либо ложные.
 - Устранено ложное предупреждение GCC при сборке для SH4.
 - Добавлена поддержка ASAN (Address Sanitizer) при сборке посредством MSVC.
 - Расширен набор перебираемых режимов в скрипте `test/stochastic.sh`,
   добавлена опция `--extra`.
 - В C++ API добавлена поддержка расширенных опций времени выполнения `mdbx::extra_runtime_option`,
   аналогично `enum MDBX_option_t` из C API.
 - Вывод всех счетчиков page-operations в `mdbx_stat`.

--------------------------------------------------------------------------------

## v0.12.3 "Акула" от 2023-01-07

Выпуск с существенными доработками и новой функциональностью в память о закрытом open-source
[проекте "Акула"](https://erigon.substack.com/p/winding-down-support-for-akula-project).

Добавлена prefault-запись, переделан контроль “некогерентности” unified page/buffer cache, изменена тактика слияния страниц и т.д.
Стало ещё быстрее, в некоторых сценариях вдвое.

```
20 files changed, 4508 insertions(+), 2928 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - [Alex Sharov](https://t.me/AskAlexSharov) и команде [Erigon](https://github.com/ledgerwatch/erigon) за тестирование.
 - [Simon Leier](https://t.me/leisim) за сообщение о сбоях и тестирование.

Новое:

 - Использование адреса [https://libmdbx.dqdkfa.ru/dead-github](https://libmdbx.dqdkfa.ru/dead-github)
   для отсылки к сохранённым в web.archive.org копиям ресурсов, уничтоженных администрацией Github.

 - Реализована prefault-запись при выделении страниц для read-write отображений.
   Это приводит к кратному снижению системных издержек и существенному увеличению
   производительности в соответствующих сценариях использования, когда:
    - размер БД и объём данных существенно больше ОЗУ;
    - используется режим `MDBX_WRITEMAP`;
    - не-мелкие транзакции (по ходу транзакции выделяется многие сотни или тысячи страниц).

   В режиме `MDBX_WRITEMAP` выделение/переиспользование страниц приводит
   к page-fault и чтению страницы с диска, даже если содержимое страницы
   не нужно (будет перезаписано). Это является следствием работы подсистемы
   виртуальной памяти, а штатный способ лечения через `MADV_REMOVE`
   работает не на всех ФС и обычно дороже получаемой экономии.

   Теперь в libmdbx используется "упреждающая запись" таких страниц,
   которая на системах с [unified page cache](https://www.opennet.ru/base/dev/ubc.txt.html)
   приводит к "вталкиванию" данных, устраняя необходимость чтения с диска при
   обращении к такой странице памяти.

   Новый функционал работает в согласованности с автоматическим управлением read-ahead
   и кэшем статуса присутствия страниц в ОЗУ, посредством [mincore()](https://man7.org/linux/man-pages/man2/mincore.2.html).

 - Добавлена опция `MDBX_opt_prefault_write_enable` для возможности принудительного
   включения/выключения prefault-записи.

 - Реализован динамический выбор между сквозной записью на диск и обычной записью
   с последующим [fdatasync()](https://man7.org/linux/man-pages/man3/fdatasync.3p.html)
   управляемый опцией `MDBX_opt_writethrough_threshold`.

   В долговечных (durable) режимах данные на диск могут быть сброшены двумя способами:
     - сквозной записью через файловый дескриптор открытый с `O_DSYNC`;
     - обычной записью с последующим вызовом `fdatasync()`.

   Первый способ выгоднее при записи малого количества страниц и/или если
   канал взаимодействия с диском/носителем имеет близкую к нулю задержку.
   Второй способ выгоднее если требуется записать много страниц и/или канал
   взаимодействия имеет весомую задержку (датацентры, облака). Добавленная
   опция `MDBX_opt_writethrough_threshold` позволяет во время выполнения
   задать порог для динамического выбора способа записи в зависимости от
   объема и конкретных условия использования.

 - Автоматическая установка `MDBX_opt_rp_augment_limit` в зависимости от размера БД.

 - Запрещение разного режима `MDBX_WRITEMAP` между процессами в режимах
   с отложенной/ленивой записью, так как в этом случае невозможно
   обеспечить сброс данных на диск во всех случаях на всех поддерживаемых платформах.

 - Добавлена опция сборки `MDBX_MMAP_USE_MS_ASYNC` позволяющая отключить
   использование системного вызова `msync(MS_ASYNC)`, в использовании
   которого нет необходимости на подавляющем большинстве актуальных ОС.
   По-умолчанию `MDBX_MMAP_USE_MS_ASYNC=0` (выключено) на Linux и других
   системах с unified page cache. Такое поведение (без использования
   `msync(MS_ASYNC)`) соответствует неизменяемой (hardcoded) логике LMDB. В
   результате, в простых/наивных бенчмарках, libmdbx опережает LMDB
   примерно также как при реальном применении.

   На всякий случай стоит еще раз отметить/напомнить, что на Windows
   предположительно libmdbx будет отставать от LMDB в сценариях с
   множеством мелких транзакций, так как libmdbx осознанно использует на
   Windows файловые блокировки, которые медленные (плохо реализованы в ядре
   ОС), но позволяют застраховать пользователей от массы неверных действий
   приводящих к повреждению БД.

 - Поддержка не-печатных имен для subDb.

 - Добавлен явный выбор `tls_model("local-dynamic")` для обхода проблемы
   `relocation R_X86_64_TPOFF32 against FOO cannot be used with -shared`
   из-за ошибки в CLANG приводящей к использованию неверного режима `tls_model`.

 - Изменение тактики слияния страниц при удалении.
   Теперь слияние выполняется преимущественно с уже измененной/грязной страницей.
   Если же справа и слева обе страницы с одинаковым статусом,
   то с наименее заполненной, как прежде. В сценариях с массивным удалением
   это позволяет увеличить производительность до 50%.

 - Добавлен контроль отсутствия LCK-файлов с альтернативным именованием.

Исправления (без корректировок новых функций):

 - Изменение размера отображения если это требуется для сброса данных на
   диск при вызове `mdbx_env_sync()` из параллельного потока выполнения вне
   работающей транзакции.

 - Исправление регресса после коммита db72763de049d6e4546f838277fe83b9081ad1de от 2022-10-08
   в логике возврата грязных страниц в режиме `MDBX_WRITEMAP`, из-за чего
   освободившиеся страницы использовались не немедленно, а попадали в
   retired-список совершаемой транзакции и происходил необоснованный рост
   размера транзакции.

 - Устранение SIGSEGV или ошибочного вызова `free()` в ситуациях
   повторного открытия среды посредством `mdbx_env_open()`.

 - Устранение ошибки совершенной в коммите fe20de136c22ed3bc4c6d3f673e79c106e824f60 от 2022-09-18,
   в результате чего на Linux в режиме `MDBX_WRITEMAP` никогда не вызывался `msync()`.
   Проблема существует только в релизе 0.12.2.

 - Добавление подсчета грязных страниц в `MDBX_WRITEMAP` для предоставления посредством `mdbx_txn_info()`
   актуальной информации об объеме изменений в процессе транзакций чтения-записи.

 - Исправление несущественной опечатки в условиях `#if` определения порядка байт.

 - Исправление сборки для случая `MDBX_PNL_ASCENDING=1`.

Ликвидация технических долгов и мелочи:

 - Доработка поддержки авто-слияния записей GC внутри `page_alloc_slowpath()`.
 - Устранение несущественных предупреждений Coverity.
 - Использование единого курсора для поиска в GC.
 - Переработка внутренних флагов связанных с выделением страниц из GC.
 - Доработка подготовки резерва перед обновлением GC при включенном BigFoot.
 - Оптимизация `pnl_merge()` для случаев неперекрывающихся объединяемых списков.
 - Оптимизация поддержки отсортированного списка страниц в `dpl_append()`.
 - Ускорение работы `mdbx_chk` при обработке пользовательских записей в `@MAIN`.
 - Переработка LRU-отметок для спиллинга.
 - Переработка контроля "некогерентности" Unified page cache для уменьшения накладных расходов.
 - Рефакторинг и микрооптимизация.

--------------------------------------------------------------------------------

## v0.12.2 "Иван Ярыгин" от 2022-11-11

Выпуск с существенными доработками и новой функциональностью
в память о российском борце [Иване Сергеевиче Ярыгине](https://ru.wikipedia.org/wiki/Ярыгин,_Иван_Сергеевич).

На Олимпийских играх в Мюнхене в 1972 году Иван Ярыгин уложил всех соперников на лопатки,
суммарно затратив менее 9 минут. Этот рекорд никем не побит до сих пор.

```
64 files changed, 5573 insertions(+), 2510 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Новое:

 - Поддержка всех основных опций при сборке посредством CMake.

 - Требования к CMake понижены до версии 3.0.2 для возможности сборки для устаревших платформ.

 - Добавлена возможность профилирования работы GC в сложных и/или нагруженных
   сценариях (например Ethereum/Erigon). По-умолчанию соответствующий код отключен,
   а для его активации необходимо указать опцию сборки `MDBX_ENABLE_PROFGC=1`.

 - Добавлена функция `mdbx_env_warmup()` для "прогрева" БД с возможностью
   закрепления страниц в памяти.
   В утилиты `mdbx_chk`, `mdbx_copy` и `mdbx_dump` добавлены опции `-u` и `-U`
   для активации соответствующего функционала.

 - Отключение учета «грязных» страниц в не требующих этого режимах
   (`MDBX_WRITEMAP` при `MDBX_AVOID_MSYNC=0`). Доработка позволяет снизить
   накладные расходы и была запланирована давно, но откладывалась так как
   требовала других изменений.

 - Вытеснение из памяти (спиллинг) «грязных» страниц с учетом размера
   large/overflow-страниц. Доработка позволяет корректно соблюдать политику
   задаваемую опциями `MDBX_opt_txn_dp_limit`,
   `MDBX_opt_spill_max_denominator`, `MDBX_opt_spill_min_denominator` и
   была запланирована давно, но откладывалась так как требовала других
   изменений.

 - Для Windows в API добавлены UNICODE-зависимые определения макросов
  `MDBX_DATANAME`, `MDBX_LOCKNAME` и `MDBX_LOCK_SUFFIX`.

 - Переход на преимущественное использование типа `size_t` для
   уменьшения накладных расходов на платформе Эльбрус.

 - В API добавлены функции `mdbx_limits_valsize4page_max()` и
   `mdbx_env_get_valsize4page_max()` возвращающие максимальный размер в
   байтах значения, которое может быть размещена в одной
   large/overflow-странице, а не последовательности из двух или более таких
   страниц. Для таблиц с поддержкой дубликатов вынос значений на
   large/overflow-страницы не поддерживается, поэтому результат совпадает с
   `mdbx_limits_valsize_max()`.

 - В API добавлены функции `mdbx_limits_pairsize4page_max()`и
   `mdbx_env_get_pairsize4page_max()` возвращающие в байтах максимальный
   суммарный размер пары ключ-значение для их размещения на одной листовой
   страницы, без выноса значения на отдельную large/overflow-страницу. Для
   таблиц с поддержкой дубликатов вынос значений на large/overflow-страницы
   не поддерживается, поэтому результат определяет максимальный/допустимый
   суммарный размер пары ключ-значение.

 - Реализовано использование асинхронной (overlapped) записи в Windows,
   включая использования небуферизированного ввода-вывода и `WriteGather()`.
   Это позволяет сократить накладные расходы и частично обойти проблемы
   Windows с низкой производительностью ввода-вывода, включая большие
   задержки `FlushFileBuffers()`. Новый код также обеспечивает консолидацию
   записываемых регионов на всех платформах, а на Windows использование
   событий (events) сведено к минимум, одновременно с автоматических
   использованием `WriteGather()`. Поэтому ожидается существенное снижение
   накладных расходов взаимодействия с ОС, а в Windows это ускорение, в
   некоторых сценариях, может быть кратным в сравнении с LMDB.

 - Добавлена опция сборки `MDBX_AVOID_MSYNC`, которая определяет
   поведение libmdbx в режиме `MDBX_WRITE_MAP` (когда данные изменяются
   непосредственно в отображенных в ОЗУ страницах БД):

    * Если `MDBX_AVOID_MSYNC=0` (по умолчанию на всех системах кроме Windows),
      то (как прежде) сохранение данных выполняется посредством `msync()`,
      либо `FlushViewOfFile()` на Windows. На платформах с полноценной
      подсистемой виртуальной памяти и адекватным файловым вводом-выводом
      это обеспечивает минимум накладных расходов (один системный вызов)
      и максимальную производительность. Однако, на Windows приводит
      к значительной деградации, в том числе из-за того что после
      `FlushViewOfFile()` требуется также вызов `FlushFileBuffers()`
      с массой проблем и суеты внутри ядра ОС.

    * Если `MDBX_AVOID_MSYNC=1` (по умолчанию только на Windows), то
      сохранение данных выполняется явной записью в файл каждой измененной
      страницы БД. Это требует дополнительных накладных расходов, как
      на отслеживание измененных страниц (ведение списков "грязных"
      страниц), так и на системные вызовы для их записи.
      Кроме этого, с точки зрения подсистемы виртуальной памяти ядра ОС,
      страницы БД измененные в ОЗУ и явно записанные в файл, могут либо
      оставаться "грязными" и быть повторно записаны ядром ОС позже,
      либо требовать дополнительных накладных расходов для отслеживания
      PTE (Page Table Entries), их модификации и дополнительного копирования
      данных. Тем не менее, по имеющейся информации, на Windows такой путь
      записи данных в целом обеспечивает более высокую производительность.

 - Улучшение эвристики включения авто-слияния записей GC.

 - Изменение формата LCK и семантики некоторых внутренних полей. Версии
   libmdbx использующие разный формат не смогут работать с одной БД
   одновременно, а только поочередно (LCK-файл переписывается при открытии
   первым открывающим БД процессом).

 - В `C++` API добавлены методы фиксации транзакции с получением информации
   о задержках.

 - Added `MDBX_HAVE_BUILT IN_CPU_SUPPORTS` build option to control use GCC's
   `__builtin_cpu_supports()` function, which could be unavailable on a fake
   OSes (macos, ios, android, etc).

Исправления (без корректировок вышеперечисленных новых функций):

 - Устранения ряда предупреждений при сборке посредством MinGW.
 - Устранение ложно-положительных сообщений от Valgrind об использовании
   не инициализированных данных из-за выравнивающих зазоров в `struct troika`.
 - Исправлен возврат неожиданной ошибки `MDBX_BUSY` из функций `mdbx_env_set_option()`,
   `mdbx_env_set_syncbytes()` и `mdbx_env_set_syncperiod()`.
 - Небольшие исправления для совместимости с CMake 3.8
 - Больше контроля и осторожности (паранойи) для страховки от дефектов `mremap()`.
 - Костыль для починки сборки со старыми версиями `stdatomic.h` из GNU Lib C,
   где макросы `ATOMIC_*_LOCK_FREE` ошибочно переопределяются через функции.
 - Использование `fcntl64(F_GETLK64/F_SETLK64/F_SETLKW64)` при наличии.
   Это решает проблему срабатывания проверочного утверждения при сборке для
   платформ где тип `off_t` шире соответствующих полей `структуры flock`,
   используемой для блокировки файлов.
 - Доработан сбор информации о задержках при фиксации транзакций:
    * Устранено искажение замеров длительности обновления GC
      при включении отладочного внутреннего аудита;
    * Защита от undeflow-нуля только общей задержки в метриках,
      чтобы исключить ситуации, когда сумма отдельных стадий
      больше общей длительности.
 - Ряд исправлений для устранения срабатываний проверочных утверждения в
   отладочных сборках.
 - Более осторожное преобразование к типу `mdbx_tid_t` для устранения
   предупреждений.
 - Исправление лишнего сброса данных на диск в режиме `MDBX_SAFE_NOSYNC`
   при обновлении GC.
 - Fixed an extra check for `MDBX_APPENDDUP` inside `mdbx_cursor_put()`
   which could result in returning `MDBX_EKEYMISMATCH` for valid cases.
 - Fixed nasty `clz()` bug (by using `_BitScanReverse()`, only MSVC builds affected).

Мелочи:

 - Исторические ссылки cвязанные с удалённым на ~~github~~ проектом  перенаправлены на [web.archive.org](https://web.archive.org/web/https://github.com/erthink/libmdbx).
 - Синхронизированы конструкции CMake между проектами.
 - Добавлено предупреждение о небезопасности RISC-V.
 - Добавлено описание параметров `MDBX_debug_func` и `MDBX_debug_func`.
 - Добавлено обходное решение для минимизации ложно-положительных
   конфликтов при использовании файловых блокировок в Windows.
 - Проверка атомарности C11-операций c 32/64-битными данными.
 - Уменьшение в 42 раза значения по-умолчанию для `me_options.dp_limit`
   в отладочных сборках.
 - Добавление платформы `gcc-riscv64-linux-gnu` в список для цели `cross-gcc`.
 - Небольшие правки скрипта `stochastic.sh` для работы в Windows.
 - Удаление ненужного вызова `LockFileEx()` внутри `mdbx_env_copy()`.
 - Добавлено описание использования файловых дескрипторов в различных режимах.
 - Добавлено использование `_CrtDbgReport()` в отладочных сборках.
 - Fixed an extra ensure/assertion check of `oldest_reader` inside `txn_end()`.
 - Removed description of deprecated usage of `MDBX_NODUPDATA`.
 - Fixed regression ASAN/Valgring-enabled builds.
 - Fixed minor MingGW warning.

--------------------------------------------------------------------------------

## v0.12.1 "Positive Proxima" at 2022-08-24

The planned frontward release with new superior features on the day of 20 anniversary of [Positive Technologies](https://ptsecurty.com).

```
37 files changed, 7604 insertions(+), 7417 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

New:

 - The `Big Foot` feature which significantly reduces GC overhead for processing large lists of retired pages from huge transactions.
   Now _libmdbx_ avoid creating large chunks of PNLs (page number lists) which required a long sequences of free pages, aka large/overflow pages.
   Thus avoiding searching, allocating and storing such sequences inside GC.
 - Improved hot/online validation and checking of database pages both for more robustness and performance.
 - New solid and fast method to latch meta-pages called `Troika`.
   The minimum of memory barriers, reads, comparisons and conditional transitions are used.
 - New `MDBX_VALIDATION` environment options to extra validation of DB structure and pages content for carefully/safe handling damaged or untrusted DB.
 - Accelerated ×16/×8/×4 by AVX512/AVX2/SSE2/Neon implementations of search page sequences.
 - Added the `gcrtime_seconds16dot16` counter to the "Page Operation Statistics" that accumulates time spent for GC searching and reclaiming.
 - Copy-with-compactification now clears/zeroes unused gaps inside database pages.
 - The `C` and `C++` APIs has been extended and/or refined to simplify using `wchar_t` pathnames.
   On Windows the `mdbx_env_openW()`, `mdbx_env_get_pathW()`, `mdbx_env_copyW()`, `mdbx_env_open_for_recoveryW()` are available for now,
   but the `mdbx_env_get_path()` has been replaced in favor of `mdbx_env_get_pathW()`.
 - Added explicit error message for Buildroot's Microblaze toolchain maintainers.
 - Added `MDBX_MANAGE_BUILD_FLAGS` build options for CMake.
 - Speed-up internal `bsearch`/`lower_bound` implementation using branchless tactic, including workaround for CLANG x86 optimiser bug.
 - A lot internal refinement and micro-optimisations.
 - Internally counted volume of dirty pages (unused for now but for coming features).

Fixes:

 - Never use modern `__cxa_thread_atexit()` on Apple's OSes.
 - Don't check owner for finished transactions.
 - Fixed typo in `MDBX_EINVAL` which breaks MingGW builds with CLANG.

## v0.12.0 at 2022-06-19

Not a release but preparation for changing feature set and API.

********************************************************************************

For early releases and changes see the ChangeLog-NN the git commit history.
