# frozen_string_literal: true

RSpec::Matchers.define :have_vulnerability_dismissal_feedback do
  match do |finding|
    expect(finding.dismissal_feedback).to have_attributes(project: finding.vulnerability.project,
                                                          category: finding.report_type,
                                                          project_fingerprint: finding.project_fingerprint)
  end
end

RSpec::Matchers.define_negated_matcher :not_have_vulnerability_dismissal_feedback, :have_vulnerability_dismissal_feedback
