# frozen_string_literal: true

module VulnerabilityExportsHelpers
  def csv_headers
    ['Group Name', 'Project Name', 'Tool', 'Scanner Name', 'Status',
     'Vulnerability', 'Details', 'Additional Info', 'Severity', 'CVE',
     'CWE', 'Other Identifiers', 'Detected At', 'Location', 'Activity', 'Comments']
  end

  def other_identifiers
    '"GSO-1234;1234"; TSO-1234'
  end

  # JH tests require a project with repository, but EE tests do not
  # So define the create project method here so that JH can override it
  def project_with_valid_findings(opts = {})
    create(:project, :public, opts)
  end
end

VulnerabilityExportsHelpers.prepend_mod
