import { DASHBOARD_TYPES } from 'ee/security_dashboard/store/constants';
import initVulnerabilityReport from 'ee/security_dashboard/vulnerability_report_init';
import setWindowLocation from 'helpers/set_window_location_helper';
import { TEST_HOST } from 'helpers/test_constants';

const EMPTY_DIV = document.createElement('div');

const TEST_DATASET = {
  emptyStateSvgPath: '/test/empty_state.svg',
  hasVulnerabilities: true,
  link: '/test/link',
  noVulnerabilitiesSvgPath: '/test/no_vulnerability_state.svg',
  svgPath: '/test/no_changes_state.svg',
  securityDashboardEmptySvgPath: 'surveyRequest.svg',
  vulnerabilitiesExportEndpoint: '/test/export-vulnerabilities',
};

describe('Vulnerability Report', () => {
  let vm;
  let root;

  beforeEach(() => {
    root = document.createElement('div');
    document.body.appendChild(root);

    setWindowLocation(`${TEST_HOST}/-/security/vulnerabilities`);
  });

  afterEach(() => {
    if (vm) {
      vm.$destroy();
    }
    root.remove();
  });

  const createComponent = ({ data, type }) => {
    const el = document.createElement('div');
    Object.assign(el.dataset, { ...TEST_DATASET, ...data });
    root.appendChild(el);
    vm = initVulnerabilityReport(el, type);
  };

  const createEmptyComponent = () => {
    vm = initVulnerabilityReport(null, null);
  };

  describe('default states', () => {
    it('sets up project-level', () => {
      createComponent({
        data: {
          pipelineSecurityBuildsFailedCount: 1,
          pipelineSecurityBuildsFailedPath: '/test/faild_pipeline_02',
          projectFullPath: '/test/project',
          securityConfigurationPath: '/test/configuration',
        },
        type: DASHBOARD_TYPES.PROJECT,
      });

      // These assertions will be expanded in issue #220290
      expect(root).not.toStrictEqual(EMPTY_DIV);
    });

    it('sets up group-level', () => {
      createComponent({ data: { groupFullPath: '/test/' }, type: DASHBOARD_TYPES.GROUP });

      // These assertions will be expanded in issue #220290
      expect(root).not.toStrictEqual(EMPTY_DIV);
    });

    it('sets up instance-level', () => {
      createComponent({
        data: { instanceDashboardSettingsPath: '/instance/settings_page' },
        type: DASHBOARD_TYPES.INSTANCE,
      });

      // These assertions will be expanded in issue #220290
      expect(root).not.toStrictEqual(EMPTY_DIV);
    });
  });

  describe('error states', () => {
    it('does not have an element', () => {
      createEmptyComponent();

      expect(root).toStrictEqual(EMPTY_DIV);
    });

    it('has unavailable pages', () => {
      createComponent({ data: { isUnavailable: true } });

      expect(root).toMatchSnapshot();
    });
  });
});
