# frozen_string_literal: true

module VulnerabilityExports
  class CreateService
    include Gitlab::Allowable

    attr_reader :exportable, :author, :format

    def initialize(exportable, author, format:)
      @exportable = exportable
      @author = author
      @format = format
    end

    def execute
      raise Gitlab::Access::AccessDeniedError unless can?(author, :create_vulnerability_export, exportable)

      vulnerability_export = Vulnerabilities::Export.create(exportable: exportable, format: format, author: author)
      ::VulnerabilityExports::ExportWorker.perform_async(vulnerability_export.id)
      vulnerability_export
    end
  end
end
