# frozen_string_literal: true

class VulnerabilityPolicy < BasePolicy
  delegate { @subject.project }

  # Only users who can read vulnerability can comment.
  # It would not be safe to prevent :create_note in project policy,
  # since note permissions are shared, and this can have ripple effect on other parts.
  rule { ~can?(:read_security_resource) }.prevent :create_note
end
